/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.renderer;

import com.atlassian.jira.InfrastructureException;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.renderer.JiraRendererPlugin;
import com.atlassian.jira.plugin.renderer.JiraRendererModuleDescriptor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.renderer.ProjectDescriptionRenderer;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class WikiMarkupProjectDescriptionRenderer
implements ProjectDescriptionRenderer {
    static final ImmutableMap<String, String> DEFAULT_RENDER_PARAMETERS = ImmutableMap.of((Object)"rows", (Object)"10", (Object)"cols", (Object)"60", (Object)"wrap", (Object)"virtual", (Object)"class", (Object)"long-field");
    static final String PROJECT_DESCRIPTION_FIELD_ID = "description";
    static final String PROJECT_DESCRIPTION_FIELD_NAME = "description";
    static final boolean NO_SINGLE_LINE = false;
    private final RendererManager rendererManager;

    public WikiMarkupProjectDescriptionRenderer(@Nonnull RendererManager rendererManager) {
        this.rendererManager = rendererManager;
    }

    @Override
    @Nonnull
    public String getViewHtml(@Nonnull Project project) {
        return this.getRenderer().render(project.getDescription(), null);
    }

    @Override
    @Nonnull
    public String getEditHtml(@Nonnull Project project) {
        JiraRendererModuleDescriptor rendererDescriptor = this.getRenderer().getDescriptor();
        HashMap renderParams = Maps.newHashMap(DEFAULT_RENDER_PARAMETERS);
        return rendererDescriptor.getEditVM(project.getDescription(), null, "atlassian-wiki-renderer", "description", "description", (Map)renderParams, false);
    }

    @Override
    @Nonnull
    public String getDescriptionI18nKey() {
        return "admin.addproject.description.wikimarkup";
    }

    @Nonnull
    private JiraRendererPlugin getRenderer() {
        JiraRendererPlugin renderer = this.rendererManager.getRendererForType("atlassian-wiki-renderer");
        if (renderer == null) {
            throw new InfrastructureException("wikimarkup renderer not found, but it is required to render the project description");
        }
        return renderer;
    }
}

