/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.studio.haup.api.SupportedApplication;
import com.atlassian.studio.haup.api.UserApplicationAccessService;
import java.util.Map;

public class UserCanAccessAllAppsCondition
implements Condition {
    private final UserManager userManager;
    private final FeatureManager featureManager;

    public UserCanAccessAllAppsCondition(UserManager userManager, FeatureManager featureManager) {
        this.userManager = userManager;
        this.featureManager = featureManager;
    }

    public void init(Map<String, String> stringStringMap) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> stringObjectMap) {
        if (!this.featureManager.isEnabled(CoreFeatures.ON_DEMAND)) {
            return true;
        }
        UserApplicationAccessService userApplicationAccessService = (UserApplicationAccessService)ComponentAccessor.getOSGiComponentInstanceOfType(UserApplicationAccessService.class);
        if (userApplicationAccessService == null) {
            return false;
        }
        String remoteUsername = this.userManager.getRemoteUsername();
        for (SupportedApplication app : userApplicationAccessService.getEnabledApplications()) {
            if (userApplicationAccessService.hasAccess(remoteUsername, app)) continue;
            return false;
        }
        return true;
    }
}

