/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.projectpanel.impl;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.impl.LabelsCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.label.AlphabeticalLabelRenderer;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelUtil;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.projectpanel.impl.AbstractProjectTabPanel;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.bean.StatisticAccessorBean;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import webwork.action.ServletActionContext;

public class LabelsHeatmapProjectTabPanel
extends AbstractProjectTabPanel {
    private static final String LABELS_VIEW_PARAMETER = "labels.view";
    private static final String SELECTED_LABEL_PARAMETER = "selected.field";
    private static final String POPULAR_LABELS_VIEW = "popular";
    private static final String LABELS_ORDER_PARAMETER = "labels.order";
    private static final String ALPHA_ORDER = "alpha";
    private final CustomFieldManager customFieldManager;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final FieldManager fieldManager;
    private final LabelUtil labelUtil;
    private final AlphabeticalLabelRenderer alphabeticalLabelRenderer;
    private static final int MAX_FONT_SIZE = 14;

    public LabelsHeatmapProjectTabPanel(JiraAuthenticationContext jiraAuthenticationContext, CustomFieldManager customFieldManager, FieldVisibilityManager fieldVisibilityManager, FieldManager fieldManager, LabelUtil labelUtil, AlphabeticalLabelRenderer alphabeticalLabelRenderer) {
        super(jiraAuthenticationContext);
        this.customFieldManager = customFieldManager;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.fieldManager = fieldManager;
        this.labelUtil = labelUtil;
        this.alphabeticalLabelRenderer = alphabeticalLabelRenderer;
    }

    public String getHtml(BrowseContext browseContext) {
        try {
            HttpServletRequest req = ServletActionContext.getRequest();
            String labelsView = req.getParameter(LABELS_VIEW_PARAMETER);
            String selectedFieldId = req.getParameter(SELECTED_LABEL_PARAMETER);
            List<Field> labels = this.getLabelFields(browseContext.getProject().getId());
            Field selectedField = StringUtils.isBlank((String)selectedFieldId) && !labels.isEmpty() ? labels.get(0) : this.fieldManager.getField(selectedFieldId);
            String result = StringUtils.isEmpty((String)labelsView) || POPULAR_LABELS_VIEW.equals(labelsView) ? this.getPopularView(browseContext, req, selectedField, labels) : this.getAllView(browseContext, req, selectedField, labels);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getAllView(BrowseContext browseContext, HttpServletRequest req, Field field, Collection<Field> labelFields) throws Exception {
        Long projectId = browseContext.getProject().getId();
        Map<String, Object> startingParams = this.getVelocityParams(browseContext, req, field, labelFields);
        startingParams.put("alphabeticalLabelsHtml", this.alphabeticalLabelRenderer.getHtml(browseContext.getUser(), projectId, field.getId()));
        return this.descriptor.getHtml("view-all", startingParams);
    }

    private String getPopularView(BrowseContext browseContext, HttpServletRequest req, Field field, Collection<Field> labelFields) throws Exception {
        String labelOrder = req.getParameter(LABELS_ORDER_PARAMETER);
        Long projectId = browseContext.getProject().getId();
        StatisticAccessorBean statBean = new StatisticAccessorBean(browseContext.getUser(), this.getProjectFilter(projectId));
        try {
            StatisticAccessorBean.OrderBy order = StatisticAccessorBean.OrderBy.TOTAL;
            StatisticAccessorBean.Direction direction = StatisticAccessorBean.Direction.DESC;
            if (StringUtils.isEmpty((String)labelOrder) || ALPHA_ORDER.equals(labelOrder)) {
                order = StatisticAccessorBean.OrderBy.NATURAL;
                direction = StatisticAccessorBean.Direction.ASC;
            }
            StatisticMapWrapper statWrapper = statBean.getAllFilterBy(field.getId(), order, direction);
            Map<String, Object> startingParams = this.getVelocityParams(browseContext, req, field, labelFields);
            startingParams.put("labelOrder", labelOrder);
            startingParams.put("labelsHeatMap", this.normalizeMap((Map<Label, Number>)statWrapper));
            return this.descriptor.getHtml("view", startingParams);
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<Label, Number> normalizeMap(Map<Label, Number> input) {
        LinkedHashMap<Label, Number> ret = new LinkedHashMap<Label, Number>();
        input.remove(null);
        if (!input.isEmpty()) {
            Collection<Number> values = input.values();
            Number max = null;
            for (Number value : values) {
                if (max == null) {
                    max = value;
                    continue;
                }
                if (value.intValue() <= max.intValue()) continue;
                max = value;
            }
            if (max != null) {
                double multiplier = 14.0 / max.doubleValue();
                for (Map.Entry<Label, Number> labelNumberEntry : input.entrySet()) {
                    ret.put(labelNumberEntry.getKey(), (int)((double)labelNumberEntry.getValue().intValue() * multiplier));
                }
            }
        }
        return ret;
    }

    private Map<String, Object> getVelocityParams(BrowseContext browseContext, HttpServletRequest req, Field field, Collection<Field> labelFields) {
        HashMap<String, Object> startingParams = new HashMap<String, Object>();
        startingParams.put("field", field);
        startingParams.put("labelFields", labelFields);
        startingParams.put("labelUtils", this.labelUtil);
        startingParams.put("isCustomField", field.getId().startsWith("customfield_"));
        startingParams.put("projectId", browseContext.getProject().getId());
        startingParams.put("projectKey", browseContext.getProject().getKey());
        startingParams.put("currentView", this.getCurrentView(req));
        startingParams.put("remoteUser", browseContext.getUser());
        return startingParams;
    }

    private SearchRequest getProjectFilter(Long projectId) {
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder();
        JqlClauseBuilder jqlClauseBuilder = jqlQueryBuilder.where();
        jqlClauseBuilder.project(new Long[]{projectId});
        return new SearchRequest(jqlClauseBuilder.buildQuery());
    }

    private String getCurrentView(HttpServletRequest req) {
        String labelsView = req.getParameter(LABELS_VIEW_PARAMETER);
        if (StringUtils.isEmpty((String)labelsView)) {
            return POPULAR_LABELS_VIEW;
        }
        return labelsView;
    }

    public boolean showPanel(BrowseContext browseContext) {
        List<Field> labelFields = this.getLabelFields(browseContext.getProject().getId());
        return !labelFields.isEmpty();
    }

    public List<Field> getLabelFields(Long projectId) {
        ArrayList<Field> ret = new ArrayList<Field>();
        if (!this.fieldVisibilityManager.isFieldHiddenInAllSchemes(projectId, "labels")) {
            ret.add(this.fieldManager.getField("labels"));
        }
        List customFieldList = this.customFieldManager.getCustomFieldObjects();
        for (CustomField customField : customFieldList) {
            if (!(customField.getCustomFieldType() instanceof LabelsCFType) || this.fieldVisibilityManager.isFieldHiddenInAllSchemes(projectId, customField.getId())) continue;
            ret.add((Field)customField);
        }
        return ret;
    }
}

