/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.projectpanel.fragment.impl;

import com.atlassian.jira.plugin.projectpanel.fragment.MenuFragment;
import com.atlassian.jira.plugin.report.ReportModuleDescriptor;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.plugin.PluginAccessor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;

public class ReportsMenuFragment
implements MenuFragment {
    private static final String REPORTS_FRAGMENT_DIV_ID = "reports";
    private static final String TEMPLATE_PATH = "templates/plugins/jira/projectpanels/fragments/summary/menu/reportsmenu.vm";
    private static final Logger log = Logger.getLogger(ReportsMenuFragment.class);
    private final VelocityTemplatingEngine templatingEngine;
    private final JiraAuthenticationContext authenticationContext;
    private final PluginAccessor pluginAccessor;

    public ReportsMenuFragment(VelocityTemplatingEngine templatingEngine, JiraAuthenticationContext authenticationContext, PluginAccessor pluginAccessor) {
        this.templatingEngine = templatingEngine;
        this.authenticationContext = authenticationContext;
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public String getId() {
        return REPORTS_FRAGMENT_DIV_ID;
    }

    @Override
    public String getHtml(BrowseContext ctx) {
        try {
            Map<String, Object> velocityParams = JiraVelocityUtils.getDefaultVelocityParams(this.authenticationContext);
            velocityParams.put("project", ctx.getProject());
            velocityParams.put("i18n", this.authenticationContext.getI18nHelper());
            velocityParams.put(REPORTS_FRAGMENT_DIV_ID, this.getReports());
            velocityParams.put("browseContext", ctx);
            return this.templatingEngine.render(TemplateSources.file((String)TEMPLATE_PATH)).applying(velocityParams).asHtml();
        }
        catch (VelocityException e) {
            log.error((Object)"Error occurred while rendering velocity template for 'templates/plugins/jira/projectpanels/fragments/summary/menu/reportsmenu.vm'.", (Throwable)e);
            return "";
        }
    }

    private List<ReportModuleDescriptor> getReports() {
        List reports = this.pluginAccessor.getEnabledModuleDescriptorsByClass(ReportModuleDescriptor.class);
        Iterator iterator = reports.iterator();
        while (iterator.hasNext()) {
            ReportModuleDescriptor descriptor = (ReportModuleDescriptor)iterator.next();
            if (descriptor.getModule().showReport()) continue;
            iterator.remove();
        }
        return reports;
    }

    @Override
    public boolean showFragment(BrowseContext ctx) {
        return !this.getReports().isEmpty();
    }
}

