/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.projectpanel.fragment.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugin.componentpanel.fragment.ComponentTabPanelFragment;
import com.atlassian.jira.plugin.projectpanel.fragment.impl.AbstractFragment;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.web.bean.FieldVisibilityBean;
import com.atlassian.jira.web.util.OutlookDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;

public class DueVersionsFragment
extends AbstractFragment
implements ComponentTabPanelFragment {
    private static final String TEMPLATE_DIRECTORY_PATH = "templates/plugins/jira/projectpanels/fragments/summary/";
    private static final Logger log = Logger.getLogger(DueVersionsFragment.class);
    private static final Integer DEFAULT_DISPLAY_VERSION_COUNT = 3;
    private final ApplicationProperties applicationProperties;
    private final VersionManager versionManager;

    public DueVersionsFragment(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext jiraAuthenticationContext, VersionManager versionManager) {
        super(templatingEngine, jiraAuthenticationContext);
        this.applicationProperties = applicationProperties;
        this.versionManager = versionManager;
    }

    @Override
    public String getId() {
        return "dueversions";
    }

    @Override
    protected String getTemplateDirectoryPath() {
        return TEMPLATE_DIRECTORY_PATH;
    }

    @Override
    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map<String, Object> velocityParams = super.createVelocityParams(ctx);
        velocityParams.put("versions", this.getVersions(ctx));
        velocityParams.put("SFM_HIDE", OutlookDate.SmartFormatterModes.HIDE_TIME);
        return velocityParams;
    }

    @Override
    public boolean showFragment(BrowseContext ctx) {
        return this.getDisplayIssueCount() > 0 && this.isFixForVersionsFieldVisible(ctx) && !this.getVersions(ctx).isEmpty();
    }

    Collection<Version> getVersions(BrowseContext ctx) {
        Integer count = this.getDisplayIssueCount();
        ArrayList<Version> versions = new ArrayList<Version>(this.versionManager.getVersionsUnreleased(ctx.getProject().getId(), false));
        return versions.size() > count ? versions.subList(0, count) : versions;
    }

    boolean isFixForVersionsFieldVisible(BrowseContext ctx) {
        FieldVisibilityBean visibility = new FieldVisibilityBean();
        return !visibility.isFieldHiddenInAllSchemes(ctx.getProject().getId(), "fixVersions");
    }

    Integer getDisplayIssueCount() {
        String displayIssueCount = this.applicationProperties.getDefaultBackedString("jira.project.summary.max.issues");
        try {
            if (displayIssueCount == null) {
                return DEFAULT_DISPLAY_VERSION_COUNT;
            }
            Integer intDisplayIssueCount = Integer.valueOf(displayIssueCount);
            if (intDisplayIssueCount < 0) {
                return DEFAULT_DISPLAY_VERSION_COUNT;
            }
            return intDisplayIssueCount;
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Invalid value for application property 'jira.project.summary.max.issues': " + displayIssueCount));
            return DEFAULT_DISPLAY_VERSION_COUNT;
        }
    }
}

