/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.projectpanel.fragment.impl;

import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.GadgetRequestContextFactory;
import com.atlassian.gadgets.GadgetState;
import com.atlassian.gadgets.view.GadgetViewFactory;
import com.atlassian.gadgets.view.ModuleId;
import com.atlassian.gadgets.view.View;
import com.atlassian.gadgets.view.ViewType;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.plugin.projectpanel.fragment.impl.AbstractFragment;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginAccessor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import webwork.action.ActionContext;

public class ActivityStreamFragment
extends AbstractFragment {
    protected static final String TEMPLATE_DIRECTORY_PATH = "templates/plugins/jira/projectpanels/fragments/summary/";
    private static final String ACTIVTY_STREAM_GADGET_MODULE_KEY = "com.atlassian.streams.streams-jira-plugin:activitystream-gadget";
    private static final String PREF_IS_CONFIGURED = "isConfigured";
    private static final String PREF_KEYS = "keys";
    private static final String GADGET_URI = "rest/gadgets/1.0/g/com.atlassian.streams.streams-jira-plugin/gadgets/activitystream-gadget.xml";
    private static final String PREF_NUMOFENTRIES = "numofentries";
    private static final String NUMOFENTRIES = "10";
    private static final String PREFS_IS_CONFIGURABLE = "isConfigurable";
    private static final String PREF_TITLE_REQUIRED = "titleRequired";
    private final PluginAccessor pluginAccessor;

    public ActivityStreamFragment(VelocityTemplatingEngine templatingEngine, JiraAuthenticationContext jiraAuthenticationContext, PluginAccessor pluginAccessor) {
        super(templatingEngine, jiraAuthenticationContext);
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map<String, Object> params = super.createVelocityParams(ctx);
        GadgetViewFactory viewFactory = ComponentManager.getOSGiComponentInstanceOfType(GadgetViewFactory.class);
        MapBuilder prefsBuilder = MapBuilder.newBuilder();
        prefsBuilder.add((Object)PREF_IS_CONFIGURED, (Object)Boolean.TRUE.toString());
        prefsBuilder.add((Object)PREFS_IS_CONFIGURABLE, (Object)Boolean.FALSE.toString());
        prefsBuilder.add((Object)PREF_KEYS, (Object)ctx.getProject().getKey());
        prefsBuilder.add((Object)PREF_NUMOFENTRIES, (Object)NUMOFENTRIES);
        prefsBuilder.add((Object)PREF_TITLE_REQUIRED, (Object)Boolean.FALSE.toString());
        GadgetState gadget = GadgetState.gadget((GadgetId)GadgetId.valueOf((String)"1")).specUri(URI.create(GADGET_URI)).userPrefs(prefsBuilder.toMap()).build();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter gadgetWriter = new OutputStreamWriter(baos);
            GadgetRequestContext requestContext = ComponentManager.getOSGiComponentInstanceOfType(GadgetRequestContextFactory.class).get(ActionContext.getRequest());
            View settings = new View.Builder().viewType(ViewType.DEFAULT).writable(false).build();
            viewFactory.createGadgetView(gadget, ModuleId.valueOf((long)1L), settings, requestContext).writeTo((Writer)gadgetWriter);
            ((Writer)gadgetWriter).flush();
            params.put("gadgetHtml", baos.toString());
        }
        catch (IOException e) {
            log.error((Object)"Error rendering activity stream gadget.", (Throwable)e);
        }
        catch (RuntimeException e) {
            log.error((Object)"Runtime error rendering activity stream gadget.", (Throwable)e);
        }
        return params;
    }

    @Override
    protected String getTemplateDirectoryPath() {
        return TEMPLATE_DIRECTORY_PATH;
    }

    @Override
    public String getId() {
        return "activitystream";
    }

    @Override
    public boolean showFragment(BrowseContext ctx) {
        GadgetViewFactory viewFactory = ComponentManager.getOSGiComponentInstanceOfType(GadgetViewFactory.class);
        return viewFactory != null && this.pluginAccessor.isPluginModuleEnabled(ACTIVTY_STREAM_GADGET_MODULE_KEY);
    }
}

