/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.jira.permission.Permission;
import com.atlassian.jira.permission.PermissionImpl;
import com.atlassian.jira.security.Permissions;
import java.util.LinkedHashMap;
import java.util.Map;

public class SchemePermissions {
    private LinkedHashMap<Integer, Permission> permissions;
    private LinkedHashMap<Integer, Permission> projectPermissions;
    private LinkedHashMap<Integer, Permission> issuePermissions;
    private LinkedHashMap<Integer, Permission> votersAndWatchersPermissions;
    private LinkedHashMap<Integer, Permission> timeTrackingPermissions;
    private LinkedHashMap<Integer, Permission> commentsPermissions;
    private LinkedHashMap<Integer, Permission> attachmentsPermissions;

    public synchronized Map<Integer, Permission> getProjectPermissions() {
        if (this.projectPermissions == null) {
            this.projectPermissions = new LinkedHashMap();
            this.projectPermissions.put(new Integer(23), new PermissionImpl(String.valueOf(23), "Administer Projects", "Ability to administer a project in JIRA.", "admin.permissions.PROJECT_ADMIN", "admin.permissions.descriptions.PROJECT_ADMIN"));
            this.projectPermissions.put(new Integer(10), new PermissionImpl(String.valueOf(10), "Browse Projects", "Ability to browse projects and the issues within them.", "admin.permissions.BROWSE", "admin.permissions.descriptions.BROWSE"));
            this.projectPermissions.put(new Integer(29), new PermissionImpl(String.valueOf(29), "View Version Control", "Ability to view Version Control commit information for issues.", "admin.permissions.VIEW_VERSION_CONTROL", "admin.permissions.descriptions.VIEW_VERSION_CONTROL"));
            this.projectPermissions.put(new Integer(45), new PermissionImpl(String.valueOf(45), "View Workflow", "Ability to view a read-only workflow diagram for issues.", "admin.permissions.VIEW_WORKFLOW_READONLY", "admin.permissions.descriptions.WORKFLOW_VIEW_READONLY"));
        }
        return this.projectPermissions;
    }

    public synchronized Map<Integer, Permission> getIssuePermissions() {
        if (this.issuePermissions == null) {
            this.issuePermissions = new LinkedHashMap();
            this.issuePermissions.put(new Integer(11), new PermissionImpl(String.valueOf(11), "Create Issues", "Ability to create issues.", "admin.permissions.CREATE_ISSUE", "admin.permissions.descriptions.CREATE_ISSUE"));
            this.issuePermissions.put(new Integer(12), new PermissionImpl(String.valueOf(12), "Edit Issues", "Ability to edit issues.", "admin.permissions.EDIT_ISSUE", "admin.permissions.descriptions.EDIT_ISSUE"));
            this.issuePermissions.put(new Integer(28), new PermissionImpl(String.valueOf(28), "Schedule Issues", "Ability to view or edit an issue's due date", "admin.permissions.SCHEDULE_ISSUE", "admin.permissions.descriptions.SCHEDULE_ISSUE"));
            this.issuePermissions.put(new Integer(25), new PermissionImpl(String.valueOf(25), "Move Issues", "Ability to move issues between projects or between workflows of the same project (if applicable). Note the user can only move issues to a project he or she has the create permission for.", "admin.permissions.MOVE_ISSUE", "admin.permissions.descriptions.MOVE_ISSUE"));
            this.issuePermissions.put(new Integer(13), new PermissionImpl(String.valueOf(13), "Assign Issues", "Ability to assign issues to other people.", "admin.permissions.ASSIGN_ISSUE", "admin.permissions.descriptions.ASSIGN_ISSUE"));
            this.issuePermissions.put(new Integer(17), new PermissionImpl(String.valueOf(17), "Assignable User", "Users with this permission may be assigned to issues.", "admin.permissions.ASSIGNABLE_USER", "admin.permissions.descriptions.ASSIGNABLE_USER"));
            this.issuePermissions.put(new Integer(14), new PermissionImpl(String.valueOf(14), "Resolve Issues", "Ability to resolve and reopen issues. This includes the ability to set a fix version.", "admin.permissions.RESOLVE_ISSUE", "admin.permissions.descriptions.RESOLVE_ISSUE"));
            this.issuePermissions.put(new Integer(18), new PermissionImpl(String.valueOf(18), "Close Issues", "Ability to close issues. Often useful where your developers resolve issues, and a QA department closes them.", "admin.permissions.CLOSE_ISSUE", "admin.permissions.descriptions.CLOSE_ISSUE"));
            this.issuePermissions.put(new Integer(30), new PermissionImpl(String.valueOf(30), "Modify Reporter", "Ability to modify the reporter when creating or editing an issue.", "admin.permissions.MODIFY_REPORTER", "admin.permissions.descriptions.MODIFY_REPORTER"));
            this.issuePermissions.put(new Integer(16), new PermissionImpl(String.valueOf(16), "Delete Issues", "Ability to delete issues.", "admin.permissions.DELETE_ISSUE", "admin.permissions.descriptions.DELETE_ISSUE"));
            this.issuePermissions.put(new Integer(21), new PermissionImpl(String.valueOf(21), "Link Issues", "Ability to link issues together and create linked issues. Only useful if issue linking is turned on.", "admin.permissions.LINK_ISSUE", "admin.permissions.descriptions.LINK_ISSUE"));
            this.issuePermissions.put(new Integer(26), new PermissionImpl(String.valueOf(26), "Set Issue Security", "Ability to set the level of security on an issue so that only people in that security level can see the issue.", "admin.permissions.SET_ISSUE_SECURITY", "admin.permissions.descriptions.SET_ISSUE_SECURITY"));
        }
        return this.issuePermissions;
    }

    public synchronized Map<Integer, Permission> getVotersAndWatchersPermissions() {
        if (this.votersAndWatchersPermissions == null) {
            this.votersAndWatchersPermissions = new LinkedHashMap();
            this.votersAndWatchersPermissions.put(new Integer(31), new PermissionImpl(String.valueOf(31), "View Voters and Watchers", "Ability to view the voters and watchers of an issue.", "admin.permissions.VIEW_VOTERS_AND_WATCHERS", "admin.permissions.descriptions.VIEW_VOTERS_AND_WATCHERS"));
            this.votersAndWatchersPermissions.put(new Integer(32), new PermissionImpl(String.valueOf(32), "Manage Watchers", "Ability to manage the watchers of an issue.", "admin.permissions.MANAGE_WATCHER_LIST", "admin.permissions.descriptions.MANAGE_WATCHER_LIST"));
        }
        return this.votersAndWatchersPermissions;
    }

    public synchronized Map<Integer, Permission> getCommentsPermissions() {
        if (this.commentsPermissions == null) {
            this.commentsPermissions = new LinkedHashMap();
            this.commentsPermissions.put(new Integer(15), new PermissionImpl(String.valueOf(15), "Add Comments", "Ability to comment on issues.", "admin.permissions.COMMENT_ISSUE", "admin.permissions.descriptions.COMMENT_ISSUE"));
            this.commentsPermissions.put(new Integer(34), new PermissionImpl(String.valueOf(34), "Edit All Comments", "Ability to edit all comments made on issues.", "admin.permissions.COMMENT_EDIT_ALL", "admin.permissions.descriptions.COMMENT_EDIT_ALL"));
            this.commentsPermissions.put(new Integer(35), new PermissionImpl(String.valueOf(35), "Edit Own Comments", "Ability to edit own comments made on issues.", "admin.permissions.COMMENT_EDIT_OWN", "admin.permissions.descriptions.COMMENT_EDIT_OWN"));
            this.commentsPermissions.put(new Integer(36), new PermissionImpl(String.valueOf(36), "Delete All Comments", "Ability to delete all comments made on issues.", "admin.permissions.COMMENT_DELETE_ALL", "admin.permissions.descriptions.COMMENT_DELETE_ALL"));
            this.commentsPermissions.put(new Integer(37), new PermissionImpl(String.valueOf(37), "Delete Own Comments", "Ability to delete own comments made on issues.", "admin.permissions.COMMENT_DELETE_OWN", "admin.permissions.descriptions.COMMENT_DELETE_OWN"));
        }
        return this.commentsPermissions;
    }

    public synchronized Map<Integer, Permission> getAttachmentsPermissions() {
        if (this.attachmentsPermissions == null) {
            this.attachmentsPermissions = new LinkedHashMap();
            this.attachmentsPermissions.put(new Integer(19), new PermissionImpl(String.valueOf(19), "Create Attachments", "Users with this permission may create attachments.", "admin.permissions.CREATE_ATTACHMENT", "admin.permissions.descriptions.CREATE_ATTACHMENT"));
            this.attachmentsPermissions.put(new Integer(38), new PermissionImpl(String.valueOf(38), "Delete All Attachments", "Users with this permission may delete all attachments.", "admin.permissions.ATTACHMENT_DELETE_ALL", "admin.permissions.descriptions.ATTACHMENT_DELETE_ALL"));
            this.attachmentsPermissions.put(new Integer(39), new PermissionImpl(String.valueOf(39), "Delete Own Attachments", "Users with this permission may delete own attachments.", "admin.permissions.ATTACHMENT_DELETE_OWN", "admin.permissions.descriptions.ATTACHMENT_DELETE_OWN"));
        }
        return this.attachmentsPermissions;
    }

    public synchronized Map<Integer, Permission> getTimeTrackingPermissions() {
        if (this.timeTrackingPermissions == null) {
            this.timeTrackingPermissions = new LinkedHashMap();
            this.timeTrackingPermissions.put(new Integer(20), new PermissionImpl(String.valueOf(20), "Work On Issues", "Ability to log work done against an issue. Only useful if Time Tracking is turned on.", "admin.permissions.WORK_ISSUE", "admin.permissions.descriptions.WORK_ISSUE"));
            this.timeTrackingPermissions.put(new Integer(40), new PermissionImpl(String.valueOf(40), "Edit Own Worklogs", "Users with this permission may edit own worklogs.", "admin.permissions.WORKLOG_EDIT_OWN", "admin.permissions.descriptions.WORKLOG_EDIT_OWN"));
            this.timeTrackingPermissions.put(new Integer(41), new PermissionImpl(String.valueOf(41), "Edit All Worklogs", "Users with this permission may edit all worklogs.", "admin.permissions.WORKLOG_EDIT_ALL", "admin.permissions.descriptions.WORKLOG_EDIT_ALL"));
            this.timeTrackingPermissions.put(new Integer(42), new PermissionImpl(String.valueOf(42), "Delete Own Worklogs", "Users with this permission may delete own worklogs.", "admin.permissions.WORKLOG_DELETE_OWN", "admin.permissions.descriptions.WORKLOG_DELETE_OWN"));
            this.timeTrackingPermissions.put(new Integer(43), new PermissionImpl(String.valueOf(43), "Delete All Worklogs", "Users with this permission may delete all worklogs.", "admin.permissions.WORKLOG_DELETE_ALL", "admin.permissions.descriptions.WORKLOG_DELETE_ALL"));
        }
        return this.timeTrackingPermissions;
    }

    public synchronized Map<Integer, Permission> getSchemePermissions() {
        if (this.permissions == null) {
            this.permissions = new LinkedHashMap();
            this.permissions.putAll(this.getProjectPermissions());
            this.permissions.putAll(this.getIssuePermissions());
            this.permissions.putAll(this.getVotersAndWatchersPermissions());
            this.permissions.putAll(this.getCommentsPermissions());
            this.permissions.putAll(this.getAttachmentsPermissions());
            this.permissions.putAll(this.getTimeTrackingPermissions());
        }
        return this.permissions;
    }

    public boolean schemePermissionExists(Integer id) {
        return this.getSchemePermissions().containsKey(id);
    }

    public String getPermissionName(Integer id) {
        return this.getSchemePermissions().get(id).getNameKey();
    }

    public String getPermissionDescription(int id) {
        if (this.getSchemePermissions().get(new Integer(id)) != null) {
            return this.getSchemePermissions().get(new Integer(id)).getDescription();
        }
        return Permissions.getDescription((int)id);
    }
}

