/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.ActualValueEqualityQueryFactory;
import com.atlassian.jira.jql.query.ActualValueRelationalQueryFactory;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.GenericClauseQueryFactory;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.util.IndexValueConverter;
import com.atlassian.jira.jql.util.VotesIndexValueConverter;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.query.clause.TerminalClause;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

@InjectableComponent
public class VotesClauseQueryFactory
implements ClauseQueryFactory {
    private static final Logger log = Logger.getLogger(VotesClauseQueryFactory.class);
    private final ClauseQueryFactory delegateClauseQueryFactory;
    private final VoteManager voteManager;

    public VotesClauseQueryFactory(JqlOperandResolver operandResolver, VotesIndexValueConverter votesIndexValueConverter, VoteManager voteManager) {
        this.voteManager = voteManager;
        ArrayList<OperatorSpecificQueryFactory> operatorFactories = new ArrayList<OperatorSpecificQueryFactory>();
        operatorFactories.add((OperatorSpecificQueryFactory)new ActualValueEqualityQueryFactory((IndexValueConverter)votesIndexValueConverter));
        operatorFactories.add((OperatorSpecificQueryFactory)new ActualValueRelationalQueryFactory((IndexValueConverter)votesIndexValueConverter));
        this.delegateClauseQueryFactory = this.createGenericClauseFactory(operandResolver, operatorFactories);
    }

    public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        if (this.voteManager.isVotingEnabled()) {
            return this.delegateClauseQueryFactory.getQuery(queryCreationContext, terminalClause);
        }
        log.debug((Object)"Attempt to search votes field when voting is disabled.");
        return QueryFactoryResult.createFalseResult();
    }

    GenericClauseQueryFactory createGenericClauseFactory(JqlOperandResolver operandResolver, List<OperatorSpecificQueryFactory> operatorFactories) {
        return new GenericClauseQueryFactory(SystemSearchConstants.forVotes().getIndexField(), operatorFactories, operandResolver);
    }
}

