/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.project;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.jelly.ProjectContextAccessor;
import com.atlassian.jira.jelly.ProjectContextAccessorImpl;
import com.atlassian.jira.jelly.tag.UserAwareActionTagSupport;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.XMLOutput;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class CreateProject
extends UserAwareActionTagSupport
implements ProjectContextAccessor {
    private Logger log = Logger.getLogger(CreateProject.class);
    private static final String KEY_PROJECTID = "pid";
    private static final String KEY_PROJECTKEY = "key";
    private static final String KEY_PROJECTNAME = "name";
    private static final String KEY_PROJECTLEAD = "lead";
    private static final String KEY_DEFAULTASSIGNEE = "assigneeType";
    private static final String KEY_PROJECTAVATAR = "avatarId";
    private final String[] requiredProperties;
    private final String[] requiredContextVariablesAfter = new String[]{"jelly.project.id", "jelly.project.key"};
    private final ProjectContextAccessor projectContextAccessor;

    public CreateProject() {
        this.setActionName("AddProject");
        this.projectContextAccessor = new ProjectContextAccessorImpl((Tag)this);
        this.requiredProperties = new String[]{KEY_PROJECTKEY, KEY_PROJECTNAME, KEY_PROJECTLEAD};
    }

    @Override
    protected void prePropertyValidation(XMLOutput output) throws JellyTagException {
        if (!this.getProperties().containsKey(KEY_DEFAULTASSIGNEE)) {
            if (ComponentAccessor.getApplicationProperties().getOption("jira.option.allowunassigned")) {
                this.setProperty(KEY_DEFAULTASSIGNEE, String.valueOf(3L));
            } else {
                this.setProperty(KEY_DEFAULTASSIGNEE, String.valueOf(2L));
            }
            Long defaultSchemeId = ManagerFactory.getPermissionSchemeManager().getDefaultSchemeObject().getId();
            this.setProperty("permissionScheme", defaultSchemeId.toString());
        }
    }

    @Override
    protected void postTagExecution(XMLOutput output) throws JellyTagException {
        this.log.debug((Object)"CreateProject.postTagExecution");
        this.copyRedirectUrlParametersToTag(this.getResponse().getRedirectUrl());
        this.setProject(this.getProperty(KEY_PROJECTKEY));
    }

    @Override
    protected void endTagExecution(XMLOutput output) {
        this.loadPreviousProject();
    }

    @Override
    public String[] getRequiredProperties() {
        return this.requiredProperties;
    }

    @Override
    public String[] getRequiredContextVariablesAfter() {
        return this.requiredContextVariablesAfter;
    }

    @Override
    public void setProject(Long projectId) {
        this.projectContextAccessor.setProject(projectId);
    }

    @Override
    public void setProject(String projectKey) {
        this.projectContextAccessor.setProject(projectKey);
    }

    @Override
    public void setProject(GenericValue project) {
        this.projectContextAccessor.setProject(project);
    }

    @Override
    public void loadPreviousProject() {
        this.projectContextAccessor.loadPreviousProject();
    }
}

