/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.issue;

import com.atlassian.jira.jelly.IssueContextAccessor;
import com.atlassian.jira.jelly.IssueContextAccessorImpl;
import com.atlassian.jira.jelly.tag.IssueAwareActionTagSupport;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.XMLOutput;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class StopProgress
extends IssueAwareActionTagSupport
implements IssueContextAccessor {
    private static final transient Logger log = Logger.getLogger(StopProgress.class);
    private static final String KEY_ISSUE_ID = "key";
    private static final String KEY_PROGRESS_STARTER = "starter";
    private static final String ACTION_ID = "action";
    private boolean hasPreviousUsername = false;
    private String previousUsername = null;
    private final IssueContextAccessor issueContextAccessor;

    public StopProgress() {
        this.setActionName("WorkflowUIDispatcher");
        this.issueContextAccessor = new IssueContextAccessorImpl((Tag)this);
    }

    @Override
    protected void preContextValidation() {
        if (this.getProperties().containsKey(KEY_ISSUE_ID)) {
            this.setIssue(this.getProperty(KEY_ISSUE_ID));
        }
        if (this.getProperties().containsKey(KEY_PROGRESS_STARTER)) {
            this.setPreviousUsername(this.getUsername());
            this.getContext().setVariable("jelly.username", (Object)this.getProperty(KEY_PROGRESS_STARTER.toLowerCase()));
        }
        super.preContextValidation();
    }

    @Override
    protected void prePropertyValidation(XMLOutput output) throws JellyTagException {
        this.setProperty(ACTION_ID, "301");
        this.setProperty(KEY_ISSUE_ID, this.getIssue().getString(KEY_ISSUE_ID));
    }

    @Override
    protected void endTagExecution(XMLOutput output) {
        super.endTagExecution(output);
        if (this.hasPreviousUsername) {
            this.getContext().setVariable("jelly.username", (Object)this.getPreviousUsername());
        }
        this.loadPreviousIssue();
    }

    @Override
    public String[] getRequiredProperties() {
        return new String[]{KEY_ISSUE_ID, ACTION_ID};
    }

    @Override
    public String[] getRequiredContextVariablesAfter() {
        return new String[0];
    }

    private String getPreviousUsername() {
        return this.previousUsername;
    }

    private void setPreviousUsername(String previousUsername) {
        this.hasPreviousUsername = true;
        this.previousUsername = previousUsername;
    }

    @Override
    public void setIssue(Long issueId) {
        this.issueContextAccessor.setIssue(issueId);
    }

    @Override
    public void setIssue(String issueKey) {
        this.issueContextAccessor.setIssue(issueKey);
    }

    @Override
    public void setIssue(GenericValue issue) {
        this.issueContextAccessor.setIssue(issue);
    }

    @Override
    public void loadPreviousIssue() {
        this.issueContextAccessor.loadPreviousIssue();
    }
}

