/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.issue;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.jelly.ActionTagSupport;
import com.atlassian.jira.jelly.tag.util.JellyTagUtils;
import java.sql.Timestamp;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class ChangeIssue
extends ActionTagSupport {
    private static final Logger log = Logger.getLogger(ChangeIssue.class);
    private static final String KEY_ISSUE_KEY = "key";
    private static final String KEY_ISSUE_UPDATED_DATE = "updated";

    @Override
    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        log.debug((Object)("ChangeIssue.doTag :" + this.toString()));
        if (this.contextValidation(output)) {
            this.prePropertyValidation(output);
            boolean preTagValid = this.propertyValidation(output);
            if (preTagValid) {
                this.updateIssue(output);
            }
        }
    }

    protected void updateIssue(XMLOutput output) throws JellyTagException {
        log.debug((Object)"ChangeIssue.updateIssue");
        GenericValue issue = null;
        try {
            String key = this.getProperty(KEY_ISSUE_KEY);
            issue = ComponentAccessor.getIssueManager().getIssue(key);
            boolean shouldStore = this.modifyUpdateDate(issue);
            if (shouldStore) {
                issue.store();
                ComponentAccessor.getIssueIndexManager().reIndex(issue);
            }
        }
        catch (GenericEntityException e) {
            throw new JellyTagException((Throwable)e);
        }
        catch (IndexException e) {
            log.error((Object)("Error while re-indexing issue '" + issue.getString(KEY_ISSUE_KEY) + "'. Seraching results may give incorrect results"));
        }
    }

    private boolean modifyUpdateDate(GenericValue issue) throws GenericEntityException {
        log.debug((Object)"ChangeIssue.modifyUpdateDate");
        String updatedDate = this.getProperty(KEY_ISSUE_UPDATED_DATE);
        if (updatedDate != null) {
            Timestamp updated = JellyTagUtils.parseDate(updatedDate);
            issue.set(KEY_ISSUE_UPDATED_DATE, (Object)updated);
            return true;
        }
        log.debug((Object)"Update date not set, using todays date");
        return false;
    }

    @Override
    protected void endTagExecution(XMLOutput output) {
    }

    @Override
    public String[] getRequiredProperties() {
        return new String[]{KEY_ISSUE_KEY};
    }

    @Override
    public String[] getRequiredContextVariablesAfter() {
        return new String[0];
    }

    @Override
    public String[] getRequiredContextVariables() {
        return new String[0];
    }

    @Override
    public void setProperty(String key, String value) {
        this.getProperties().put(key, value);
    }

    @Override
    public void setProperty(String key, String[] value) {
        this.getProperties().put(key, value);
    }

    @Override
    public String getProperty(String key) {
        return (String)this.getProperties().get(key);
    }
}

