/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.util;

import com.atlassian.jira.issue.search.util.LuceneQueryModifier;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;

public class DefaultLuceneQueryModifier
implements LuceneQueryModifier {
    @Override
    public Query getModifiedQuery(Query originalQuery) {
        Assertions.notNull((String)"originalQuery", (Object)originalQuery);
        if (originalQuery instanceof BooleanQuery) {
            return this.transformBooleanQuery((BooleanQuery)originalQuery);
        }
        return originalQuery;
    }

    private BooleanQuery transformBooleanQuery(BooleanQuery originalQuery) {
        QueryBucket queryBucket = new QueryBucket(originalQuery);
        if (queryBucket.containsOnlyNot()) {
            return this.handleOnlyNot(queryBucket);
        }
        if (queryBucket.containsMust()) {
            return this.handleContainsMust(queryBucket);
        }
        if (queryBucket.containsShould()) {
            return this.handleContainsShould(queryBucket);
        }
        return new BooleanQuery();
    }

    private BooleanQuery handleContainsShould(QueryBucket queryBucket) {
        BooleanQuery query = new BooleanQuery();
        BooleanQuery originalQuery = queryBucket.getOriginalBooleanQuery();
        query.setBoost(originalQuery.getBoost());
        query.setMinimumNumberShouldMatch(originalQuery.getMinimumNumberShouldMatch());
        for (Query shouldQuery : queryBucket.getShouldQueries()) {
            if (shouldQuery instanceof BooleanQuery) {
                query.add((Query)this.transformBooleanQuery((BooleanQuery)shouldQuery), BooleanClause.Occur.SHOULD);
                continue;
            }
            query.add((Query)shouldQuery.clone(), BooleanClause.Occur.SHOULD);
        }
        for (Query origNotQuery : queryBucket.getNotQueries()) {
            BooleanQuery notWithMatchAll = new BooleanQuery();
            Query notQuery = (Query)origNotQuery.clone();
            notWithMatchAll.setBoost(notQuery.getBoost());
            notWithMatchAll.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
            notQuery.setBoost(1.0f);
            if (notQuery instanceof BooleanQuery) {
                notWithMatchAll.setMinimumNumberShouldMatch(((BooleanQuery)notQuery).getMinimumNumberShouldMatch());
                ((BooleanQuery)notQuery).setMinimumNumberShouldMatch(0);
                notWithMatchAll.add((Query)this.transformBooleanQuery((BooleanQuery)notQuery), BooleanClause.Occur.MUST_NOT);
            } else {
                notWithMatchAll.add(notQuery, BooleanClause.Occur.MUST_NOT);
            }
            query.add((Query)notWithMatchAll, BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    private BooleanQuery handleContainsMust(QueryBucket queryBucket) {
        BooleanClause[] booleanClauses;
        BooleanQuery query = new BooleanQuery();
        BooleanQuery originalBooleanQuery = queryBucket.getOriginalBooleanQuery();
        query.setBoost(originalBooleanQuery.getBoost());
        query.setMinimumNumberShouldMatch(originalBooleanQuery.getMinimumNumberShouldMatch());
        for (BooleanClause booleanClause : booleanClauses = originalBooleanQuery.getClauses()) {
            Query subQuery = booleanClause.getQuery();
            BooleanClause.Occur subOccur = booleanClause.getOccur();
            if (subQuery instanceof BooleanQuery) {
                query.add((Query)this.transformBooleanQuery((BooleanQuery)subQuery), subOccur);
                continue;
            }
            query.add((Query)subQuery.clone(), subOccur);
        }
        return query;
    }

    private BooleanQuery handleOnlyNot(QueryBucket queryBucket) {
        BooleanQuery query = new BooleanQuery();
        BooleanQuery originalQuery = queryBucket.getOriginalBooleanQuery();
        query.setBoost(originalQuery.getBoost());
        query.setMinimumNumberShouldMatch(originalQuery.getMinimumNumberShouldMatch());
        query.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
        for (Query origNotQuery : queryBucket.getNotQueries()) {
            Query notQuery = (Query)origNotQuery.clone();
            if (notQuery instanceof BooleanQuery) {
                query.add((Query)this.transformBooleanQuery((BooleanQuery)notQuery), BooleanClause.Occur.MUST_NOT);
                continue;
            }
            query.add(notQuery, BooleanClause.Occur.MUST_NOT);
        }
        return query;
    }

    private static class QueryBucket {
        private final List<Query> notQueries;
        private final List<Query> mustQueries;
        private final List<Query> shouldQueries;
        private final BooleanQuery booleanQuery;

        public QueryBucket(BooleanQuery booleanQuery) {
            this.booleanQuery = booleanQuery;
            this.notQueries = new ArrayList<Query>();
            this.mustQueries = new ArrayList<Query>();
            this.shouldQueries = new ArrayList<Query>();
            this.init(booleanQuery.getClauses());
        }

        public BooleanQuery getOriginalBooleanQuery() {
            return this.booleanQuery;
        }

        public boolean containsOnlyNot() {
            return !this.notQueries.isEmpty() && this.mustQueries.isEmpty() && this.shouldQueries.isEmpty();
        }

        public boolean containsMust() {
            return !this.mustQueries.isEmpty();
        }

        public boolean containsShould() {
            return !this.shouldQueries.isEmpty();
        }

        public List<Query> getNotQueries() {
            return this.notQueries;
        }

        public List<Query> getShouldQueries() {
            return this.shouldQueries;
        }

        private void init(BooleanClause[] booleanClauses) {
            for (BooleanClause booleanClause : booleanClauses) {
                BooleanClause.Occur clauseOccur = booleanClause.getOccur();
                Query clauseQuery = booleanClause.getQuery();
                if (BooleanClause.Occur.MUST_NOT.equals((Object)clauseOccur)) {
                    this.notQueries.add(clauseQuery);
                    continue;
                }
                if (BooleanClause.Occur.MUST.equals((Object)clauseOccur)) {
                    this.mustQueries.add(clauseQuery);
                    continue;
                }
                if (!BooleanClause.Occur.SHOULD.equals((Object)clauseOccur)) continue;
                this.shouldQueries.add(clauseQuery);
            }
        }
    }
}

