/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.index.indexers.impl.AffectedVersionsIndexer;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.SearcherGroupType;
import com.atlassian.jira.issue.search.searchers.impl.AbstractInitializationSearcher;
import com.atlassian.jira.issue.search.searchers.information.GenericSearcherInformation;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.AffectedVersionRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.SearchContextVisibilityChecker;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.VersionSearchContextVisibilityChecker;
import com.atlassian.jira.issue.search.searchers.transformer.VersionSearchInputTransformer;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.jql.resolver.VersionIndexInfoResolver;
import com.atlassian.jira.jql.resolver.VersionResolver;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collections;

public class AffectedVersionsSearcher
extends AbstractInitializationSearcher
implements IssueSearcher<SearchableField> {
    private final SearcherInformation<SearchableField> searcherInformation;
    private final SearchInputTransformer searchInputTransformer;
    private final SearchRenderer searchRenderer;

    public AffectedVersionsSearcher(VersionResolver versionResolver, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, ProjectManager projectManager, VersionManager versionManager, FieldVisibilityManager fieldVisibilityManager, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine) {
        this.searcherInformation = new GenericSearcherInformation("version", "common.filters.matchesversions", Collections.singletonList(AffectedVersionsIndexer.class), this.fieldReference, SearcherGroupType.PROJECT);
        SimpleFieldSearchConstantsWithEmpty constants = SystemSearchConstants.forAffectedVersion();
        VersionSearchContextVisibilityChecker versionSearchContextVisibilityChecker = new VersionSearchContextVisibilityChecker(versionManager);
        VersionIndexInfoResolver indexInfoResolver = new VersionIndexInfoResolver((NameResolver)versionResolver);
        this.searchInputTransformer = new VersionSearchInputTransformer(constants.getJqlClauseNames(), constants.getUrlParameter(), (IndexInfoResolver<Version>)indexInfoResolver, operandResolver, fieldFlagOperandRegistry, (SearchContextVisibilityChecker)versionSearchContextVisibilityChecker, (NameResolver<Version>)versionResolver, versionManager);
        this.searchRenderer = new AffectedVersionRenderer(projectManager, versionManager, fieldVisibilityManager, velocityRequestContextFactory, applicationProperties, templatingEngine, this.searcherInformation.getNameKey());
    }

    public SearcherInformation<SearchableField> getSearchInformation() {
        return this.searcherInformation;
    }

    public SearchInputTransformer getSearchInputTransformer() {
        return this.searchInputTransformer;
    }

    public SearchRenderer getSearchRenderer() {
        return this.searchRenderer;
    }
}

