/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.quicksearch;

import com.atlassian.jira.issue.search.quicksearch.QuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.QuickSearchResult;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import org.ofbiz.core.entity.GenericValue;

public abstract class SingleWordQuickSearchHandler
implements QuickSearchHandler {
    @Override
    public void modifySearchResult(QuickSearchResult searchResult) {
        String searchString = searchResult.getSearchInput();
        StringTokenizer st = new StringTokenizer(searchString, " ");
        while (st.hasMoreTokens()) {
            String word = st.nextToken();
            Map params = this.handleWord(word, searchResult);
            if (params == null) continue;
            String searchWithoutTypeName = SingleWordQuickSearchHandler.strip(searchString, word).trim();
            searchResult.setSearchInput(searchWithoutTypeName);
            for (Map.Entry entry : params.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof Collection) {
                    Collection values = (Collection)entry.getValue();
                    for (String singleValue : values) {
                        searchResult.addSearchParameter((String)entry.getKey(), singleValue);
                    }
                    continue;
                }
                if (!(value instanceof String)) continue;
                searchResult.addSearchParameter((String)entry.getKey(), (String)value);
            }
        }
    }

    protected abstract Map handleWord(String var1, QuickSearchResult var2);

    private static String strip(String originalString, String stringToRemove) {
        int index = originalString.indexOf(stringToRemove);
        if (index == -1) {
            return originalString;
        }
        return originalString.substring(0, index) + originalString.substring(index + stringToRemove.length());
    }

    protected static GenericValue getByName(Collection genericValues, String name) {
        for (GenericValue genericValue : genericValues) {
            if (!name.equalsIgnoreCase(genericValue.getString("name"))) continue;
            return genericValue;
        }
        return null;
    }
}

