/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItemImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public class DefaultFieldScreenSchemeManager
implements FieldScreenSchemeManager {
    private static final String FIELD_SCREEN_SCHEME_ITEM_ENTITY_NAME = "FieldScreenSchemeItem";
    private final OfBizDelegator ofBizDelegator;
    private final FieldScreenManager fieldScreenManager;
    private final ConcurrentMap<Long, FieldScreenScheme> schemeCache = new ConcurrentHashMap<Long, FieldScreenScheme>();

    public DefaultFieldScreenSchemeManager(OfBizDelegator ofBizDelegator, FieldScreenManager fieldScreenManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.fieldScreenManager = fieldScreenManager;
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    public Collection<FieldScreenScheme> getFieldScreenSchemes() {
        return this.buildFieldScreenSchemes(this.ofBizDelegator.findAll("FieldScreenScheme", Collections.singletonList("name")));
    }

    private Collection<FieldScreenScheme> buildFieldScreenSchemes(List<GenericValue> fieldScreenSchemeGVs) {
        LinkedList<FieldScreenScheme> fieldScreenSchemes = new LinkedList<FieldScreenScheme>();
        for (GenericValue element : fieldScreenSchemeGVs) {
            fieldScreenSchemes.add(this.buildFieldScreenScheme(element));
        }
        return fieldScreenSchemes;
    }

    public FieldScreenScheme getFieldScreenScheme(Long id) {
        FieldScreenScheme fieldScreenScheme = (FieldScreenScheme)this.schemeCache.get(id);
        if (fieldScreenScheme == null) {
            fieldScreenScheme = this.retrieveFieldScreenScheme(id);
            FieldScreenScheme result = this.schemeCache.putIfAbsent(fieldScreenScheme.getId(), fieldScreenScheme);
            return result == null ? fieldScreenScheme : result;
        }
        return fieldScreenScheme;
    }

    protected FieldScreenScheme retrieveFieldScreenScheme(Long id) {
        GenericValue fieldScreenSchemeGV = this.getOfBizDelegator().findById("FieldScreenScheme", id);
        return this.buildFieldScreenScheme(fieldScreenSchemeGV);
    }

    protected FieldScreenSchemeImpl buildFieldScreenScheme(GenericValue genericValue) {
        return new FieldScreenSchemeImpl(this, genericValue);
    }

    public Collection<FieldScreenSchemeItem> getFieldScreenSchemeItems(FieldScreenScheme fieldScreenScheme) {
        LinkedList<FieldScreenSchemeItem> fieldScreenSchemeItems = new LinkedList<FieldScreenSchemeItem>();
        List fieldScreenSchemeItemGVs = this.ofBizDelegator.findByAnd(FIELD_SCREEN_SCHEME_ITEM_ENTITY_NAME, MapBuilder.build((Object)"fieldscreenscheme", (Object)fieldScreenScheme.getId()));
        for (GenericValue fieldScreenSchemeItemGV : fieldScreenSchemeItemGVs) {
            FieldScreenSchemeItem fieldScreenSchemeItem = this.buildFieldScreenSchemeItem(fieldScreenSchemeItemGV);
            fieldScreenSchemeItem.setFieldScreenScheme(fieldScreenScheme);
            fieldScreenSchemeItems.add(fieldScreenSchemeItem);
        }
        return fieldScreenSchemeItems;
    }

    protected FieldScreenSchemeItem buildFieldScreenSchemeItem(GenericValue genericValue) {
        FieldScreenSchemeItemImpl fieldScreenSchemeItem = new FieldScreenSchemeItemImpl((FieldScreenSchemeManager)this, genericValue, this.fieldScreenManager);
        fieldScreenSchemeItem.setIssueOperation(IssueOperations.getIssueOperation((Long)genericValue.getLong("operation")));
        fieldScreenSchemeItem.setFieldScreen(this.fieldScreenManager.getFieldScreen(genericValue.getLong("fieldscreen")));
        return fieldScreenSchemeItem;
    }

    public void createFieldScreenScheme(FieldScreenScheme fieldScreenScheme) {
        MapBuilder params = MapBuilder.newBuilder((Object)"name", (Object)fieldScreenScheme.getName());
        params.add((Object)"description", (Object)fieldScreenScheme.getDescription()).toMap();
        if (fieldScreenScheme.getId() != null) {
            params.add((Object)"id", (Object)fieldScreenScheme.getId());
        }
        GenericValue fieldScreenSchemeGV = this.ofBizDelegator.createValue("FieldScreenScheme", params.toMap());
        fieldScreenScheme.setGenericValue(fieldScreenSchemeGV);
    }

    public void updateFieldScreenScheme(FieldScreenScheme fieldScreenScheme) {
        this.ofBizDelegator.store(fieldScreenScheme.getGenericValue());
        this.schemeCache.remove(fieldScreenScheme.getId());
    }

    public void removeFieldSchemeItems(FieldScreenScheme fieldScreenScheme) {
        this.getOfBizDelegator().removeByAnd(FIELD_SCREEN_SCHEME_ITEM_ENTITY_NAME, MapBuilder.build((Object)"fieldscreenscheme", (Object)fieldScreenScheme.getId()));
    }

    public void removeFieldScreenScheme(FieldScreenScheme fieldScreenScheme) {
        this.ofBizDelegator.removeByAnd("FieldScreenScheme", MapBuilder.build((Object)"id", (Object)fieldScreenScheme.getId()));
        this.schemeCache.remove(fieldScreenScheme.getId());
    }

    public void createFieldScreenSchemeItem(FieldScreenSchemeItem fieldScreenSchemeItem) {
        Long issueOperationId = null;
        if (fieldScreenSchemeItem.getIssueOperation() != null) {
            issueOperationId = fieldScreenSchemeItem.getIssueOperation().getId();
        }
        Map builder = MapBuilder.newBuilder((Object)"operation", issueOperationId).add((Object)"fieldscreen", (Object)fieldScreenSchemeItem.getFieldScreen().getId()).add((Object)"fieldscreenscheme", (Object)fieldScreenSchemeItem.getFieldScreenScheme().getId()).toMap();
        GenericValue fieldScreenSchemeItemGV = this.ofBizDelegator.createValue(FIELD_SCREEN_SCHEME_ITEM_ENTITY_NAME, builder);
        fieldScreenSchemeItem.setGenericValue(fieldScreenSchemeItemGV);
        this.schemeCache.remove(fieldScreenSchemeItem.getFieldScreenScheme().getId());
    }

    public void updateFieldScreenSchemeItem(FieldScreenSchemeItem fieldScreenSchemeItem) {
        this.ofBizDelegator.store(fieldScreenSchemeItem.getGenericValue());
        this.schemeCache.remove(fieldScreenSchemeItem.getFieldScreenScheme().getId());
    }

    public void removeFieldScreenSchemeItem(FieldScreenSchemeItem fieldScreenSchemeItem) {
        this.ofBizDelegator.removeByAnd(FIELD_SCREEN_SCHEME_ITEM_ENTITY_NAME, MapBuilder.build((Object)"id", (Object)fieldScreenSchemeItem.getId()));
        this.schemeCache.remove(fieldScreenSchemeItem.getFieldScreenScheme().getId());
    }

    public Collection<FieldScreenScheme> getFieldScreenSchemes(FieldScreen fieldScreen) {
        LinkedHashSet<FieldScreenScheme> fieldScreenSchemes = new LinkedHashSet<FieldScreenScheme>();
        List fieldScreenSchemeItemGVs = this.ofBizDelegator.findByAnd(FIELD_SCREEN_SCHEME_ITEM_ENTITY_NAME, MapBuilder.build((Object)"fieldscreen", (Object)fieldScreen.getId()), Collections.singletonList("name"));
        for (GenericValue fieldScreenSchemeItemGV : fieldScreenSchemeItemGVs) {
            fieldScreenSchemes.add(this.getFieldScreenScheme(fieldScreenSchemeItemGV.getLong("fieldscreenscheme")));
        }
        return fieldScreenSchemes;
    }

    protected OfBizDelegator getOfBizDelegator() {
        return this.ofBizDelegator;
    }

    public void refresh() {
        this.schemeCache.clear();
    }
}

