/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.column;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItemImpl;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.fields.layout.column.DefaultColumnLayoutImpl;
import com.atlassian.jira.issue.fields.layout.column.EditableDefaultColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.EditableDefaultColumnLayoutImpl;
import com.atlassian.jira.issue.fields.layout.column.EditableSearchRequestColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.EditableUserColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.EditableUserColumnLayoutImpl;
import com.atlassian.jira.issue.fields.layout.column.UserColumnLayoutImpl;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.LRUMap;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractColumnLayoutManager
implements ColumnLayoutManager {
    private static final Logger log = Logger.getLogger(AbstractColumnLayoutManager.class);
    protected static final int DEFAULT_CACHE_SIZE = 200;
    private final FieldManager fieldManager;
    protected final OfBizDelegator ofBizDelegator;
    private final ColumnLayout defaultColumnLayout;
    private final Map columnLayoutCache;

    public AbstractColumnLayoutManager(FieldManager fieldManager, OfBizDelegator ofBizDelegator) {
        this.fieldManager = fieldManager;
        this.ofBizDelegator = ofBizDelegator;
        this.columnLayoutCache = Collections.synchronizedMap(new LRUMap(200));
        int position = 0;
        ArrayList<ColumnLayoutItemImpl> columnLayoutItems = new ArrayList<ColumnLayoutItemImpl>();
        columnLayoutItems.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("issuetype"), position++));
        columnLayoutItems.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("issuekey"), position++));
        columnLayoutItems.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("summary"), position++));
        columnLayoutItems.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("assignee"), position++));
        columnLayoutItems.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("reporter"), position++));
        columnLayoutItems.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("priority"), position++));
        columnLayoutItems.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("status"), position++));
        columnLayoutItems.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("resolution"), position++));
        columnLayoutItems.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("created"), position++));
        columnLayoutItems.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("updated"), position++));
        columnLayoutItems.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("duedate"), position++));
        this.defaultColumnLayout = new DefaultColumnLayoutImpl(Collections.unmodifiableList(columnLayoutItems));
    }

    public abstract boolean hasColumnLayout(SearchRequest var1) throws ColumnLayoutStorageException;

    public abstract EditableSearchRequestColumnLayout getEditableSearchRequestColumnLayout(User var1, SearchRequest var2) throws ColumnLayoutStorageException;

    public abstract void storeEditableSearchRequestColumnLayout(EditableSearchRequestColumnLayout var1) throws ColumnLayoutStorageException;

    public abstract void restoreSearchRequestColumnLayout(SearchRequest var1) throws ColumnLayoutStorageException;

    public boolean hasDefaultColumnLayout() throws ColumnLayoutStorageException {
        return this.hasDefaultColumnLayout(null);
    }

    public boolean hasColumnLayout(User user) throws ColumnLayoutStorageException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null.");
        }
        return this.hasDefaultColumnLayout(user.getName());
    }

    private boolean hasDefaultColumnLayout(String username) {
        GenericValue columnLayout = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("ColumnLayout", EasyMap.build((Object)"username", (Object)username, (Object)"searchrequest", null)));
        return columnLayout != null;
    }

    public ColumnLayout getColumnLayout(User remoteUser, SearchRequest searchRequest) throws ColumnLayoutStorageException {
        return this.getColumnLayout(remoteUser);
    }

    public ColumnLayout getColumnLayout(User remoteUser) throws ColumnLayoutStorageException {
        try {
            Set availableFields = this.fieldManager.getAvailableNavigableFields(remoteUser);
            String username = remoteUser == null ? null : remoteUser.getName();
            return new UserColumnLayoutImpl(this.getColumnLayoutItems(username, availableFields), remoteUser);
        }
        catch (FieldException e) {
            log.error((Object)e, (Throwable)e);
            throw new ColumnLayoutStorageException("Could not retrieve available fields.", (Throwable)e);
        }
    }

    public ColumnLayout getDefaultColumnLayout(User remoteUser) throws ColumnLayoutStorageException {
        try {
            Set availableFields = this.fieldManager.getAvailableNavigableFields(remoteUser);
            return new DefaultColumnLayoutImpl(this.getColumnLayoutItems(null, availableFields));
        }
        catch (FieldException e) {
            log.error((Object)e, (Throwable)e);
            throw new ColumnLayoutStorageException("Could not retrieve available fields.", (Throwable)e);
        }
    }

    public ColumnLayout getDefaultColumnLayout() throws ColumnLayoutStorageException {
        return new DefaultColumnLayoutImpl(this.defaultColumnLayout.getColumnLayoutItems());
    }

    public void refresh() {
        this.columnLayoutCache.clear();
    }

    public EditableDefaultColumnLayout getEditableDefaultColumnLayout() throws ColumnLayoutStorageException {
        try {
            Set availableFields = this.fieldManager.getAllAvailableNavigableFields();
            return new EditableDefaultColumnLayoutImpl(this.getColumnLayoutItems(null, availableFields));
        }
        catch (FieldException e) {
            log.error((Object)e, (Throwable)e);
            throw new ColumnLayoutStorageException("Could not retrieve available fields.", (Throwable)e);
        }
    }

    public EditableUserColumnLayout getEditableUserColumnLayout(User user) throws ColumnLayoutStorageException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null.");
        }
        try {
            Set availableFields = this.fieldManager.getAvailableNavigableFields(user);
            List items = this.getColumnLayoutItems(user.getName(), availableFields);
            return new EditableUserColumnLayoutImpl(items, user);
        }
        catch (FieldException e) {
            log.error((Object)e, (Throwable)e);
            throw new ColumnLayoutStorageException("Could not retrieve available fields for user '" + user.getName() + "'.", (Throwable)e);
        }
    }

    protected List getColumnLayoutItems(String username, Set availableFields) throws ColumnLayoutStorageException {
        List columnLayoutItems = (List)this.columnLayoutCache.get(username);
        if (columnLayoutItems != null) {
            return columnLayoutItems;
        }
        GenericValue columnLayoutGV = null;
        if (username != null) {
            columnLayoutGV = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("ColumnLayout", EasyMap.build((Object)"username", (Object)username, (Object)"searchrequest", null)));
        }
        if (columnLayoutGV == null && (columnLayoutGV = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("ColumnLayout", EasyMap.build((Object)"username", null, (Object)"searchrequest", null)))) == null) {
            columnLayoutItems = this.removeUnavailableColumnLayoutItems(this.defaultColumnLayout.getColumnLayoutItems(), availableFields);
            this.columnLayoutCache.put(username, columnLayoutItems);
            return columnLayoutItems;
        }
        try {
            columnLayoutItems = this.verifyColumnLayoutItems(columnLayoutGV, availableFields);
            this.columnLayoutCache.put(username, columnLayoutItems);
            return columnLayoutItems;
        }
        catch (GenericEntityException e) {
            log.error((Object)e, (Throwable)e);
            throw new ColumnLayoutStorageException("Could not retrieve the Column Layout Items.", (Throwable)e);
        }
    }

    protected List verifyColumnLayoutItems(GenericValue columnLayoutGV, Set availableFields) throws GenericEntityException {
        List<ColumnLayoutItemImpl> columnLayoutItems = new ArrayList();
        List columnLayoutItemGVs = columnLayoutGV.getRelatedOrderBy("ChildColumnLayoutItem", EasyList.build((Object)"horizontalposition ASC"));
        for (int i = 0; i < columnLayoutItemGVs.size(); ++i) {
            GenericValue columnLayoutItemGV = (GenericValue)columnLayoutItemGVs.get(i);
            if (!this.fieldManager.isNavigableField(columnLayoutItemGV.getString("fieldidentifier"))) continue;
            NavigableField navigableField = this.fieldManager.getNavigableField(columnLayoutItemGV.getString("fieldidentifier"));
            columnLayoutItems.add(new ColumnLayoutItemImpl(navigableField, columnLayoutItemGV.getLong("horizontalposition").intValue()));
        }
        columnLayoutItems = this.removeUnavailableColumnLayoutItems(columnLayoutItems, availableFields);
        return columnLayoutItems;
    }

    private List removeUnavailableColumnLayoutItems(List columnLayoutItems, Set availableFields) {
        ArrayList<ColumnLayoutItem> availableColumnLyaoutItems = new ArrayList<ColumnLayoutItem>();
        for (int i = 0; i < columnLayoutItems.size(); ++i) {
            ColumnLayoutItem columnLayoutItem = (ColumnLayoutItem)columnLayoutItems.get(i);
            if (!availableFields.contains(columnLayoutItem.getNavigableField())) continue;
            availableColumnLyaoutItems.add(columnLayoutItem);
        }
        return availableColumnLyaoutItems;
    }

    public void storeEditableDefaultColumnLayout(EditableDefaultColumnLayout editableDefaultColumnLayout) throws ColumnLayoutStorageException {
        this.storeEditableColumnLayout((ColumnLayout)editableDefaultColumnLayout, null);
        this.columnLayoutCache.clear();
    }

    public void storeEditableUserColumnLayout(EditableUserColumnLayout editableUserColumnLayout) throws ColumnLayoutStorageException {
        String username = editableUserColumnLayout.getUser().getName();
        this.storeEditableColumnLayout((ColumnLayout)editableUserColumnLayout, username);
        this.columnLayoutCache.remove(username);
    }

    private synchronized void storeEditableColumnLayout(ColumnLayout columnLayout, String username) throws ColumnLayoutStorageException {
        try {
            GenericValue columnLayoutGV = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("ColumnLayout", EasyMap.build((Object)"username", (Object)username, (Object)"searchrequest", null)));
            if (columnLayoutGV == null) {
                columnLayoutGV = EntityUtils.createValue("ColumnLayout", EasyMap.build((Object)"username", (Object)username, (Object)"searchrequest", null));
            }
            this.storeColumnLayoutItems(columnLayoutGV, columnLayout);
        }
        catch (GenericEntityException e) {
            log.error((Object)e, (Throwable)e);
            throw new ColumnLayoutStorageException("Could not load ColumnLayout", (Throwable)e);
        }
    }

    protected void storeColumnLayoutItems(GenericValue columnLayoutGV, ColumnLayout columnLayout) throws GenericEntityException {
        List columnLayoutItemGVs = columnLayoutGV.getRelated("ChildColumnLayoutItem");
        this.ofBizDelegator.removeAll(columnLayoutItemGVs);
        List columnLayoutItems = columnLayout.getColumnLayoutItems();
        for (int i = 0; i < columnLayoutItems.size(); ++i) {
            ColumnLayoutItem columnLayoutItem = (ColumnLayoutItem)columnLayoutItems.get(i);
            EntityUtils.createValue("ColumnLayoutItem", EasyMap.build((Object)"columnlayout", (Object)columnLayoutGV.getLong("id"), (Object)"fieldidentifier", (Object)columnLayoutItem.getNavigableField().getId(), (Object)"horizontalposition", (Object)new Long(i)));
        }
    }

    public void restoreDefaultColumnLayout() throws ColumnLayoutStorageException {
        this.restoreColumnLayout(null);
        this.columnLayoutCache.clear();
    }

    public void restoreUserColumnLayout(User user) throws ColumnLayoutStorageException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null.");
        }
        String username = user.getName();
        this.restoreColumnLayout(username);
        this.columnLayoutCache.remove(username);
    }

    private synchronized void restoreColumnLayout(String username) throws ColumnLayoutStorageException {
        try {
            GenericValue columnLayoutGV = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("ColumnLayout", EasyMap.build((Object)"username", (Object)username, (Object)"searchrequest", null)));
            if (columnLayoutGV != null) {
                this.removeColumnLayoutItems(columnLayoutGV);
            } else {
                log.warn((Object)("User with username '" + username + "' is already using the default layout."));
            }
        }
        catch (GenericEntityException e) {
            log.error((Object)("Error removing column layout for username " + username + "."), (Throwable)e);
            throw new ColumnLayoutStorageException("Error removing column layout for username " + username + ".", (Throwable)e);
        }
    }

    protected void removeColumnLayoutItems(GenericValue columnLayoutGV) throws GenericEntityException {
        List columnLayoutItemGVs = columnLayoutGV.getRelated("ChildColumnLayoutItem");
        this.ofBizDelegator.removeAll(columnLayoutItemGVs);
        columnLayoutGV.remove();
    }

    protected FieldManager getFieldManager() {
        return this.fieldManager;
    }
}

