/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.changehistory;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChangeHistoryBatch {
    private static final Logger log = LoggerFactory.getLogger(ChangeHistoryBatch.class);
    @Nonnull
    private final OfBizDelegator ofBizDelegator;
    @Nonnull
    private final IssueManager issueManager;
    @Nonnull
    private ImmutableMap<Long, Issue> issues;
    @Nonnull
    private final ImmutableList<ChangeHistory> changeHistories;
    @Nullable
    private ImmutableMap<ChangeHistory, List<GenericValue>> batchChangeItems;

    static ChangeHistoryBatch createBatchForIssue(@Nonnull Iterable<Issue> issues, OfBizDelegator ofBizDelegator, IssueManager issueManager) {
        return new ChangeHistoryBatch(issues, ofBizDelegator, issueManager);
    }

    private ChangeHistoryBatch(@Nonnull Iterable<Issue> issues, @Nonnull OfBizDelegator ofBizDelegator, @Nonnull IssueManager issueManager) throws NullPointerException {
        this.issues = ImmutableMap.copyOf((Map)Maps.uniqueIndex(issues, (Function)new GetIssueIdFn()));
        this.issueManager = (IssueManager)Preconditions.checkNotNull((Object)issueManager, (Object)"issueManager");
        this.ofBizDelegator = (OfBizDelegator)Preconditions.checkNotNull((Object)ofBizDelegator, (Object)"ofBizDelegator");
        this.changeHistories = this.fetchAllChangeGroups();
    }

    List<ChangeHistory> asList() {
        return Lists.newArrayList(this.changeHistories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImmutableList<ChangeHistory> fetchAllChangeGroups() {
        if (this.issues.isEmpty()) {
            return ImmutableList.of();
        }
        log.debug("About to fetch change groups for issues: {}", (Object)this.issues.keySet());
        OfBizListIterator changeGroups = this.ofBizDelegator.findListIteratorByCondition("ChangeGroup", (EntityCondition)new EntityExpr("issue", EntityOperator.IN, (Object)this.issues.keySet()), null, null, (List)ImmutableList.of((Object)"created ASC", (Object)"id ASC"), null);
        try {
            log.debug("Fetched {} change groups");
            ImmutableList<ChangeHistory> immutableList = this.wrapChangeHistories((Iterable<GenericValue>)changeGroups);
            return immutableList;
        }
        finally {
            changeGroups.close();
        }
    }

    private ImmutableMap<ChangeHistory, List<GenericValue>> fetchAllChangeItems() {
        if (this.changeHistories.isEmpty()) {
            return ImmutableMap.of();
        }
        HashMap changeHistoriesById = Maps.newHashMapWithExpectedSize((int)this.changeHistories.size());
        for (ChangeHistory changeHistory : this.changeHistories) {
            changeHistoriesById.put(changeHistory.getId(), changeHistory);
        }
        log.debug("About to fetch change items for a batch of {} change groups", (Object)this.changeHistories.size());
        List changeItems = this.ofBizDelegator.findByAnd("ChangeItem", (List)ImmutableList.of((Object)new EntityExpr("group", EntityOperator.IN, changeHistoriesById.keySet())));
        log.debug("Fetched {} change items", (Object)changeItems.size());
        ArrayListMultimap changeItemsByChangeGroup = ArrayListMultimap.create();
        for (GenericValue changeItem : changeItems) {
            Long parentId = changeItem.getLong("group");
            ChangeHistory parent = (ChangeHistory)changeHistoriesById.get(parentId);
            if (parent == null) {
                log.error("Change item {} is not a child of change groups: {}", (Object)parentId, changeHistoriesById.keySet());
                continue;
            }
            changeItemsByChangeGroup.put((Object)parent, (Object)changeItem);
        }
        return ChangeHistoryBatch.makeImmutable(changeItemsByChangeGroup);
    }

    private ImmutableList<ChangeHistory> wrapChangeHistories(Iterable<GenericValue> changeHistories) {
        if (changeHistories == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Iterable)Iterables.transform(changeHistories, (Function)new Function<GenericValue, ChangeHistory>(){

            public ChangeHistory apply(@Nullable GenericValue changeHistory) {
                return changeHistory != null ? new BatchingChangeHistory(changeHistory) : null;
            }
        }));
    }

    private static <T, U> ImmutableMap<T, List<U>> makeImmutable(Multimap<? extends T, ? extends U> multimap) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : multimap.asMap().entrySet()) {
            builder.put(entry.getKey(), (Object)Lists.newArrayList((Iterable)((Iterable)entry.getValue())));
        }
        return builder.build();
    }

    private class BatchingChangeHistory
    extends ChangeHistory {
        public BatchingChangeHistory(GenericValue changeHistoryGV) {
            super(changeHistoryGV, ChangeHistoryBatch.this.issueManager);
        }

        public Issue getIssue() {
            return (Issue)ChangeHistoryBatch.this.issues.get((Object)this.getIssueId());
        }

        public List<GenericValue> getChangeItems() {
            if (ChangeHistoryBatch.this.batchChangeItems == null) {
                ChangeHistoryBatch.this.batchChangeItems = ChangeHistoryBatch.this.fetchAllChangeItems();
            }
            return (List)ChangeHistoryBatch.this.batchChangeItems.get((Object)this);
        }
    }

    private static class GetIssueIdFn
    implements Function<Issue, Long> {
        private GetIssueIdFn() {
        }

        public Long apply(Issue issue) {
            return issue.getId();
        }
    }
}

