/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.xml;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.imports.xml.BackupXmlParser;
import com.atlassian.jira.util.XmlReader;
import com.atlassian.jira.util.xml.JiraFileInputStream;
import com.atlassian.jira.util.xml.SecureXmlEntityResolver;
import com.atlassian.jira.util.xml.XMLCleaningReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultBackupXmlParser
implements BackupXmlParser {
    private static final Logger log = Logger.getLogger(DefaultBackupXmlParser.class);
    private static final EntityResolver EMPTY_ENTITY_RESOLVER = new SecureXmlEntityResolver();
    private final ApplicationProperties applicationProperties;

    public DefaultBackupXmlParser(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Override
    public void parseBackupXml(String fileName, DefaultHandler handler) throws IOException, SAXException {
        SAXParser saxParser;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            saxParser = factory.newSAXParser();
            saxParser.getXMLReader().setEntityResolver(EMPTY_ENTITY_RESOLVER);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        InputSource inputSource = this.getInputSource(fileName);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start parsing XML with SAX Parser");
        }
        saxParser.parse(inputSource, handler);
        if (log.isDebugEnabled()) {
            log.debug((Object)"XML successfully parsed");
        }
    }

    private InputSource getInputSource(String fileName) throws IOException {
        JiraFileInputStream is = new JiraFileInputStream(new File(fileName));
        if (this.cleanXml()) {
            Reader reader = this.getFilteredReader(is);
            return new InputSource(reader);
        }
        return new InputSource(is);
    }

    private Reader getFilteredReader(InputStream is) throws IOException {
        XmlReader xmlReader = XmlReader.createReader(is);
        return new XMLCleaningReader(new InputStreamReader(xmlReader.getInputStream(), xmlReader.getEncoding()));
    }

    private boolean cleanXml() {
        return this.applicationProperties.getOption("jira.exportimport.cleanxml");
    }
}

