/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.core;

import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;

public class ProjectImportResultsImpl
implements ProjectImportResults {
    private Project importedProject;
    private final List<String> errors;
    private final Map<String, AtomicInteger> roleUsersCreatedCountByRole;
    private final Map<String, AtomicInteger> roleGroupsCreatedCountByRole;
    private final Set<String> roles;
    private final AtomicInteger issuesCreatedCount;
    private final AtomicInteger usersCreatedCount;
    private final AtomicInteger attachmentsCreatedCount;
    private final AtomicInteger errorCount;
    private final long startTime;
    private final int expectedIssuesCreatedCount;
    private final int expectedUsersCreatedCount;
    private final int expectedAttachmentsCreatedCount;
    private final I18nHelper i18n;
    private long endTime;
    private boolean importCompleted;

    public ProjectImportResultsImpl(long startTime, int expectedIssuesCreatedCount, int expectedUsersCreatedCount, int expectedAttachmentsCreatedCount, I18nHelper i18n) {
        this.startTime = startTime;
        this.expectedIssuesCreatedCount = expectedIssuesCreatedCount;
        this.expectedUsersCreatedCount = expectedUsersCreatedCount;
        this.expectedAttachmentsCreatedCount = expectedAttachmentsCreatedCount;
        this.i18n = i18n;
        this.issuesCreatedCount = new AtomicInteger(0);
        this.usersCreatedCount = new AtomicInteger(0);
        this.errorCount = new AtomicInteger(0);
        this.attachmentsCreatedCount = new AtomicInteger(0);
        this.errors = Collections.synchronizedList(new ArrayList());
        this.roleUsersCreatedCountByRole = new HashMap<String, AtomicInteger>();
        this.roleGroupsCreatedCountByRole = new HashMap<String, AtomicInteger>();
        this.roles = Collections.synchronizedSet(new TreeSet());
    }

    @Override
    public long getImportDuration() {
        return this.endTime - this.startTime;
    }

    @Override
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @Override
    public synchronized void incrementRoleUserCreatedCount(String roleName) {
        AtomicInteger roleUsersCreated = this.roleUsersCreatedCountByRole.get(roleName);
        if (roleUsersCreated == null) {
            roleUsersCreated = new AtomicInteger(0);
            this.roleUsersCreatedCountByRole.put(roleName, roleUsersCreated);
            this.roles.add(roleName);
        }
        roleUsersCreated.incrementAndGet();
    }

    @Override
    public synchronized void incrementRoleGroupCreatedCount(String roleName) {
        AtomicInteger roleGroupsCreated = this.roleGroupsCreatedCountByRole.get(roleName);
        if (roleGroupsCreated == null) {
            roleGroupsCreated = new AtomicInteger(0);
            this.roleGroupsCreatedCountByRole.put(roleName, roleGroupsCreated);
            this.roles.add(roleName);
        }
        roleGroupsCreated.incrementAndGet();
    }

    @Override
    public Collection<String> getRoles() {
        return Collections.unmodifiableCollection(this.roles);
    }

    @Override
    public int getGroupsCreatedCountForRole(String roleName) {
        AtomicInteger groupsCreatedForRole = this.roleGroupsCreatedCountByRole.get(roleName);
        if (groupsCreatedForRole != null) {
            return groupsCreatedForRole.get();
        }
        return 0;
    }

    @Override
    public int getUsersCreatedCountForRole(String roleName) {
        AtomicInteger usersCreatedForRole = this.roleUsersCreatedCountByRole.get(roleName);
        if (usersCreatedForRole != null) {
            return usersCreatedForRole.get();
        }
        return 0;
    }

    @Override
    public void addError(String error) {
        this.errors.add(error);
        this.errorCount.incrementAndGet();
    }

    int getErrorCountLimit() {
        return 10;
    }

    @Override
    public List<String> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    @Override
    public boolean isImportCompleted() {
        return this.importCompleted;
    }

    @Override
    public void incrementIssuesCreatedCount() {
        this.issuesCreatedCount.incrementAndGet();
    }

    @Override
    public void incrementUsersCreatedCount() {
        this.usersCreatedCount.incrementAndGet();
    }

    @Override
    public void incrementAttachmentsCreatedCount() {
        this.attachmentsCreatedCount.incrementAndGet();
    }

    @Override
    public int getIssuesCreatedCount() {
        return this.issuesCreatedCount.get();
    }

    @Override
    public int getUsersCreatedCount() {
        return this.usersCreatedCount.get();
    }

    @Override
    public int getAttachmentsCreatedCount() {
        return this.attachmentsCreatedCount.get();
    }

    @Override
    public int getExpectedIssuesCreatedCount() {
        return this.expectedIssuesCreatedCount;
    }

    @Override
    public int getExpectedUsersCreatedCount() {
        return this.expectedUsersCreatedCount;
    }

    @Override
    public int getExpectedAttachmentsCreatedCount() {
        return this.expectedAttachmentsCreatedCount;
    }

    @Override
    public void setImportCompleted(boolean importCompleted) {
        this.importCompleted = importCompleted;
    }

    @Override
    public Project getImportedProject() {
        return this.importedProject;
    }

    @Override
    public void setImportedProject(Project importedProject) {
        this.importedProject = importedProject;
    }

    @Override
    public I18nHelper getI18n() {
        return this.i18n;
    }

    @Override
    public boolean abortImport() {
        return this.errorCount.get() >= this.getErrorCountLimit();
    }
}

