/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity;

import com.atlassian.jira.entity.EntityBuilder;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.EntityListConsumer;
import com.atlassian.jira.entity.SelectQuery;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

public class SelectQueryImpl<E>
implements SelectQuery<E> {
    private final boolean distinct;
    private final Collection<String> fieldsToSelect;
    private final String entityName;
    private final EntityBuilder<E> entityBuilder;
    private final FieldMap whereClause;
    private final List<String> orderBy;

    public SelectQueryImpl(boolean distinct, Collection<String> fieldsToSelect, String entityName, EntityBuilder<E> entityBuilder, FieldMap whereClause, List<String> orderBy) {
        this.distinct = distinct;
        this.fieldsToSelect = fieldsToSelect;
        this.entityName = entityName;
        this.entityBuilder = entityBuilder;
        this.whereClause = whereClause;
        this.orderBy = orderBy;
    }

    @Override
    public SelectQuery.ExecutionContext<E> runWith(OfBizDelegator ofBizDelegator) {
        return new ExecutionContextImpl<E>(ofBizDelegator, this.entityBuilder);
    }

    @Override
    public SelectQuery.ExecutionContext<E> runWith(EntityEngine entityEngine) {
        return entityEngine.run(this);
    }

    private EntityCondition getWhereEntityCondition() {
        if (this.whereClause == null) {
            return null;
        }
        return new EntityFieldMap((Map)this.whereClause, EntityOperator.AND);
    }

    public final class ExecutionContextImpl<E>
    implements SelectQuery.ExecutionContext<E> {
        private OfBizDelegator ofBizDelegator;
        private final EntityBuilder<E> entityBuilder;

        public ExecutionContextImpl(OfBizDelegator ofBizDelegator, EntityBuilder<E> entityBuilder) {
            this.ofBizDelegator = ofBizDelegator;
            this.entityBuilder = entityBuilder;
        }

        @Override
        public List<E> asList() {
            return (List)this.consumeWith(new EntityListConsumer<E, List<E>>(){
                public List<E> list = new ArrayList();

                @Override
                public void consume(E entity) {
                    this.list.add(entity);
                }

                @Override
                public List<E> result() {
                    return this.list;
                }
            });
        }

        @Override
        public E singleValue() throws IllegalStateException {
            return (E)this.consumeWith(new EntityListConsumer<E, E>(){
                private E value = null;
                private boolean found = false;

                @Override
                public void consume(E entity) {
                    if (this.found) {
                        throw new IllegalStateException("Too many rows found for query on " + SelectQueryImpl.this.entityName);
                    }
                    this.value = entity;
                    this.found = true;
                }

                @Override
                public E result() {
                    return this.value;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <R> R consumeWith(EntityListConsumer<E, R> consumer) {
            EntityFindOptions entityFindOptions = new EntityFindOptions();
            entityFindOptions.setDistinct(SelectQueryImpl.this.distinct);
            OfBizListIterator ofBizListIterator = this.ofBizDelegator.findListIteratorByCondition(SelectQueryImpl.this.entityName, SelectQueryImpl.this.getWhereEntityCondition(), null, SelectQueryImpl.this.fieldsToSelect, SelectQueryImpl.this.orderBy, entityFindOptions);
            try {
                for (GenericValue genericValue : ofBizListIterator) {
                    consumer.consume(this.entityBuilder.build(genericValue));
                }
            }
            finally {
                ofBizListIterator.close();
            }
            return consumer.result();
        }
    }
}

