/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.db;

import com.atlassian.jira.configurator.config.ValidationException;
import com.atlassian.jira.configurator.db.CommonConfigPanel;
import com.atlassian.jira.configurator.db.DatabaseInstance;
import com.atlassian.jira.configurator.db.PostgresDatabaseConfig;
import com.atlassian.jira.configurator.gui.ConfigPanelBuilder;
import com.atlassian.jira.exception.ParseException;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PostgresConfigPanel
extends CommonConfigPanel {
    private JTextField tfDatabase = new JTextField(20);
    private JTextField tfSchemaName = new JTextField("public", 20);

    public PostgresConfigPanel() {
        super(new PostgresDatabaseConfig());
    }

    @Override
    public String getDisplayName() {
        return "PostgresQL";
    }

    @Override
    public String getSchemaName() {
        return this.tfSchemaName.getText();
    }

    @Override
    protected JPanel buildConfigPanel() {
        ConfigPanelBuilder panelBuilder = new ConfigPanelBuilder();
        panelBuilder.add("Hostname", this.tfHostname);
        panelBuilder.add("Port", this.tfPort);
        panelBuilder.add("Database", this.tfDatabase);
        panelBuilder.add("Username", this.tfUsername);
        panelBuilder.add("Password", this.tfPassword);
        panelBuilder.add("Schema", this.tfSchemaName);
        this.tfPort.setText("5432");
        this.tfDatabase.setToolTipText("The Postgres database to connect to");
        this.tfSchemaName.setToolTipText("Normally the schema-name is set to 'public'.");
        return panelBuilder.getPanel();
    }

    @Override
    protected void setUrlSettings(DatabaseInstance connectionProperties) throws ParseException {
        this.tfHostname.setText(connectionProperties.getHostname());
        this.tfPort.setText(connectionProperties.getPort());
        this.tfDatabase.setText(connectionProperties.getInstance());
    }

    @Override
    protected void setSchemaName(String schemaName) {
        this.tfSchemaName.setText(schemaName);
    }

    @Override
    public void validate() throws ValidationException {
        super.validate();
        this.validateNotBlank("Database", this.tfDatabase.getText());
    }

    @Override
    protected String getHostname() {
        return this.tfHostname.getText().trim();
    }

    @Override
    protected String getPort() {
        return this.tfPort.getText().trim();
    }

    @Override
    protected String getInstance() {
        return this.tfDatabase.getText().trim();
    }
}

