/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.console;

import com.atlassian.jira.configurator.Configurator;
import com.atlassian.jira.configurator.config.ConnectionPoolField;
import com.atlassian.jira.configurator.config.DatabaseType;
import com.atlassian.jira.configurator.config.DefaultFileSystem;
import com.atlassian.jira.configurator.config.FileSystem;
import com.atlassian.jira.configurator.config.Settings;
import com.atlassian.jira.configurator.config.SettingsLoader;
import com.atlassian.jira.configurator.config.ValidationException;
import com.atlassian.jira.configurator.config.Validator;
import com.atlassian.jira.configurator.console.ConsoleProvider;
import com.atlassian.jira.configurator.console.ConsoleToolkit;
import com.atlassian.jira.configurator.console.WebServerConfigurationConsole;
import com.atlassian.jira.configurator.db.ConfigField;
import com.atlassian.jira.configurator.db.DatabaseConfigConsole;
import com.atlassian.jira.configurator.db.DatabaseConfigConsoleImpl;
import com.atlassian.jira.configurator.db.HsqlDatabaseConfig;
import com.atlassian.jira.configurator.db.MySqlDatabaseConfig;
import com.atlassian.jira.configurator.db.OracleDatabaseConfig;
import com.atlassian.jira.configurator.db.PostgresDatabaseConfig;
import com.atlassian.jira.configurator.db.SqlServerDatabaseConfig;
import com.atlassian.jira.configurator.ssl.DefaultKeyStoreProvider;
import com.atlassian.jira.configurator.ssl.KeyStoreAccessorImpl;
import com.atlassian.jira.exception.ParseException;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.ofbiz.core.entity.config.ConnectionPoolInfo;

public class ConfiguratorConsole {
    final ConsoleProvider console = ConsoleProvider.Factory.getInstance();
    private final ConsoleToolkit consoleToolkit = new ConsoleToolkit(this.console);
    private final KeyStoreAccessorImpl keyStoreAccessor = new KeyStoreAccessorImpl(new DefaultKeyStoreProvider());
    private final FileSystem fileSystem = new DefaultFileSystem();
    private Settings settings = new Settings();
    private final DatabaseConfigConsole HSQL_CONFIG = new HsqlDatabaseConfig();
    private final DatabaseConfigConsole MYSQL_CONFIG = new DatabaseConfigConsoleImpl(new MySqlDatabaseConfig());
    private final DatabaseConfigConsole ORACLE_CONFIG = new DatabaseConfigConsoleImpl(new OracleDatabaseConfig());
    private final DatabaseConfigConsole POSTGRES_CONFIG = new DatabaseConfigConsoleImpl(new PostgresDatabaseConfig());
    private final DatabaseConfigConsole SQL_SERVER_CONFIG = new DatabaseConfigConsoleImpl(new SqlServerDatabaseConfig());
    private DatabaseType selectedDatabaseType = DatabaseType.HSQL;

    public void setSettings(Settings settings) {
        this.settings = settings;
        this.selectedDatabaseType = settings.initDatabaseType(false);
        try {
            this.getSelectedDatabaseConfig().setSettings(settings);
        }
        catch (ParseException e) {
            this.console.printErrorMessage("Unable to fully parse the current JDBC settings. Some settings may be blank.");
            this.console.printErrorMessage("Parse Exception: " + e.getMessage());
        }
    }

    public void start() {
        this.showWelcomeMessage();
        try {
            this.showMainMenu();
            System.exit(0);
        }
        catch (IOException e) {
            this.console.println();
            this.console.printErrorMessage("A fatal IOException has occurred: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    private int showMainMenu() throws IOException {
        do {
            this.console.println();
            this.console.println("--- Main Menu ---");
            this.consoleToolkit.showMenuItem('H', "Configure JIRA Home");
            this.consoleToolkit.showMenuItem('D', "Database Selection");
            this.consoleToolkit.showMenuItem('W', "Web Server (incl. HTTP/HTTPs configuration)");
            this.consoleToolkit.showMenuItem('A', "Advanced Settings");
            this.consoleToolkit.showMenuItem('S', "Save and Exit");
            this.consoleToolkit.showMenuItem('X', "Exit without Saving");
            this.console.println();
        } while (this.processMainMenu());
        return 0;
    }

    private boolean processMainMenu() throws IOException {
        char ch;
        block10: while (true) {
            ch = this.consoleToolkit.readMenuChoice("Main Menu");
            switch (ch) {
                case '\n': 
                case '\r': {
                    continue block10;
                }
                case '?': {
                    return true;
                }
                case 'X': {
                    return false;
                }
                case 'H': {
                    this.showJiraHomeSettings();
                    return true;
                }
                case 'D': {
                    this.showDatabaseSettings();
                    return true;
                }
                case 'W': {
                    this.showWebServerConfiguration();
                    return true;
                }
                case 'S': {
                    return !this.saveSettings();
                }
                case 'A': {
                    this.showAdvancedSettings();
                    return true;
                }
            }
            break;
        }
        this.console.println("Unknown command '" + ch + "'");
        return true;
    }

    private void showWebServerConfiguration() throws IOException {
        WebServerConfigurationConsole webServerConfigurationConsole = new WebServerConfigurationConsole(this.console, this.keyStoreAccessor, this.fileSystem, this.settings);
        webServerConfigurationConsole.showSettings();
    }

    private void showJiraHomeSettings() throws IOException {
        this.console.println("Current JIRA Home: " + this.settings.getJiraHome());
        while (this.acceptNewJiraHome()) {
        }
    }

    private boolean acceptNewJiraHome() throws IOException {
        String newJiraHome = this.console.readLine("New JIRA Home");
        if (newJiraHome.length() == 0 || newJiraHome.equals(this.settings.getJiraHome())) {
            this.console.println("The JIRA Home directory was not changed.");
            return false;
        }
        File file = new File(newJiraHome).getAbsoluteFile();
        if (!file.isDirectory()) {
            this.console.printErrorMessage(file.exists() ? "The specified path already exists and it is not a directory." : "That directory does not exist.");
            return true;
        }
        this.settings.setJiraHome(file.getAbsolutePath());
        if (new File(file, "dbconfig.xml").canRead()) {
            this.console.println("The specified directory has a dbconfig.xml in it.");
            if (this.console.readYesNo("Reload database configuration", true)) {
                try {
                    this.settings = SettingsLoader.reloadDbConfig(newJiraHome);
                    this.console.println("Settings successfully reloaded.");
                }
                catch (IOException ioe) {
                    this.console.printErrorMessage(ioe);
                    this.console.printErrorMessage("Some of your settings may not have been loaded.");
                }
            }
        }
        return false;
    }

    private boolean saveSettings() {
        try {
            Configurator.saveSettings(this.gatherNewSettings());
            this.console.println("Settings saved successfully.");
            return true;
        }
        catch (ValidationException ex) {
            this.console.printErrorMessage(ex);
        }
        catch (IOException ex) {
            this.console.printErrorMessage(ex);
        }
        catch (ParseException ex) {
            this.console.printErrorMessage(ex);
        }
        return false;
    }

    private Settings gatherNewSettings() throws ValidationException {
        this.getSelectedDatabaseConfig().saveSettings(this.settings);
        return this.settings;
    }

    private void showWelcomeMessage() {
        this.console.println("----------------------");
        this.console.println("JIRA Configurator v1.1");
        this.console.println("----------------------");
    }

    private void showDatabaseSettings() throws IOException {
        do {
            this.console.println();
            this.console.println("--- Database Selection ---");
            this.console.println("  Database Type : " + this.selectedDatabaseType.getDisplayName());
            this.console.println("  Instance      : " + this.getSelectedDatabaseConfig().getInstanceName());
            String pass = this.getSelectedDatabaseConfig().getPassword();
            this.console.println("  Connect As    : " + this.getSelectedDatabaseConfig().getUsername() + " / " + (pass != null && pass.length() > 0 ? "*****" : "(no password)"));
            this.console.println();
            char defaultCommand = this.selectedDatabaseType.getDisplayName().charAt(0);
            this.consoleToolkit.showMenuItem('H', "HSQL (not for production use)", defaultCommand);
            this.consoleToolkit.showMenuItem('M', "MySQL", defaultCommand);
            this.consoleToolkit.showMenuItem('O', "Oracle", defaultCommand);
            this.consoleToolkit.showMenuItem('P', "PostgreSQL", defaultCommand);
            this.consoleToolkit.showMenuItem('S', "SQL Server (MS-SQL)", defaultCommand);
            this.console.println();
            this.consoleToolkit.showMenuItem('X', "Return to Main Menu");
            this.console.println();
        } while (this.processDatabaseSettings());
    }

    private boolean processDatabaseSettings() throws IOException {
        char ch;
        block10: while (true) {
            char defaultCommand = this.selectedDatabaseType.getDisplayName().charAt(0);
            ch = this.consoleToolkit.readMenuChoice("Database Selection [" + defaultCommand + ']');
            switch (ch) {
                case '\r': {
                    continue block10;
                }
                case '?': {
                    return true;
                }
                case 'X': {
                    return false;
                }
                case '\n': {
                    this.doDatabaseConfig();
                    return true;
                }
                case 'H': {
                    this.selectedDatabaseType = DatabaseType.HSQL;
                    this.doDatabaseConfig();
                    return true;
                }
                case 'M': {
                    this.selectedDatabaseType = DatabaseType.MY_SQL;
                    this.doDatabaseConfig();
                    return true;
                }
                case 'O': {
                    this.selectedDatabaseType = DatabaseType.ORACLE;
                    this.doDatabaseConfig();
                    return true;
                }
                case 'P': {
                    this.selectedDatabaseType = DatabaseType.POSTGRES;
                    this.doDatabaseConfig();
                    return true;
                }
            }
            break;
        }
        this.console.println("Unknown command '" + ch + "'");
        return true;
    }

    private void doDatabaseConfig() throws IOException {
        DatabaseConfigConsole databaseConfig = this.getSelectedDatabaseConfig();
        this.console.println(databaseConfig.getDatabaseType() + " Database Configuration.");
        ConfigField[] fields = databaseConfig.getFields();
        if (fields == null) {
            this.console.println("The built-in " + this.selectedDatabaseType.getDisplayName() + " database is auto-configured.");
            return;
        }
        for (ConfigField configField : databaseConfig.getFields()) {
            String newValue;
            String oldValue;
            if (configField.isPassword()) {
                oldValue = configField.getValue().length() > 0 ? "*****" : "";
                newValue = this.console.readPassword(configField.getLabel() + " (" + oldValue + ')');
                configField.setValue(newValue);
                continue;
            }
            oldValue = configField.getValue();
            newValue = this.console.readLine(configField.getLabel() + " (" + oldValue + ')');
            if (newValue.length() <= 0) continue;
            configField.setValue(newValue);
        }
        if (this.console.readYesNo("Test Connection", true)) {
            this.console.println("Attempting to connect to " + this.getSelectedDatabaseConfig().getInstanceName());
            String error = this.testConnection(databaseConfig);
            if (error == null) {
                this.console.println("Connection successful!");
            } else {
                this.console.printErrorMessage("Connection failed: " + error);
            }
        }
    }

    private String menuItemAndValue(ConnectionPoolField field, Object value) {
        return this.consoleToolkit.menuItemAndValue(field.label(), value);
    }

    private <T> T readValue(ConnectionPoolField field, T currentValue, Validator<T> validator) throws IOException {
        try {
            this.console.println(field.label());
            this.console.println("  " + field.description());
            this.console.println("  Default: " + field.defaultValue());
            this.console.flush();
            T newValue = validator.apply(field.label(), this.console.readLine("New value"));
            if (newValue != null) {
                this.console.println(field.label() + " = " + newValue);
            } else {
                this.console.println(field.label() + " restored to default setting.");
            }
            this.console.println();
            return newValue;
        }
        catch (ValidationException ve) {
            this.console.printErrorMessage(ve);
            this.console.println();
            return currentValue;
        }
    }

    private void showAdvancedSettings() throws IOException {
        ConnectionPoolInfo.Builder poolInfo = this.settings.getConnectionPoolInfoBuilder();
        do {
            this.console.println();
            this.console.println("--- Advanced Settings ---");
            this.console.println();
            this.console.println("Scalability and Performance:");
            this.consoleToolkit.showMenuItem('1', this.menuItemAndValue(ConnectionPoolField.MAX_SIZE, poolInfo.getPoolMaxSize()));
            this.consoleToolkit.showMenuItem('2', this.menuItemAndValue(ConnectionPoolField.MAX_IDLE, poolInfo.getPoolMaxIdle()));
            this.consoleToolkit.showMenuItem('3', this.menuItemAndValue(ConnectionPoolField.MIN_SIZE, poolInfo.getPoolMinSize()));
            this.consoleToolkit.showMenuItem('4', this.menuItemAndValue(ConnectionPoolField.INITIAL_SIZE, poolInfo.getPoolInitialSize()));
            this.consoleToolkit.showMenuItem('5', this.menuItemAndValue(ConnectionPoolField.MAX_WAIT, poolInfo.getPoolMaxWait()));
            this.consoleToolkit.showMenuItem('6', this.menuItemAndValue(ConnectionPoolField.POOL_STATEMENTS, poolInfo.getPoolPreparedStatements()));
            this.consoleToolkit.showMenuItem('7', this.menuItemAndValue(ConnectionPoolField.MAX_OPEN_STATEMENTS, poolInfo.getMaxOpenPreparedStatements()));
            this.console.println();
            this.console.println("Eviction Policy:");
            this.consoleToolkit.showMenuItem('A', this.menuItemAndValue(ConnectionPoolField.VALIDATION_QUERY, poolInfo.getValidationQuery()));
            this.consoleToolkit.showMenuItem('B', this.menuItemAndValue(ConnectionPoolField.VALIDATION_QUERY_TIMEOUT, poolInfo.getValidationQueryTimeout()));
            this.consoleToolkit.showMenuItem('C', this.menuItemAndValue(ConnectionPoolField.TEST_ON_BORROW, poolInfo.getTestOnBorrow()));
            this.consoleToolkit.showMenuItem('D', this.menuItemAndValue(ConnectionPoolField.TEST_ON_RETURN, poolInfo.getTestOnReturn()));
            this.consoleToolkit.showMenuItem('E', this.menuItemAndValue(ConnectionPoolField.TEST_WHILE_IDLE, poolInfo.getTestWhileIdle()));
            this.consoleToolkit.showMenuItem('F', this.menuItemAndValue(ConnectionPoolField.TIME_BETWEEN_EVICTION_RUNS, poolInfo.getTimeBetweenEvictionRunsMillis()));
            this.consoleToolkit.showMenuItem('G', this.menuItemAndValue(ConnectionPoolField.MIN_EVICTABLE_IDLE_TIME, poolInfo.getMinEvictableTimeMillis()));
            this.consoleToolkit.showMenuItem('H', this.menuItemAndValue(ConnectionPoolField.REMOVE_ABANDONED, poolInfo.getRemoveAbandoned()));
            this.consoleToolkit.showMenuItem('I', this.menuItemAndValue(ConnectionPoolField.REMOVE_ABANDONED_TIMEOUT, poolInfo.getRemoveAbandonedTimeout()));
            this.console.println();
            this.consoleToolkit.showMenuItem('X', "Exit the Advanced Settings menu");
            this.consoleToolkit.showMenuItem('?', "Redisplay this menu");
            this.console.println();
        } while (this.acceptAdvancedSettings());
    }

    private boolean acceptAdvancedSettings() throws IOException {
        char ch;
        ConnectionPoolInfo.Builder poolInfo = this.settings.getConnectionPoolInfoBuilder();
        block21: while (true) {
            ch = this.consoleToolkit.readMenuChoice("Advanced Settings");
            switch (ch) {
                case '\n': 
                case '\r': {
                    continue block21;
                }
                case '?': {
                    return true;
                }
                case 'X': {
                    return false;
                }
                case '1': {
                    poolInfo.setPoolMaxSize(this.readValue(ConnectionPoolField.MAX_SIZE, poolInfo.getPoolMaxSize(), Validator.INTEGER_POSITIVE));
                    continue block21;
                }
                case '2': {
                    poolInfo.setPoolMaxIdle(this.readValue(ConnectionPoolField.MAX_IDLE, poolInfo.getPoolMaxIdle(), Validator.INTEGER_ALLOW_MINUS_1));
                    continue block21;
                }
                case '3': {
                    poolInfo.setPoolMinSize(this.readValue(ConnectionPoolField.MIN_SIZE, poolInfo.getPoolMinSize(), Validator.INTEGER_POSITIVE_OR_ZERO));
                    continue block21;
                }
                case '4': {
                    poolInfo.setPoolInitialSize(this.readValue(ConnectionPoolField.INITIAL_SIZE, poolInfo.getPoolInitialSize(), Validator.INTEGER_POSITIVE_OR_ZERO));
                    continue block21;
                }
                case '5': {
                    poolInfo.setPoolMaxWait(this.readValue(ConnectionPoolField.MAX_WAIT, poolInfo.getPoolMaxWait(), Validator.LONG_ALLOW_MINUS_1));
                    continue block21;
                }
                case '6': {
                    poolInfo.setPoolPreparedStatements(this.readValue(ConnectionPoolField.POOL_STATEMENTS, poolInfo.getPoolPreparedStatements(), Validator.BOOLEAN));
                    continue block21;
                }
                case '7': {
                    poolInfo.setMaxOpenPreparedStatements(this.readValue(ConnectionPoolField.MAX_OPEN_STATEMENTS, poolInfo.getMaxOpenPreparedStatements(), Validator.INTEGER_ALLOW_MINUS_1));
                    continue block21;
                }
                case 'A': {
                    poolInfo.setValidationQuery(this.readValue(ConnectionPoolField.VALIDATION_QUERY, poolInfo.getValidationQuery(), Validator.TRIMMED_STRING));
                    continue block21;
                }
                case 'B': {
                    poolInfo.setValidationQueryTimeout(this.readValue(ConnectionPoolField.VALIDATION_QUERY_TIMEOUT, poolInfo.getValidationQueryTimeout(), Validator.INTEGER_ALLOW_MINUS_1));
                    continue block21;
                }
                case 'C': {
                    poolInfo.setTestOnBorrow(this.readValue(ConnectionPoolField.TEST_ON_BORROW, poolInfo.getTestOnBorrow(), Validator.BOOLEAN));
                    continue block21;
                }
                case 'D': {
                    poolInfo.setTestOnReturn(this.readValue(ConnectionPoolField.TEST_ON_RETURN, poolInfo.getTestOnReturn(), Validator.BOOLEAN));
                    continue block21;
                }
                case 'E': {
                    poolInfo.setTestWhileIdle(this.readValue(ConnectionPoolField.TEST_WHILE_IDLE, poolInfo.getTestWhileIdle(), Validator.BOOLEAN));
                    continue block21;
                }
                case 'F': {
                    poolInfo.setTimeBetweenEvictionRunsMillis(this.readValue(ConnectionPoolField.TIME_BETWEEN_EVICTION_RUNS, poolInfo.getTimeBetweenEvictionRunsMillis(), Validator.LONG_ALLOW_MINUS_1));
                    continue block21;
                }
                case 'G': {
                    poolInfo.setMinEvictableTimeMillis(this.readValue(ConnectionPoolField.MIN_EVICTABLE_IDLE_TIME, poolInfo.getMinEvictableTimeMillis(), Validator.LONG_POSITIVE));
                    continue block21;
                }
                case 'H': {
                    poolInfo.setRemoveAbandoned(this.readValue(ConnectionPoolField.REMOVE_ABANDONED, poolInfo.getRemoveAbandoned(), Validator.BOOLEAN));
                    continue block21;
                }
                case 'I': {
                    poolInfo.setRemoveAbandonedTimeout(this.readValue(ConnectionPoolField.REMOVE_ABANDONED_TIMEOUT, poolInfo.getRemoveAbandonedTimeout(), Validator.INTEGER_POSITIVE));
                    continue block21;
                }
            }
            break;
        }
        this.console.println("Unknown command '" + ch + "'");
        return true;
    }

    private String testConnection(DatabaseConfigConsole databaseConfig) {
        String errorMessage;
        try {
            databaseConfig.testConnection();
            return null;
        }
        catch (UnsupportedClassVersionError ex) {
            errorMessage = "UnsupportedClassVersionError occurred. It is likely your JDBC drivers use a newer version of Java than you are running now.";
        }
        catch (ClassNotFoundException ex) {
            errorMessage = "Driver class '" + databaseConfig.getClassName() + "' not found. Ensure the DB driver is installed in the 'lib' directory.";
        }
        catch (SQLException ex) {
            String message = ex.getMessage();
            if (message.contains("Stack Trace")) {
                if (message.contains("UnknownHostException")) {
                    message = "Unknown host.";
                } else if (message.contains("Check that the hostname and port are correct")) {
                    message = "Check that the hostname and port are correct.";
                }
            }
            errorMessage = "Could not connect to the DB: " + message;
        }
        catch (RuntimeException ex) {
            errorMessage = "An unexpected error occurred: " + ex.getMessage();
            System.err.println(errorMessage);
            ex.printStackTrace(System.err);
        }
        catch (ValidationException e) {
            errorMessage = e.getMessage();
        }
        return errorMessage;
    }

    private DatabaseConfigConsole getSelectedDatabaseConfig() {
        switch (this.selectedDatabaseType) {
            case HSQL: {
                return this.HSQL_CONFIG;
            }
            case ORACLE: {
                return this.ORACLE_CONFIG;
            }
            case MY_SQL: {
                return this.MYSQL_CONFIG;
            }
            case POSTGRES: {
                return this.POSTGRES_CONFIG;
            }
            case SQL_SERVER: {
                return this.SQL_SERVER_CONFIG;
            }
        }
        throw new IllegalStateException("Unknown database type " + (Object)((Object)this.selectedDatabaseType));
    }
}

