/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.component;

import com.atlassian.jira.config.component.TimerInvocationHandler;
import com.atlassian.jira.web.filters.ThreadLocalQueryProfiler;
import com.atlassian.util.profiling.UtilTimerStack;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;

public class GroupedMethodProfiler {
    public static Object getProfiledObject(Object o) {
        Class<?>[] interfaces = o.getClass().getInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            return o;
        }
        TimerInvocationHandler timerHandler = new TimerInvocationHandler(o);
        return Proxy.newProxyInstance(o.getClass().getClassLoader(), GroupedMethodProfiler.getAllInterfaces(o), (InvocationHandler)timerHandler);
    }

    private static Class[] getAllInterfaces(Object o) {
        HashSet interfaces = new HashSet();
        for (Class<?> clazz = o.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            interfaces.addAll(Arrays.asList(clazz.getInterfaces()));
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object profiledInvoke(Method target, Object value, Object[] args) throws IllegalAccessException, InvocationTargetException {
        if (!UtilTimerStack.isActive()) {
            return target.invoke(value, args);
        }
        long start = System.currentTimeMillis();
        try {
            Object object = target.invoke(value, args);
            return object;
        }
        finally {
            ThreadLocalQueryProfiler.store(target.getDeclaringClass().getName(), target.getName(), System.currentTimeMillis() - start);
        }
    }

    public static String getTrimmedClassName(Method method) {
        String classname = method.getDeclaringClass().getName();
        return classname.substring(classname.lastIndexOf(46) + 1);
    }
}

