/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.concurrent;

import com.atlassian.jira.concurrent.Barrier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BarrierImpl
implements Barrier {
    private static final Logger log = LoggerFactory.getLogger(BarrierImpl.class);
    private final String name;
    private final Object lock = new Object();
    private boolean barrierUp = false;

    public BarrierImpl(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void await() {
        Object object = this.lock;
        synchronized (object) {
            while (this.barrierUp) {
                try {
                    log.debug("Barrier '{}' is up. Waiting for it to be lowered", (Object)this.name());
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            log.debug("Barrier '{}' is down", (Object)this.name());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void raise() {
        Object object = this.lock;
        synchronized (object) {
            log.debug("Raising barrier '{}'", (Object)this.name());
            this.barrierUp = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lower() {
        Object object = this.lock;
        synchronized (object) {
            log.debug("Lowering barrier '{}'", (Object)this.name());
            this.barrierUp = false;
            this.lock.notifyAll();
        }
    }
}

