/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dataimport;

import com.atlassian.activeobjects.spi.ActiveObjectsImportExportException;
import com.atlassian.activeobjects.spi.Backup;
import com.atlassian.activeobjects.spi.NullRestoreProgressMonitor;
import com.atlassian.core.util.FileSize;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.action.admin.OfbizImportHandler;
import com.atlassian.jira.bc.dataimport.DataImportFinishedEvent;
import com.atlassian.jira.bc.dataimport.DataImportParams;
import com.atlassian.jira.bc.dataimport.DataImportProductionDependencies;
import com.atlassian.jira.bc.dataimport.DataImportService;
import com.atlassian.jira.bc.dataimport.ImportCompletedEvent;
import com.atlassian.jira.bc.dataimport.ImportStartedEvent;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.license.JiraLicenseUpdaterService;
import com.atlassian.jira.bean.export.IllegalXMLCharactersException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.extension.JiraStartedEvent;
import com.atlassian.jira.license.LicenseStringFactory;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.task.ProgressMonitoringFileInputStream;
import com.atlassian.jira.task.StepTaskProgressSink;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.user.util.DirectorySynchroniserBarrier;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.ComponentFactory;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.XmlReader;
import com.atlassian.jira.util.ZipUtils;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.util.concurrent.BoundedExecutor;
import com.atlassian.jira.util.index.Contexts;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.util.xml.JiraFileInputStream;
import com.atlassian.jira.util.xml.XMLCleaningReader;
import com.atlassian.jira.web.action.setup.DevModeSecretSauce;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeManager;
import com.atlassian.scheduler.SchedulerUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelReader;
import org.ofbiz.core.entity.model.ModelViewEntity;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultDataImportService
implements DataImportService {
    private static final Logger log = Logger.getLogger(DefaultDataImportService.class);
    private final PermissionManager permissionManager;
    private final JiraHome jiraHome;
    private final JiraLicenseUpdaterService jiraLicenseService;
    private final I18nHelper.BeanFactory beanFactory;
    private final OfBizDelegator ofBizDelegator;
    private final LicenseStringFactory licenseStringFactory;
    private final IndexPathManager indexPathManager;
    private final AttachmentPathManager attachmentPathManager;
    private final ExternalLinkUtil externalLinkUtil;
    private final ApplicationProperties applicationProperties;
    private final BuildUtilsInfo buildUtilsInfo;
    private final TaskManager taskManager;
    private final MailQueue mailQueue;
    private final ComponentFactory factory;
    private final DataImportProductionDependencies dependencies;
    private final DevModeSecretSauce devModeSecretSauce;

    public DefaultDataImportService(DataImportProductionDependencies dependencies, PermissionManager permissionManager, JiraHome jiraHome, JiraLicenseUpdaterService jiraLicenseService, I18nHelper.BeanFactory beanFactory, OfBizDelegator ofBizDelegator, LicenseStringFactory licenseStringFactory, IndexPathManager indexPathManager, AttachmentPathManager attachmentPathManager, ExternalLinkUtil externalLinkUtil, ApplicationProperties applicationProperties, BuildUtilsInfo buildUtilsInfo, TaskManager taskManager, MailQueue mailQueue, ComponentFactory factory) {
        this.dependencies = dependencies;
        this.permissionManager = permissionManager;
        this.jiraHome = jiraHome;
        this.jiraLicenseService = jiraLicenseService;
        this.beanFactory = beanFactory;
        this.ofBizDelegator = ofBizDelegator;
        this.licenseStringFactory = licenseStringFactory;
        this.indexPathManager = indexPathManager;
        this.attachmentPathManager = attachmentPathManager;
        this.externalLinkUtil = externalLinkUtil;
        this.applicationProperties = applicationProperties;
        this.buildUtilsInfo = buildUtilsInfo;
        this.taskManager = taskManager;
        this.mailQueue = mailQueue;
        this.factory = factory;
        this.devModeSecretSauce = new DevModeSecretSauce();
    }

    @Override
    public DataImportService.ImportValidationResult validateImport(User loggedInUser, DataImportParams params) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18n = this.beanFactory.getInstance(loggedInUser);
        if (!params.isSetup() && !this.permissionManager.hasPermission(44, loggedInUser)) {
            errors.addErrorMessage(i18n.getText("admin.errors.import.permission"));
        }
        if (params.isSetup() && this.applicationProperties.getString("jira.setup") != null) {
            errors.addErrorMessage(i18n.getText("admin.errors.import.already.setup"));
        }
        if (params.getUnsafeJiraBackup() == null) {
            if (params.getFilename() == null) {
                errors.addErrorMessage(i18n.getText("admin.errors.must.enter.xml2"));
            } else {
                DefaultDataImportService.checkFile((ErrorCollection)errors, i18n, this.getSafeFile(params));
            }
        } else {
            DefaultDataImportService.checkFile((ErrorCollection)errors, i18n, params.getUnsafeJiraBackup());
        }
        if (params.getUnsafeAOBackup() != null) {
            DefaultDataImportService.checkFile((ErrorCollection)errors, i18n, params.getUnsafeAOBackup());
        }
        if (StringUtils.isNotBlank((String)params.getLicenseString())) {
            JiraLicenseService.ValidationResult validationResult = this.jiraLicenseService.validate(i18n, params.getLicenseString());
            errors.addErrorCollection(validationResult.getErrorCollection());
        }
        if (this.getAOBackup() == null) {
            errors.addErrorMessage(i18n.getText("data.import.error.no.ao"));
        }
        return new DataImportService.ImportValidationResult((ErrorCollection)errors, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataImportService.ImportResult doImport(User loggedInUser, DataImportService.ImportValidationResult result, TaskProgressSink taskProgressSink) {
        if (result == null) {
            throw new IllegalArgumentException("You cannot perform an import with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You cannot perform an import with an invalid validation result.");
        }
        I18nHelper i18n = this.beanFactory.getInstance(loggedInUser);
        log.info((Object)"Running JIRA Data Import...");
        DataImportService.ImportResult.Builder importResultBuilder = new DataImportService.ImportResult.Builder(result.getParams());
        BoundedExecutor pool = new BoundedExecutor(Executors.newFixedThreadPool(10), 10000);
        OfbizImportHandler ofbizImportHandler = new OfbizImportHandler(this.ofBizDelegator, pool, this.licenseStringFactory, this.indexPathManager, this.attachmentPathManager, result.getParams().isUseDefaultPaths());
        JiraLicenseService.ValidationResult licenseValidationResult = null;
        if (!Boolean.getBoolean("jira.dangermode")) {
            licenseValidationResult = this.parseXmlAndValidateBackupData(result.getParams(), importResultBuilder, i18n, ofbizImportHandler, taskProgressSink);
            if (!importResultBuilder.isValid()) {
                return importResultBuilder.build();
            }
        } else {
            log.warn((Object)"JIRA importing in DANGERMODE, skipping import validation, NOT FOR PRODUCTION USE");
        }
        this.broadcastEvent(new ImportStartedEvent());
        boolean success = false;
        try {
            this.shutdownAndFlushAsyncServices(result.getParams());
            success = this.performImport(result.getParams(), importResultBuilder, i18n, pool, ofbizImportHandler, licenseValidationResult, taskProgressSink);
            if (success && importResultBuilder.isValid()) {
                this.startAsyncServices();
            }
        }
        finally {
            this.broadcastEvent(new ImportCompletedEvent(success));
        }
        taskProgressSink.makeProgress(100L, i18n.getText("data.import.completed"), i18n.getText("data.import.completed.imported", (Object)ofbizImportHandler.getEntityCount()));
        log.info((Object)"JIRA Data Import has finished.");
        return importResultBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JiraLicenseService.ValidationResult parseXmlAndValidateBackupData(DataImportParams params, DataImportService.ImportResult.Builder importResult, I18nHelper i18n, OfbizImportHandler ofbizImportHandler, TaskProgressSink taskProgressSink) {
        ErrorCollection errors = importResult.getErrorCollection();
        File safeFileName = this.getJiraBackupFile(params);
        InputSource inputSource = this.getInputSource(safeFileName, errors, i18n, taskProgressSink);
        if (inputSource == null) {
            return null;
        }
        JiraLicenseService.ValidationResult licenseValidationResult = null;
        try {
            String attachmentPath;
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(false);
            saxParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            saxParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            log.info((Object)"Importing XML data...");
            ofbizImportHandler.setCreateEntities(false);
            log.info((Object)"Start parsing XML with SAX Parser.");
            saxParser.parse(inputSource, (DefaultHandler)ofbizImportHandler);
            log.info((Object)"XML successfully parsed.");
            String buildNumber = ofbizImportHandler.getBuildNumber();
            if (this.isXmlNewerThanThisVersion(buildNumber)) {
                errors.addErrorMessage(i18n.getText("data.import.error.xml.newer"));
            }
            if (buildNumber != null && !this.doesXmlMeetMinimumVersionRequirement(buildNumber)) {
                errors.addErrorMessage(i18n.getText("data.import.error.xml.too.old", this.externalLinkUtil.getProperty("external.link.jira.confluence.upgrade.guide.for.old.versions")));
                JiraLicenseService.ValidationResult validationResult = null;
                return validationResult;
            }
            String licenseString = StringUtils.isNotBlank((String)params.getLicenseString()) ? params.getLicenseString() : ofbizImportHandler.getLicenseString();
            licenseValidationResult = this.jiraLicenseService.validate(i18n, licenseString);
            if (licenseValidationResult.getLicenseVersion() == 1) {
                importResult.setSpecificError(DataImportService.ImportError.V1_LICENSE_EXCEPTION, licenseString);
            } else {
                errors.addErrors(licenseValidationResult.getErrorCollection().getErrors());
            }
            String indexPath = ofbizImportHandler.getIndexPath();
            if (indexPath != null) {
                File indexDir = new File(indexPath);
                if (!indexDir.exists()) {
                    errors.addErrorMessage(i18n.getText("setup.error.index.filepath", indexDir.getAbsolutePath()));
                    importResult.setSpecificError(DataImportService.ImportError.CUSTOM_PATH_EXCEPTION, "path not found");
                } else if (!indexDir.isDirectory() || !indexDir.canWrite()) {
                    errors.addErrorMessage(i18n.getText("setup.error.index.filepath.writeerror", indexDir.getAbsolutePath()));
                }
            }
            if ((attachmentPath = ofbizImportHandler.getAttachmentPath()) != null) {
                File attachmentDir = new File(attachmentPath);
                if (!attachmentDir.exists()) {
                    errors.addErrorMessage(i18n.getText("attachfile.error.invalid", attachmentDir.getAbsolutePath()));
                    importResult.setSpecificError(DataImportService.ImportError.CUSTOM_PATH_EXCEPTION, "path not found");
                } else if (!attachmentDir.isDirectory() || !attachmentDir.canWrite()) {
                    errors.addErrorMessage(i18n.getText("attachfile.error.writeerror", attachmentDir.getAbsolutePath()));
                }
            }
        }
        catch (SAXParseException e) {
            log.error((Object)("Error parsing export file: " + e), (Throwable)e);
            errors.addErrorMessage(i18n.getText("data.import.error.parsing.export.file", (Object)e));
        }
        catch (Exception e) {
            log.error((Object)("Error importing data: " + e), (Throwable)e);
            errors.addErrorMessage(i18n.getText("admin.errors.error.importing.data", (Object)e));
        }
        finally {
            this.closeInputSource(inputSource);
        }
        return licenseValidationResult;
    }

    private static boolean checkFile(ErrorCollection errors, I18nHelper i18n, File file) {
        if (!file.exists()) {
            errors.addError("filename", i18n.getText("admin.errors.could.not.find.file", file.getAbsolutePath()));
            return false;
        }
        if (!file.isFile()) {
            errors.addError("filename", i18n.getText("admin.errors.file.is.directory", file.getAbsolutePath()));
            return false;
        }
        if (!file.canRead()) {
            errors.addError("filename", i18n.getText("admin.errors.file.readable", file.getAbsolutePath()));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreActiveObjects(File safeFileName, I18nHelper i18n, ErrorCollection errors) {
        Backup activeObjectsBackup = this.getAOBackup();
        if (activeObjectsBackup == null) {
            log.error((Object)"Unable complete the restore: Cannot find ActiveObjects. Is the plugin enabled?");
            errors.addErrorMessage(i18n.getText("data.import.error.no.ao"));
            return;
        }
        InputStream inputStream = null;
        try {
            inputStream = ZipUtils.streamForZipFileEntry(safeFileName, "activeobjects.xml");
            if (inputStream == null) {
                log.info((Object)String.format("Unable to find ActiveObjects backup (%s) inside of zip file: %s", "activeobjects.xml", safeFileName));
            } else {
                activeObjectsBackup.restore(inputStream, NullRestoreProgressMonitor.INSTANCE);
            }
        }
        catch (ActiveObjectsImportExportException e) {
            log.error((Object)("Error during ActiveObjects restore: " + (Object)((Object)e)), (Throwable)e);
            errors.addErrorMessage(i18n.getText("admin.import.restore.activeobjects.exception", e.getPluginInformation().getPluginName()));
        }
        catch (IOException e) {
            log.error((Object)("Error attempting to import ActiveObjects backup: " + e), (Throwable)e);
            errors.addErrorMessage(i18n.getText("admin.errors.error.importing.data", (Object)e));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Unable to close zip stream during ActiveObjects restore", (Throwable)e);
                }
            }
        }
    }

    Backup getAOBackup() {
        return ComponentManager.getOSGiComponentInstanceOfType(Backup.class);
    }

    private void shutdownAndFlushAsyncServices(DataImportParams params) {
        Scheduler scheduler = this.dependencies.getScheduler();
        if (params.isQuickImport()) {
            this.pauseAndFlushScheduler(scheduler);
        } else {
            SchedulerUtil schedUtil = new SchedulerUtil();
            schedUtil.shutdownScheduler(scheduler);
        }
        this.cleanUpTaskManager(params);
        this.cleanUpCrowd();
        try {
            this.mailQueue.sendBuffer();
        }
        catch (Exception e) {
            log.warn((Object)("Sending buffer failed: " + e.getMessage()), (Throwable)e);
        }
    }

    private void cleanUpCrowd() {
        DirectorySynchroniserBarrier barrier = this.factory.createObject(DirectorySynchroniserBarrier.class);
        if (!barrier.await(20L, TimeUnit.SECONDS)) {
            log.error((Object)"Unable to stop remote directory synchronization.");
        }
    }

    private void cleanUpTaskManager(DataImportParams params) {
        if (params.isQuickImport()) {
            if (!this.taskManager.awaitUntilActiveTasksComplete(20L)) {
                log.error((Object)"There were still running tasks during the live import:");
                for (TaskDescriptor<?> descriptor : this.taskManager.getLiveTasks()) {
                    log.error((Object)(" -\t" + descriptor.getDescription()));
                }
            }
        } else {
            this.taskManager.shutdownAndWait(5L);
        }
    }

    private void pauseAndFlushScheduler(Scheduler scheduler) {
        try {
            String[] jobGroupNames;
            scheduler.standby();
            for (String groupName : jobGroupNames = scheduler.getJobGroupNames()) {
                String[] jobNames;
                for (String jobName : jobNames = scheduler.getJobNames(groupName)) {
                    scheduler.deleteJob(jobName, groupName);
                }
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performImport(DataImportParams params, DataImportService.ImportResult.Builder importResult, I18nHelper i18n, BoundedExecutor pool, OfbizImportHandler ofbizImportHandler, JiraLicenseService.ValidationResult licenseValidationResult, TaskProgressSink taskProgressSink) {
        InputSource inputSource = null;
        ErrorCollection errors = importResult.getErrorCollection();
        try {
            if (!this.removeActiveObjects(i18n, errors)) {
                boolean bl = false;
                return bl;
            }
            this.removeAllEntities();
            long entityCount = ofbizImportHandler.getEntityCount();
            if (log.isInfoEnabled()) {
                log.info((Object)("Started storing " + entityCount + " Generic Values."));
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            SAXParser saxParser = factory.newSAXParser();
            ofbizImportHandler.setTaskProgressSink(new I18nTaskProgressSink(new StepTaskProgressSink(20L, 90L, entityCount, taskProgressSink), i18n, entityCount));
            if (!this.restoreData(importResult, i18n, pool, ofbizImportHandler, saxParser, params, errors)) {
                boolean bl = false;
                return bl;
            }
            log.info((Object)"Finished storing Generic Values.");
            File aoBackupFile = this.getAOBackupFile(params);
            if ("zip".equalsIgnoreCase(FilenameUtils.getExtension((String)aoBackupFile.getAbsolutePath()))) {
                this.restoreActiveObjects(aoBackupFile, i18n, errors);
                if (errors.hasAnyErrors()) {
                    boolean bl = false;
                    return bl;
                }
            }
            this.restartJira(params, licenseValidationResult);
            this.checkConsistency(i18n, taskProgressSink);
            Collection<String> upgradeErrors = this.upgradeJira(i18n, taskProgressSink);
            if (!upgradeErrors.isEmpty()) {
                this.setErrorMessage(importResult, upgradeErrors);
            } else {
                this.updateLookAndFeel();
            }
            this.dependencies.getPluginEventManager().broadcast((Object)new DataImportFinishedEvent());
            this.reindex();
            this.upgradePlugins(params);
            this.applyMailSettingsAccordingTo(params);
            boolean bl = true;
            return bl;
        }
        catch (SAXParseException e) {
            log.error((Object)("Error parsing export file: " + e), (Throwable)e);
            errors.addErrorMessage(i18n.getText("data.import.error.parsing.export.file", (Object)e));
        }
        catch (Exception e) {
            log.error((Object)("Error importing data: " + e), (Throwable)e);
            errors.addErrorMessage(i18n.getText("admin.errors.error.importing.data", (Object)e));
        }
        finally {
            pool.shutdownAndWait();
            this.closeInputSource(inputSource);
        }
        return false;
    }

    private void applyMailSettingsAccordingTo(DataImportParams params) {
        if (params.shouldChangeOutgoingMail()) {
            if (params.outgoingMail()) {
                this.dependencies.getMailSettings().send().enable();
            } else {
                this.dependencies.getMailSettings().send().disable();
            }
        }
    }

    private void upgradePlugins(DataImportParams params) {
        PluginUpgradeManager upgradeManager;
        List upgrade;
        if (params.isQuickImport() && (upgrade = (upgradeManager = this.dependencies.getPluginUpgradeManager()).upgrade()) != null && !upgrade.isEmpty()) {
            I18nHelper instance = this.beanFactory.getInstance(Locale.ENGLISH);
            log.error((Object)"Upgrade of plugins failed:");
            for (Message message : upgrade) {
                log.error((Object)("\t" + instance.getText(message.getKey(), (Object)message.getArguments())));
            }
        }
        this.dependencies.getPluginEventManager().broadcast((Object)new JiraStartedEvent());
    }

    private void updateLookAndFeel() {
        LookAndFeelBean lookAndFeelBean = LookAndFeelBean.getInstance((ApplicationProperties)this.applicationProperties);
        long oldLookAndFeelversion = lookAndFeelBean.getVersion();
        lookAndFeelBean.updateVersion(oldLookAndFeelversion);
    }

    private void setErrorMessage(DataImportService.ImportResult.Builder importResult, Collection<String> upgradeErrors) {
        StringBuilder errorString = new StringBuilder();
        for (String upgradeError : upgradeErrors) {
            errorString.append(upgradeError).append("\n");
        }
        importResult.setSpecificError(DataImportService.ImportError.UPGRADE_EXCEPTION, errorString.toString());
    }

    private Collection<String> upgradeJira(I18nHelper i18n, TaskProgressSink taskProgressSink) throws IllegalXMLCharactersException {
        Collection<String> upgradeErrors = this.dependencies.getUpgradeManager().doUpgradeIfNeededAndAllowed(null);
        taskProgressSink.makeProgress(96L, i18n.getText("data.import.indexing"), i18n.getText("data.import.indexing.progress"));
        return upgradeErrors;
    }

    private void checkConsistency(I18nHelper i18n, TaskProgressSink taskProgressSink) throws Exception {
        this.dependencies.getConsistencyChecker().checkDataConsistency();
        taskProgressSink.makeProgress(92L, i18n.getText("data.import.upgrade"), i18n.getText("data.import.upgrade.progress"));
    }

    private void restartJira(DataImportParams params, JiraLicenseService.ValidationResult licenseValidationResult) throws Exception {
        this.dependencies.refreshSequencer();
        if (StringUtils.isNotBlank((String)params.getLicenseString()) && licenseValidationResult != null) {
            this.jiraLicenseService.setLicenseNoEvent(licenseValidationResult);
        }
        this.globalRefresh(params.isQuickImport());
    }

    private boolean restoreData(DataImportService.ImportResult.Builder importResult, I18nHelper i18n, BoundedExecutor pool, OfbizImportHandler ofbizImportHandler, SAXParser saxParser, DataImportParams params, ErrorCollection errors) throws SAXException, IOException {
        InputSource inputSource = this.getInputSource(this.getSafeFile(params), errors, i18n, TaskProgressSink.NULL_SINK);
        ofbizImportHandler.setCreateEntities(true);
        saxParser.parse(inputSource, (DefaultHandler)ofbizImportHandler);
        pool.shutdownAndWait();
        if (ofbizImportHandler.getImportError() != null) {
            importResult.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.unknown.error.during.import", ofbizImportHandler.getImportError().getMessage()));
            return false;
        }
        return true;
    }

    private void startAsyncServices() {
        SchedulerUtil schedUtil = new SchedulerUtil();
        schedUtil.initializeAndStart(this.dependencies.getScheduler());
    }

    private void closeInputSource(InputSource is) {
        if (is != null) {
            IOUtils.closeQuietly((InputStream)is.getByteStream());
            IOUtils.closeQuietly((Reader)is.getCharacterStream());
        }
    }

    private void globalRefresh(boolean quickImport) throws Exception {
        try {
            this.dependencies.globalRefresh(quickImport);
        }
        catch (RuntimeException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private boolean isXmlNewerThanThisVersion(String xmlBuildNumber) {
        try {
            int currentBuildNumber = Integer.parseInt(this.buildUtilsInfo.getCurrentBuildNumber());
            return Integer.parseInt(xmlBuildNumber) > currentBuildNumber;
        }
        catch (NumberFormatException nfe) {
            log.warn((Object)("Could not parse the build number from XML import data. The build number was <" + xmlBuildNumber + ">"));
            return false;
        }
    }

    private boolean doesXmlMeetMinimumVersionRequirement(String xmlBuildNumber) {
        try {
            int minimumVersionBuildNumber = Integer.parseInt(this.buildUtilsInfo.getMinimumUpgradableBuildNumber());
            return Integer.parseInt(xmlBuildNumber) >= minimumVersionBuildNumber;
        }
        catch (NumberFormatException nfe) {
            log.warn((Object)"problems parsing build number", (Throwable)nfe);
            return false;
        }
    }

    private InputSource getInputSource(File file, ErrorCollection errors, I18nHelper i18n, TaskProgressSink taskProgressSink) {
        ProgressMonitoringFileInputStream inputStream;
        try {
            JiraFileInputStream stream = new JiraFileInputStream(file);
            inputStream = new ProgressMonitoringFileInputStream(stream, new StepTaskProgressSink(0L, 20L, stream.getSize(), taskProgressSink), i18n.getText("data.import.parse.xml"), i18n.getText("data.import.parse.progress", "{0}", FileSize.format((long)stream.getSize())));
        }
        catch (FileNotFoundException e) {
            errors.addErrorMessage(i18n.getText("data.import.could.not.find.file.at", file.getAbsolutePath()));
            return null;
        }
        catch (IOException e) {
            log.error((Object)("Error importing from zip file: \"" + file.getAbsolutePath() + "\""), (Throwable)e);
            errors.addErrorMessage(i18n.getText("data.import.error.importing.from.zip", "\"" + file.getAbsolutePath() + "\"", e.getMessage()));
            return null;
        }
        if (this.applicationProperties.getOption("jira.exportimport.cleanxml")) {
            Reader reader = this.getFilteredReader(inputStream);
            return new InputSource(reader);
        }
        return new InputSource(inputStream);
    }

    private void reindex() throws Exception {
        IndexLifecycleManager indexManager = this.dependencies.getIndexLifecycleManager();
        indexManager.deactivate();
        indexManager.activate(Contexts.percentageLogger((Sized)indexManager, (Logger)log));
    }

    private boolean removeActiveObjects(I18nHelper i18n, ErrorCollection errors) {
        Backup aoBackup = this.getAOBackup();
        if (aoBackup == null) {
            log.error((Object)"Unable to delete ActiveObjects tables. Is the ActiveObjects plugin enabled?");
            errors.addErrorMessage(i18n.getText("data.import.error.no.ao"));
            return false;
        }
        aoBackup.clear();
        return true;
    }

    private void removeAllEntities() throws GenericEntityException {
        log.info((Object)"Removing all entries from the database.");
        ModelReader reader = this.ofBizDelegator.getModelReader();
        Collection ec = reader.getEntityNames();
        TreeSet entityNames = new TreeSet(ec);
        for (String entityName : entityNames) {
            ModelEntity modelEntity = reader.getModelEntity(entityName);
            if (modelEntity != null) {
                if (!(modelEntity instanceof ModelViewEntity)) {
                    this.ofBizDelegator.removeByAnd(entityName, Collections.emptyMap());
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No need to remove records from View entity '" + entityName + "'"));
                continue;
            }
            log.warn((Object)("Nothing known about entity '" + entityName + "' - cannot delete."));
        }
        log.info((Object)"All entries removed.");
    }

    private Reader getFilteredReader(InputStream is) {
        try {
            XmlReader reader = XmlReader.createReader(is);
            if (reader instanceof XmlReader) {
                XmlReader xmlReader = reader;
                return new XMLCleaningReader(new InputStreamReader(xmlReader.getInputStream(), xmlReader.getEncoding()));
            }
            String message = "Expected XMLReader but got '" + reader.getClass().getName() + ". Cannot determine the encoding of the XML file.";
            log.error((Object)message);
            throw new InvalidSourceException(message);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e, (Throwable)e);
            throw new InvalidSourceException("Unsupported encoding.", e);
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            throw new InvalidSourceException("IO error has occurred.", e);
        }
    }

    private File getSafeFile(DataImportParams params) {
        File file = new File(params.getFilename());
        if ((params.isSetup() || this.hasSecretSauce(file)) && file.exists()) {
            return file;
        }
        return new File(this.jiraHome.getImportDirectory().getAbsolutePath(), file.getName());
    }

    File getJiraBackupFile(DataImportParams params) {
        if (params.getUnsafeJiraBackup() != null) {
            return params.getUnsafeJiraBackup();
        }
        return this.getSafeFile(params);
    }

    File getAOBackupFile(DataImportParams params) {
        if (params.getUnsafeAOBackup() != null) {
            return params.getUnsafeAOBackup();
        }
        return this.getJiraBackupFile(params);
    }

    @VisibleForTesting
    EventPublisher getEventPublisher() {
        return (EventPublisher)ComponentAccessor.getComponent(EventPublisher.class);
    }

    private boolean hasSecretSauce(File file) {
        return this.devModeSecretSauce.isBoneFideJiraDeveloper() && file.getParentFile() != null;
    }

    private void broadcastEvent(Object event) {
        EventPublisher publisher = this.getEventPublisher();
        if (publisher == null) {
            log.error((Object)("Could not broadcast event due missing EventPublisher: " + event));
            return;
        }
        publisher.publish(event);
    }

    static class I18nTaskProgressSink
    implements TaskProgressSink {
        private final TaskProgressSink delegate;
        private final I18nHelper i18n;
        private final long totalSize;

        I18nTaskProgressSink(TaskProgressSink delegate, I18nHelper i18n, long totalSize) {
            this.delegate = delegate;
            this.i18n = i18n;
            this.totalSize = totalSize;
        }

        public void makeProgress(long taskProgress, String currentSubTask, String message) {
            this.delegate.makeProgress(taskProgress, this.i18n.getText(currentSubTask), this.i18n.getText(message, Long.toString(taskProgress), Long.toString(this.totalSize)));
        }
    }

    class InvalidSourceException
    extends RuntimeException {
        public InvalidSourceException(String s) {
            super(s);
        }

        public InvalidSourceException(String s, Throwable throwable) {
            super(s, throwable);
        }
    }
}

