/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.event.DraftWorkflowCreatedEvent;
import com.atlassian.jira.event.DraftWorkflowDeletedEvent;
import com.atlassian.jira.event.DraftWorkflowPublishedEvent;
import com.atlassian.jira.event.WorkflowCopiedEvent;
import com.atlassian.jira.event.WorkflowCreatedEvent;
import com.atlassian.jira.event.WorkflowDeletedEvent;
import com.atlassian.jira.event.WorkflowUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.Txn;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ImportUtils;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Null;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.workflow.ConfigurableJiraWorkflow;
import com.atlassian.jira.workflow.DefaultJiraWorkflow;
import com.atlassian.jira.workflow.DraftWorkflowStore;
import com.atlassian.jira.workflow.JiraDraftWorkflow;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowProgressAware;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.jira.workflow.WorkflowsRepository;
import com.atlassian.jira.workflow.names.WorkflowCopyNameFactory;
import com.google.common.collect.Iterables;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.InvalidEntryStateException;
import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.InvalidRoleException;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.WorkflowContext;
import com.opensymphony.workflow.basic.BasicWorkflow;
import com.opensymphony.workflow.config.Configuration;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.spi.SimpleStep;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.WorkflowStore;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;
import webwork.action.ActionContext;

public class OSWorkflowManager
implements WorkflowManager {
    private static final Logger log = Logger.getLogger(OSWorkflowManager.class);
    private volatile Configuration configuration;
    private final DraftWorkflowStore draftWorkflowStore;
    private final EventPublisher eventPublisher;
    private WorkflowsRepository workflowsRepository;
    private WorkflowCopyNameFactory workflowCopyNameFactory;
    private final JiraAuthenticationContext context;

    public OSWorkflowManager(Configuration configuration, DraftWorkflowStore draftWorkflowStore, EventPublisher eventPublisher, WorkflowsRepository workflowsRepository, WorkflowCopyNameFactory workflowCopyNameFactory, JiraAuthenticationContext context) {
        this.workflowsRepository = workflowsRepository;
        this.workflowCopyNameFactory = workflowCopyNameFactory;
        this.context = context;
        this.setConfiguration(configuration);
        this.draftWorkflowStore = draftWorkflowStore;
        this.eventPublisher = eventPublisher;
    }

    public Collection<JiraWorkflow> getWorkflows() {
        ArrayList<JiraWorkflow> workflows = new ArrayList<JiraWorkflow>();
        try {
            String[] workflowNames;
            for (String workflowName : workflowNames = this.getConfiguration().getWorkflowNames()) {
                workflows.add(this.getWorkflow(workflowName));
            }
        }
        catch (FactoryException e) {
            log.error((Object)("Could not get workflow names: " + (Object)((Object)e)), (Throwable)e);
        }
        Collections.sort(workflows);
        return workflows;
    }

    public List<JiraWorkflow> getWorkflowsIncludingDrafts() {
        ArrayList<JiraWorkflow> ret = new ArrayList<JiraWorkflow>();
        for (JiraWorkflow jiraWorkflow : this.getWorkflows()) {
            ret.add(jiraWorkflow);
            JiraWorkflow draftWorkflow = this.getDraftWorkflow(jiraWorkflow.getName());
            if (draftWorkflow == null) continue;
            ret.add(draftWorkflow);
        }
        return ret;
    }

    protected String getWorkflowName(Long projectId, String issueType) {
        Project project = this.getProjectManager().getProjectObj(projectId);
        return this.getWorkflowSchemeManager().getWorkflowName(project, issueType);
    }

    private ProjectManager getProjectManager() {
        return ComponentAccessor.getProjectManager();
    }

    public Collection<JiraWorkflow> getActiveWorkflows() throws WorkflowException {
        return this.getSchemeActiveWorkflows();
    }

    public boolean isActive(JiraWorkflow workflow) throws WorkflowException {
        return this.getSchemeActiveWorkflows().contains(workflow);
    }

    public boolean isSystemWorkflow(JiraWorkflow workflow) {
        return !this.getConfiguration().isModifiable(workflow.getName());
    }

    private Collection<JiraWorkflow> getSchemeActiveWorkflows() throws WorkflowException {
        try {
            Collection names = this.getWorkflowSchemeManager().getActiveWorkflowNames();
            HashSet<JiraWorkflow> workflows = new HashSet<JiraWorkflow>();
            for (String name : names) {
                workflows.add(this.getWorkflow(name));
            }
            return workflows;
        }
        catch (GenericEntityException e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public JiraWorkflow getWorkflow(String name) {
        try {
            WorkflowDescriptor workflowDescriptor = this.getConfiguration().getWorkflow(name);
            if ("jira".equals(name)) {
                return new DefaultJiraWorkflow(workflowDescriptor, this, this.context);
            }
            return new ConfigurableJiraWorkflow(name, workflowDescriptor, this);
        }
        catch (FactoryException e) {
            log.debug((Object)("Could not get workflow called: " + name + ": " + (Object)((Object)e)), (Throwable)e);
            return null;
        }
    }

    public JiraWorkflow getWorkflowClone(String name) {
        try {
            WorkflowDescriptor workflowDescriptor = this.getConfiguration().getWorkflow(name);
            if ("jira".equals(name)) {
                return new DefaultJiraWorkflow(workflowDescriptor, this, this.context);
            }
            WorkflowDescriptor mutableDescriptor = this.cloneDescriptor(workflowDescriptor);
            return new ConfigurableJiraWorkflow(name, mutableDescriptor, this);
        }
        catch (FactoryException e) {
            log.error((Object)("Could not get workflow called: " + name + ": " + (Object)((Object)e)), (Throwable)e);
            return null;
        }
    }

    WorkflowDescriptor cloneDescriptor(WorkflowDescriptor workflowDescriptor) throws FactoryException {
        return WorkflowUtil.convertXMLtoWorkflowDescriptor((String)WorkflowUtil.convertDescriptorToXML((WorkflowDescriptor)workflowDescriptor));
    }

    public JiraWorkflow getDraftWorkflow(String parentWorkflowName) throws IllegalArgumentException {
        JiraWorkflow parentWorkflow = this.getWorkflow(parentWorkflowName);
        if (parentWorkflow == null) {
            throw new IllegalArgumentException("Draft workflow could not be retrieved, since the parent workflow with name '" + parentWorkflowName + "' does not exist.");
        }
        return this.draftWorkflowStore.getDraftWorkflow(parentWorkflowName);
    }

    public JiraWorkflow createDraftWorkflow(String username, String parentWorkflowName) {
        if (username == null) {
            throw new IllegalArgumentException("You can not create a draft workflow with a null username.");
        }
        JiraWorkflow parentWorkflow = this.getWorkflow(parentWorkflowName);
        if (parentWorkflow == null) {
            throw new IllegalArgumentException("You can not create a draft workflow from a parent that does not exist.");
        }
        if (!parentWorkflow.isActive()) {
            throw new IllegalStateException("You can not create a draft workflow from a parent workflow that is not active.");
        }
        JiraWorkflow draftWorkflow = this.draftWorkflowStore.createDraftWorkflow(username, parentWorkflow);
        this.eventPublisher.publish((Object)new DraftWorkflowCreatedEvent(draftWorkflow));
        return draftWorkflow;
    }

    public boolean deleteDraftWorkflow(String parentWorkflowName) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)parentWorkflowName)) {
            throw new IllegalArgumentException("Can not delete a draft workflow for a parent workflow name of null.");
        }
        JiraWorkflow draftWorkflow = this.getDraftWorkflow(parentWorkflowName);
        boolean deleted = this.draftWorkflowStore.deleteDraftWorkflow(parentWorkflowName);
        if (deleted) {
            this.eventPublisher.publish((Object)new DraftWorkflowDeletedEvent(draftWorkflow));
        }
        return deleted;
    }

    public boolean workflowExists(String name) throws WorkflowException {
        return this.workflowsRepository.contains(name);
    }

    public JiraWorkflow getWorkflow(Issue issue) throws WorkflowException {
        GenericValue project = issue.getProject();
        if (project == null) {
            throw new IllegalArgumentException("Project for issue with id '" + issue.getId() + "' is null.");
        }
        IssueType issueType = issue.getIssueTypeObject();
        if (issueType == null) {
            throw new IllegalArgumentException("Issue Type for issue with id '" + issue.getId() + "' is null.");
        }
        return this.getWorkflow(project.getLong("id"), issueType.getId());
    }

    public JiraWorkflow getWorkflow(Long projectId, String issueTypeId) throws WorkflowException {
        return this.getWorkflow(this.getWorkflowName(projectId, issueTypeId));
    }

    public JiraWorkflow getWorkflowFromScheme(GenericValue scheme, String issueTypeId) {
        return this.getWorkflow(this.getWorkflowSchemeManager().getWorkflowName(scheme, issueTypeId));
    }

    public JiraWorkflow getWorkflowFromScheme(WorkflowScheme scheme, String issueTypeId) {
        return this.getWorkflow(scheme.getActualWorkflow(issueTypeId));
    }

    public Collection<JiraWorkflow> getWorkflowsFromScheme(GenericValue scheme) throws WorkflowException {
        if (scheme != null) {
            try {
                List schemeEntities = this.getWorkflowSchemeManager().getEntities(scheme);
                if (schemeEntities != null) {
                    ArrayList<JiraWorkflow> result = new ArrayList<JiraWorkflow>(schemeEntities.size());
                    for (GenericValue schemeEntity : schemeEntities) {
                        result.add(this.getWorkflow(schemeEntity.getString("workflow")));
                    }
                    return result;
                }
            }
            catch (GenericEntityException e) {
                throw new WorkflowException((Throwable)e);
            }
        }
        return CollectionBuilder.newBuilder((Object[])new JiraWorkflow[]{this.getWorkflow("jira")}).asMutableList();
    }

    public Iterable<JiraWorkflow> getWorkflowsFromScheme(Scheme workflowScheme) throws WorkflowException {
        try {
            if (workflowScheme == null) {
                return this.getWorkflowsFromScheme((GenericValue)null);
            }
            return this.getWorkflowsFromScheme(this.getWorkflowSchemeManager().getScheme(workflowScheme.getId()));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public void copyAndDeleteDraftWorkflows(User user, Set<JiraWorkflow> workflows) {
        this.copyAndDeleteDraftsForInactiveWorkflowsIn(user, workflows);
    }

    public void copyAndDeleteDraftsForInactiveWorkflowsIn(User user, Iterable<JiraWorkflow> workflows) {
        if (workflows == null || Iterables.isEmpty(workflows)) {
            return;
        }
        for (JiraWorkflow workflow : workflows) {
            String parentWorkflowName = workflow.getName();
            JiraWorkflow draftWorkflow = this.getDraftWorkflow(parentWorkflowName);
            if (workflow.isActive() || draftWorkflow == null) continue;
            String username = user == null ? null : user.getName();
            this.copyWorkflow(username, this.getClonedWorkflowName(parentWorkflowName, user), draftWorkflow.getDescription() + " " + this.getI18nBean(user).getText("admin.workflows.manager.draft.auto.generated", parentWorkflowName), draftWorkflow);
            this.deleteDraftWorkflow(parentWorkflowName);
        }
    }

    private void createActualWorkflow(String username, JiraWorkflow workflow) throws WorkflowException {
        this.addAuditInfo(username, workflow);
        this.saveWorkflowWithoutAudit(workflow);
    }

    public void createWorkflow(String username, JiraWorkflow workflow) throws WorkflowException {
        this.createActualWorkflow(username, workflow);
        this.eventPublisher.publish((Object)new WorkflowCreatedEvent(workflow));
    }

    public void createWorkflow(User creator, JiraWorkflow workflow) throws WorkflowException {
        String username = null;
        if (creator != null) {
            username = creator.getName();
        }
        this.createWorkflow(username, workflow);
    }

    private void addAuditInfo(String userName, JiraWorkflow workflow) {
        if (workflow == null) {
            return;
        }
        WorkflowDescriptor descriptor = workflow.getDescriptor();
        log.info((Object)("User '" + userName + "' updated workflow '" + workflow.getName() + "' at '" + new Date() + "'"));
        if (userName != null) {
            descriptor.getMetaAttributes().put("jira.update.author.name", userName);
        } else {
            descriptor.getMetaAttributes().put("jira.update.author.name", "");
        }
        descriptor.getMetaAttributes().put("jira.updated.date", Long.toString(System.currentTimeMillis()));
    }

    public void saveWorkflowWithoutAudit(JiraWorkflow workflow) throws WorkflowException {
        if (workflow.isDraftWorkflow()) {
            this.draftWorkflowStore.updateDraftWorkflowWithoutAudit(workflow.getName(), workflow);
        }
        try {
            this.getConfiguration().saveWorkflow(workflow.getName(), workflow.getDescriptor(), true);
            workflow.reset();
        }
        catch (FactoryException e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    protected WorkflowSchemeManager getWorkflowSchemeManager() {
        return ComponentAccessor.getWorkflowSchemeManager();
    }

    public void deleteWorkflow(JiraWorkflow workflow) throws WorkflowException {
        if (!Iterables.isEmpty((Iterable)this.getWorkflowSchemeManager().getSchemesForWorkflowIncludingDrafts(workflow))) {
            throw new WorkflowException("The workflow is assigned to workflow schemes");
        }
        try {
            this.deleteDraftWorkflow(workflow.getName());
            this.getConfiguration().removeWorkflow(workflow.getName());
            this.eventPublisher.publish((Object)new WorkflowDeletedEvent(workflow));
        }
        catch (FactoryException e) {
            throw new WorkflowException("Error deleting workflow: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public JiraWorkflow getWorkflow(GenericValue issue) throws WorkflowException {
        String workflowName = this.getWorkflowName(issue.getLong("project"), issue.getString("type"));
        return this.getWorkflow(workflowName);
    }

    public void migrateIssueToWorkflow(GenericValue issue, JiraWorkflow newWorkflow, GenericValue newStatus) throws WorkflowException {
        if (this.migrateIssueToWorkflowNoReindex(issue, newWorkflow, newStatus)) {
            try {
                this.getIssueIndexManager().reIndex(issue);
            }
            catch (IndexException e) {
                log.error((Object)("Error indexing issue during workflow migration: " + (Object)((Object)e)), (Throwable)e);
            }
        }
    }

    public boolean migrateIssueToWorkflowNoReindex(GenericValue issue, JiraWorkflow newWorkflow, GenericValue newStatus) throws WorkflowException {
        try {
            WorkflowStore store = this.getStore();
            long wfid = issue.getLong("workflowId");
            List currentSteps = store.findCurrentSteps(wfid);
            SimpleStep currentStep = null;
            if (!currentSteps.isEmpty()) {
                currentStep = (SimpleStep)currentSteps.get(0);
            }
            WorkflowEntry newEntry = store.createEntry(newWorkflow.getName());
            store.setEntryState(newEntry.getId(), 1);
            store.setEntryState(wfid, 3);
            StepDescriptor stepInNewWorkflow = newWorkflow.getLinkedStep(newStatus);
            if (stepInNewWorkflow == null) {
                throw new RuntimeException("No step associated with status " + (newStatus == null ? "null" : newStatus.getString("name")) + " in new workflow " + newWorkflow.getName());
            }
            if (currentStep != null) {
                store.createCurrentStep(newEntry.getId(), stepInNewWorkflow.getId(), currentStep.getOwner(), currentStep.getStartDate(), currentStep.getDueDate(), currentStep.getStatus(), null);
                store.moveToHistory((Step)currentStep);
            } else {
                Timestamp startDate = issue.getTimestamp("created");
                store.createCurrentStep(newEntry.getId(), stepInNewWorkflow.getId(), null, (Date)startDate, null, newStatus.getString("id"), null);
            }
            boolean result = this.updateIssueStatusAndUpdatedDate(issue, newStatus);
            issue.set("workflowId", (Object)newEntry.getId());
            issue.store();
            return result;
        }
        catch (StoreException e) {
            throw new WorkflowException((Throwable)e);
        }
        catch (GenericEntityException e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public void overwriteActiveWorkflow(String username, String workflowName) {
        boolean saved;
        JiraWorkflow draftWorkflow = this.draftWorkflowStore.getDraftWorkflow(workflowName);
        if (draftWorkflow == null) {
            throw new WorkflowException("No draft workflow named '" + workflowName + "'");
        }
        try {
            this.addAuditInfo(username, draftWorkflow);
            saved = this.getConfiguration().saveWorkflow(workflowName, draftWorkflow.getDescriptor(), true);
            this.eventPublisher.publish((Object)new DraftWorkflowPublishedEvent(draftWorkflow));
        }
        catch (FactoryException e) {
            throw new WorkflowException((Throwable)e);
        }
        if (!saved) {
            throw new WorkflowException("Workflow '" + workflowName + "' could not be overwritten!");
        }
        this.draftWorkflowStore.deleteDraftWorkflow(workflowName);
    }

    protected boolean updateIssueStatusAndUpdatedDate(GenericValue issue, GenericValue newStatus) {
        if (!issue.getString("status").equals(newStatus.getString("id"))) {
            issue.set("updated", (Object)UtilDateTime.nowTimestamp());
            issue.set("status", (Object)newStatus.getString("id"));
            return true;
        }
        return false;
    }

    public void updateWorkflow(String username, JiraWorkflow workflow) {
        if (username == null) {
            throw new IllegalArgumentException("Can not update a workflow with a null username.");
        }
        if (workflow == null || workflow.getDescriptor() == null) {
            throw new IllegalArgumentException("Can not update a workflow with a null workflow/descriptor.");
        }
        if (workflow.isDraftWorkflow()) {
            String workflowName = workflow.getName();
            JiraWorkflow parentWorkflow = this.getWorkflow(workflowName);
            if (parentWorkflow == null) {
                throw new IllegalStateException("You can not update a draft workflow for a parent that does not exist.");
            }
            this.draftWorkflowStore.updateDraftWorkflow(username, workflowName, workflow);
        } else {
            if (workflow.isActive()) {
                throw new WorkflowException("Cannot save an active workflow.");
            }
            if (workflow.isSystemWorkflow()) {
                throw new WorkflowException("Cannot change the system workflow.");
            }
            this.createActualWorkflow(username, workflow);
        }
        this.eventPublisher.publish((Object)new WorkflowUpdatedEvent(workflow));
    }

    public JiraWorkflow copyWorkflow(String username, String clonedWorkflowName, String clonedWorkflowDescription, JiraWorkflow workflowToClone) {
        WorkflowDescriptor workflowDescriptor;
        try {
            workflowDescriptor = this.cloneDescriptor(workflowToClone.getDescriptor());
        }
        catch (FactoryException e) {
            throw new WorkflowException("Unexpected exception copying a workflowDescriptor for workflow '" + clonedWorkflowName + "'!", (Throwable)e);
        }
        ConfigurableJiraWorkflow newWorkflow = new ConfigurableJiraWorkflow(clonedWorkflowName, workflowDescriptor, this);
        if (StringUtils.isNotEmpty((String)clonedWorkflowDescription)) {
            newWorkflow.setDescription(clonedWorkflowDescription);
        } else {
            newWorkflow.setDescription("");
        }
        this.createActualWorkflow(username, newWorkflow);
        this.eventPublisher.publish((Object)new WorkflowCopiedEvent(workflowToClone, (JiraWorkflow)newWorkflow));
        return newWorkflow;
    }

    public void updateWorkflowNameAndDescription(String username, JiraWorkflow currentWorkflow, String newName, String newDescription) {
        Null.not("currentWorkflow", currentWorkflow);
        String currentWorkflowName = currentWorkflow.getName();
        JiraWorkflow workflow = currentWorkflow;
        if (!currentWorkflow.isDraftWorkflow()) {
            workflow = this.getWorkflowClone(currentWorkflowName);
        }
        if (newDescription != null && !newDescription.equals(workflow.getDescription())) {
            WorkflowDescriptor descriptor = workflow.getDescriptor();
            descriptor.getMetaAttributes().put("jira.description", newDescription);
            this.updateWorkflow(username, workflow);
        }
        if (!currentWorkflowName.equals(newName) && !currentWorkflow.isDraftWorkflow()) {
            try {
                this.getConfiguration().removeWorkflow(currentWorkflowName);
                this.getConfiguration().saveWorkflow(newName, workflow.getDescriptor(), true);
                this.getWorkflowSchemeManager().updateSchemesForRenamedWorkflow(currentWorkflowName, newName);
                JiraWorkflow draftWorkflow = this.draftWorkflowStore.getDraftWorkflow(currentWorkflowName);
                if (draftWorkflow != null) {
                    log.warn((Object)("Inactive workflow '" + newName + "' has a draft workflow. Please remove this draft!"));
                    JiraDraftWorkflow newWorkflow = new JiraDraftWorkflow(newName, this, draftWorkflow.getDescriptor());
                    this.draftWorkflowStore.createDraftWorkflow(username, newWorkflow);
                    this.draftWorkflowStore.deleteDraftWorkflow(currentWorkflowName);
                }
            }
            catch (FactoryException e) {
                throw new WorkflowException("Error renaming workflow '" + currentWorkflow + "' to '" + newName + "' " + (Object)((Object)e), (Throwable)e);
            }
        }
    }

    I18nHelper getI18nBean(User user) {
        return new I18nBean(user);
    }

    String getClonedWorkflowName(String parentWorkflowName, User user) {
        return this.workflowCopyNameFactory.createFrom(parentWorkflowName, this.getI18nBean(user).getLocale());
    }

    void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public JiraWorkflow getDefaultWorkflow() throws WorkflowException {
        return this.getWorkflow("jira");
    }

    public GenericValue createIssue(String remoteUserName, Map<String, Object> fields) throws WorkflowException {
        try {
            Issue issue = (Issue)fields.get("issue");
            Long projectId = issue.getProjectObject().getId();
            String issueTypeId = issue.getIssueTypeObject().getId();
            JiraWorkflow jiraWorkflow = this.getWorkflow(projectId, issueTypeId);
            if (jiraWorkflow == null) {
                throw new IllegalArgumentException("Cannot find workflow for project with id '" + projectId + "' and issue type with id '" + issueTypeId + "'.");
            }
            Workflow workflow = this.makeWorkflow(remoteUserName);
            WorkflowDescriptor workflowDescriptor = jiraWorkflow.getDescriptor();
            List initialActions = workflowDescriptor.getInitialActions();
            if (initialActions == null || initialActions.isEmpty()) {
                throw new WorkflowException("No initial actions exist for workflow with name '" + jiraWorkflow.getName() + ".");
            }
            ActionDescriptor actionDescriptor = (ActionDescriptor)initialActions.get(0);
            long wfId = workflow.initialize(jiraWorkflow.getName(), actionDescriptor.getId(), fields);
            GenericValue issueGV = this.getIssueManager().getIssueByWorkflow(Long.valueOf(wfId));
            if (issueGV == null) {
                throw new WorkflowException("Issue workflow initialization error: unable to find Issue created with workflowId '" + wfId + "'. Did the IssueCreateFunction run successfully on workflow.initialize() ?");
            }
            return issueGV;
        }
        catch (InvalidRoleException e) {
            throw new WorkflowException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidInputException e) {
            throw new WorkflowException(e.getMessage(), (Throwable)e);
        }
        catch (GenericEntityException e) {
            throw new WorkflowException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidEntryStateException e) {
            throw new WorkflowException(e.getMessage(), (Throwable)e);
        }
        catch (com.opensymphony.workflow.WorkflowException e) {
            throw new WorkflowException(e.getMessage(), (Throwable)e);
        }
        catch (ClassCastException e) {
            String message = "Error occurred while creating issue. This could be due to a plugin being incompatible with this version of JIRA. For more details please consult the logs, and see: http://confluence.atlassian.com/x/3McB";
            throw new WorkflowException(message, (Throwable)e);
        }
        catch (Exception e) {
            throw new WorkflowException(e.getMessage(), (Throwable)e);
        }
    }

    public void removeWorkflowEntries(GenericValue issue) {
        this.getOfBizDelegator().removeByAnd("OSWorkflowEntry", EasyMap.build((Object)"id", (Object)issue.getLong("workflowId")));
        this.getOfBizDelegator().removeByAnd("OSCurrentStep", EasyMap.build((Object)"entryId", (Object)issue.getLong("workflowId")));
        this.getOfBizDelegator().removeByAnd("OSHistoryStep", EasyMap.build((Object)"entryId", (Object)issue.getLong("workflowId")));
    }

    private OfBizDelegator getOfBizDelegator() {
        return ComponentAccessor.getOfBizDelegator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWorkflowAction(WorkflowProgressAware from) {
        this.disableIndexingForThisThread();
        Transaction txn = Txn.begin();
        try {
            this.doWorkflowActionInsideTxn(txn, from);
        }
        finally {
            try {
                this.enableIndexingForThisThread();
            }
            catch (IndexException e) {
                throw new WorkflowException(e.getMessage(), (Throwable)e);
            }
            txn.finallyRollbackIfNotCommitted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWorkflowActionInsideTxn(Transaction txn, WorkflowProgressAware from) {
        MutableIssue issue = null;
        Long wfid = null;
        try {
            issue = from.getIssue();
            wfid = issue.getLong("workflowId");
            Workflow wf = this.getWorkflowObject(from);
            HashMap<String, Object> inputs = new HashMap<String, Object>();
            inputs.put("issue", issue);
            GenericValue genericValue = this.getIssueManager().getIssue(issue.getId());
            MutableIssue originalIssue = ComponentAccessor.getIssueFactory().getIssue(genericValue);
            inputs.put("originalissueobject", originalIssue);
            inputs.put("proj", from.getProjectObject());
            inputs.put("project", from.getProject());
            inputs.put("pkey", from.getProjectObject().getKey());
            if (from.getAdditionalInputs() != null) {
                inputs.putAll(from.getAdditionalInputs());
            }
            try {
                wf.doAction(wfid.longValue(), from.getAction(), inputs);
            }
            finally {
                if (ImportUtils.isIndexIssues()) {
                    ImportUtils.setIndexIssues((boolean)true);
                }
            }
            issue.store();
            txn.commit();
            this.getIssueIndexManager().reIndex((Issue)issue);
            if (!ObjectUtils.equals((Object)originalIssue.getSecurityLevelId(), (Object)issue.getSecurityLevelId())) {
                this.getIssueIndexManager().reIndexIssueObjects(issue.getSubTaskObjects());
            }
        }
        catch (InvalidInputException e) {
            for (String string : e.getGenericErrors()) {
                from.addErrorMessage(string);
            }
            for (Map.Entry entry : e.getErrors().entrySet()) {
                from.addError((String)entry.getKey(), (String)entry.getValue());
            }
            log.error((Object)String.format("Caught exception while attempting to perform action %d from workflow %d on issue '%s'", from.getAction(), wfid, issue), (Throwable)e);
        }
        catch (ClassCastException e) {
            String message = "Error occurred while creating issue. This could be due to a plugin being incompatible with this version of JIRA. For more details please consult the logs, and see: http://confluence.atlassian.com/x/3McB";
            log.error((Object)String.format("Caught exception while attempting to perform action %d from workflow %d on issue '%s'", from.getAction(), wfid, issue), (Throwable)e);
            from.addErrorMessage(message + " " + e.getMessage());
        }
        catch (Exception e) {
            from.addErrorMessage(e.getMessage());
            log.error((Object)String.format("Caught exception while attempting to perform action %d from workflow %d on issue '%s'", from.getAction(), wfid, issue), (Throwable)e);
        }
        finally {
            txn.finallyRollbackIfNotCommitted();
        }
    }

    private IssueIndexManager getIssueIndexManager() {
        return ComponentAccessor.getIssueIndexManager();
    }

    private void disableIndexingForThisThread() {
        this.getIssueIndexManager().hold();
    }

    private void enableIndexingForThisThread() throws IndexException {
        this.getIssueIndexManager().release();
    }

    private Workflow getWorkflowObject(WorkflowProgressAware from) {
        User user;
        String username = null;
        if (from.getAdditionalInputs() != null && from.getAdditionalInputs().containsKey("username")) {
            username = (String)from.getAdditionalInputs().get("username");
        }
        if (username == null && ActionContext.getPrincipal() != null) {
            username = ActionContext.getPrincipal().getName();
        }
        if (username == null && (user = from.getRemoteUser()) != null) {
            username = user.getName();
        }
        return this.makeWorkflow(username);
    }

    public User getRemoteUser(Map transientVars) {
        WorkflowContext context = (WorkflowContext)transientVars.get("context");
        String username = context.getCaller();
        if (username != null) {
            return this.getUserManager().getUserObject(username);
        }
        return null;
    }

    private UserManager getUserManager() {
        return ComponentAccessor.getUserManager();
    }

    public WorkflowStore getStore() throws StoreException {
        return this.getConfiguration().getWorkflowStore();
    }

    public ActionDescriptor getActionDescriptor(WorkflowProgressAware workflowProgressAware) throws Exception {
        JiraWorkflow workflow = this.getWorkflow(workflowProgressAware.getIssue().getGenericValue());
        return workflow.getDescriptor().getAction(workflowProgressAware.getAction());
    }

    public void migrateIssueToWorkflow(MutableIssue issue, JiraWorkflow newWorkflow, Status status) throws WorkflowException {
        GenericValue issueGV = issue.getGenericValue();
        this.migrateIssueToWorkflow(issueGV, newWorkflow, status.getGenericValue());
        issue.setWorkflowId(issueGV.getLong("workflowId"));
        issue.setStatusId(issueGV.getString("status"));
    }

    public Workflow makeWorkflow(String userName) {
        BasicWorkflow workflow = new BasicWorkflow(userName);
        workflow.setConfiguration(this.getConfiguration());
        return workflow;
    }

    public Workflow makeWorkflow(User user) {
        if (user == null) {
            return this.makeWorkflow((String)null);
        }
        return this.makeWorkflow(user.getName());
    }

    public boolean isEditable(Issue issue) {
        try {
            StepDescriptor currentStep;
            JiraWorkflow workflow = this.getWorkflow(issue.getProjectObject().getId(), issue.getIssueTypeObject().getId());
            String status = issue.getStatusObject().getId();
            return status != null && !"false".equals((currentStep = workflow.getLinkedStep(this.getConstantsManager().getStatus(status))).getMetaAttributes().get("jira.issue.editable"));
        }
        catch (WorkflowException e) {
            throw new RuntimeException((Object)((Object)e) + " when trying to access workflow for issue " + issue, e);
        }
    }

    private ConstantsManager getConstantsManager() {
        return ComponentAccessor.getConstantsManager();
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    public Map<ActionDescriptor, Collection<FunctionDescriptor>> getPostFunctionsForWorkflow(JiraWorkflow workflow) {
        HashMap<ActionDescriptor, Collection<FunctionDescriptor>> transitionPostFunctionMap = new HashMap<ActionDescriptor, Collection<FunctionDescriptor>>();
        Collection actions = workflow.getAllActions();
        for (ActionDescriptor actionDescriptor : actions) {
            Collection postFunctions = workflow.getPostFunctionsForTransition(actionDescriptor);
            transitionPostFunctionMap.put(actionDescriptor, postFunctions);
        }
        return transitionPostFunctionMap;
    }

    public String getStepId(long actionDescriptorId, String workflowName) {
        String stepId;
        block0: {
            Collection stepsForTransition;
            Iterator iterator;
            int actionDescId = new Long(actionDescriptorId).intValue();
            stepId = null;
            JiraWorkflow workflow = this.getWorkflow(workflowName);
            ActionDescriptor actionDescriptor = workflow.getDescriptor().getAction(actionDescId);
            if (actionDescriptor == null || !(iterator = (stepsForTransition = workflow.getStepsForTransition(actionDescriptor)).iterator()).hasNext()) break block0;
            StepDescriptor stepDescriptor = (StepDescriptor)iterator.next();
            stepId = String.valueOf(stepDescriptor.getId());
        }
        return stepId;
    }

    private IssueManager getIssueManager() {
        return ComponentAccessor.getIssueManager();
    }
}

