/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.workflow.ImmutableWorkflowDescriptor;
import com.atlassian.jira.workflow.JiraWorkflowDTO;
import com.atlassian.jira.workflow.WorkflowDescriptorStore;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.GuardedBy;

@EventComponent
public class CachingWorkflowDescriptorStore
implements WorkflowDescriptorStore {
    private final ConcurrentMap<String, ImmutableWorkflowDescriptor> workflowCache = new ConcurrentHashMap<String, ImmutableWorkflowDescriptor>();
    private final WorkflowDescriptorStore delegate;
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachingWorkflowDescriptorStore(WorkflowDescriptorStore delegate) {
        this.delegate = delegate;
        this.cacheLock.writeLock().lock();
        try {
            this.loadWorkflows();
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cacheLock.writeLock().lock();
        try {
            this.loadWorkflows();
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableWorkflowDescriptor getWorkflow(String name) throws FactoryException {
        if (name == null) {
            throw new IllegalArgumentException("Workflow name cannot be null!");
        }
        this.cacheLock.readLock().lock();
        try {
            ImmutableWorkflowDescriptor immutableWorkflowDescriptor = (ImmutableWorkflowDescriptor)((Object)this.workflowCache.get(name));
            return immutableWorkflowDescriptor;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeWorkflow(String name) {
        boolean deleted;
        if (name == null) {
            throw new IllegalArgumentException("Workflow name cannot be null!");
        }
        this.cacheLock.writeLock().lock();
        try {
            try {
                deleted = this.delegate.removeWorkflow(name);
            }
            catch (RuntimeException e) {
                this.loadWorkflows();
                throw e;
            }
            this.workflowCache.remove(name);
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveWorkflow(String name, WorkflowDescriptor workflowDescriptor, boolean replace) throws DataAccessException {
        boolean saved;
        if (name == null) {
            throw new IllegalArgumentException("name may not be null!");
        }
        if (workflowDescriptor == null) {
            throw new IllegalArgumentException("workflowDescriptor may not be null!");
        }
        this.cacheLock.writeLock().lock();
        try {
            saved = this.delegate.saveWorkflow(name, workflowDescriptor, replace);
            try {
                ImmutableWorkflowDescriptor storedWorkflow = this.delegate.getWorkflow(name);
                this.workflowCache.put(name, storedWorkflow);
            }
            catch (FactoryException e) {
                throw new RuntimeException("Loading workflowdescriptor saved to db failed. ", e);
            }
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
        return saved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getWorkflowNames() {
        Set workflowNameSet;
        this.cacheLock.readLock().lock();
        try {
            workflowNameSet = this.workflowCache.keySet();
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        return workflowNameSet.toArray(new String[workflowNameSet.size()]);
    }

    @Override
    public List<JiraWorkflowDTO> getAllJiraWorkflowDTOs() {
        return this.delegate.getAllJiraWorkflowDTOs();
    }

    @GuardedBy(value="cacheLock.writeLock()")
    private void loadWorkflows() {
        this.workflowCache.clear();
        for (JiraWorkflowDTO jiraWorkflowDTO : this.delegate.getAllJiraWorkflowDTOs()) {
            this.workflowCache.put(jiraWorkflowDTO.getName(), jiraWorkflowDTO.getDescriptor());
        }
    }
}

