/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webwork.parameters;

import com.atlassian.jira.webwork.parameters.AbstractParameterConverter;
import webwork.util.editor.PropertyEditorException;

public class DoubleConverter
extends AbstractParameterConverter {
    @Override
    public Object convertParameter(String[] parameterValues, Class paramType) throws IllegalArgumentException {
        return this.convert(parameterValues[0], paramType);
    }

    Double convert(String parameterValue, Class paramType) {
        this.checkPrimitiveInput(parameterValue, paramType, "EMPTY_DOUBLE");
        if (!paramType.isPrimitive() && this.isEmpty(parameterValue)) {
            return null;
        }
        return this.convertTo(parameterValue, paramType);
    }

    private Double convertTo(String parameterValue, Class paramType) {
        try {
            return Double.valueOf(parameterValue);
        }
        catch (NumberFormatException e) {
            throw new PropertyEditorException(paramType.isPrimitive() ? "BAD_DOUBLE" : "BAD_DOUBLEOBJ", (Object)parameterValue);
        }
    }
}

