/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cache.GoogleCacheInstruments;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.plugin.language.LanguageModuleDescriptor;
import com.atlassian.jira.plugin.language.TranslationTransform;
import com.atlassian.jira.plugin.language.TranslationTransformModuleDescriptor;
import com.atlassian.jira.plugin.util.InvolvedPluginsTracker;
import com.atlassian.jira.plugin.util.ModuleDescriptorComparator;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.LocaleParser;
import com.atlassian.jira.util.i18n.I18nTranslationMode;
import com.atlassian.jira.util.resourcebundle.DefaultResourceBundle;
import com.atlassian.jira.web.bean.BackingI18n;
import com.atlassian.jira.web.util.JiraLocaleUtils;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.event.events.PluginRefreshedEvent;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class I18nBean
implements I18nHelper {
    private final I18nHelper delegate;

    public static Locale getLocaleFromUser(User user) {
        if (user != null) {
            PropertySet propertySet = I18nBean.getUserPropertyManager().getPropertySet(user);
            if (propertySet == null) {
                return I18nBean.getDefaultLocale();
            }
            String localeStr = propertySet.getString("jira.user.locale");
            if (!StringUtils.isBlank((String)localeStr)) {
                return LocaleParser.parseLocale((String)localeStr);
            }
        }
        return I18nBean.getDefaultLocale();
    }

    private static Locale getDefaultLocale() {
        return ComponentAccessor.getApplicationProperties().getDefaultLocale();
    }

    private static UserPropertyManager getUserPropertyManager() {
        return ComponentAccessor.getUserPropertyManager();
    }

    public I18nBean() {
        this.delegate = this.getFactory().getInstance(ComponentAccessor.getApplicationProperties().getDefaultLocale());
    }

    public I18nBean(Locale locale) {
        this.delegate = this.getFactory().getInstance(locale);
    }

    public I18nBean(User user) {
        this(I18nBean.getLocaleFromUser(user));
    }

    public I18nBean(I18nHelper delegate) {
        this.delegate = delegate;
    }

    @Deprecated
    public I18nBean(String localeString) {
        this(LocaleParser.parseLocale((String)localeString));
    }

    protected I18nHelper.BeanFactory getFactory() {
        return ComponentAccessor.getI18nHelperFactory();
    }

    public Locale getLocale() {
        return this.delegate.getLocale();
    }

    public ResourceBundle getDefaultResourceBundle() {
        return this.delegate.getDefaultResourceBundle();
    }

    public Set<String> getKeysForPrefix(String prefix) {
        return this.delegate.getKeysForPrefix(prefix);
    }

    public String getUnescapedText(String key) {
        return this.delegate.getUnescapedText(key);
    }

    public String getUntransformedRawText(String key) {
        return this.delegate.getUntransformedRawText(key);
    }

    public boolean isKeyDefined(String key) {
        return this.delegate.isKeyDefined(key);
    }

    public String getText(String key) {
        return this.delegate.getText(key);
    }

    public String getText(String key, String value1) {
        return this.delegate.getText(key, value1);
    }

    public String getText(String key, Object parameters) {
        return this.delegate.getText(key, parameters);
    }

    public String getText(String key, Object value1, Object value2, Object value3) {
        return this.delegate.getText(key, value1, value2, value3);
    }

    public String getText(String key, String value1, String value2) {
        return this.delegate.getText(key, value1, value2);
    }

    public String getText(String key, String value1, String value2, String value3) {
        return this.delegate.getText(key, value1, value2, value3);
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4) {
        return this.delegate.getText(key, value1, value2, value3, value4);
    }

    public String getText(String key, String value1, String value2, String value3, String value4) {
        return this.delegate.getText(key, value1, value2, value3, value4);
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5) {
        return this.delegate.getText(key, value1, value2, value3, value4, value5);
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6) {
        return this.delegate.getText(key, value1, value2, value3, value4, value5, value6);
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6, Object value7) {
        return this.delegate.getText(key, value1, value2, value3, value4, value5, value6, value7);
    }

    public String getText(String key, String value1, String value2, String value3, String value4, String value5, String value6, String value7) {
        return this.delegate.getText(key, value1, value2, value3, value4, value5, value6, value7);
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6, Object value7, Object value8) {
        return this.delegate.getText(key, value1, value2, value3, value4, value5, value6, value7, value8);
    }

    public String getText(String key, String value1, String value2, String value3, String value4, String value5, String value6, String value7, String value8, String value9) {
        return this.delegate.getText(key, value1, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    public static class CachingFactory
    implements I18nHelper.BeanFactory,
    Startable {
        private static final String I18N_RESOURCE_TYPE = "i18n";
        private final Cache<Locale, BackingI18n> cache;
        private final JiraLocaleUtils jiraLocaleUtils;
        private final InvolvedPluginsTracker involvedPluginsTracker;
        private final EventPublisher eventPublisher;
        private final ResettableLazyReference<List<TranslationTransform>> translationTransformsRef = new ResettableLazyReference<List<TranslationTransform>>(){

            protected List<TranslationTransform> create() throws Exception {
                return CachingFactory.this.loadTranslationTransforms();
            }
        };

        public CachingFactory(JiraLocaleUtils jiraLocaleUtils, final I18nTranslationMode i18nTranslationMode, EventPublisher eventPublisher) {
            this.jiraLocaleUtils = jiraLocaleUtils;
            this.involvedPluginsTracker = new InvolvedPluginsTracker();
            this.eventPublisher = eventPublisher;
            CacheLoader<Locale, BackingI18n> cacheLoader = new CacheLoader<Locale, BackingI18n>(){

                public BackingI18n load(Locale locale) {
                    return new BackingI18n(locale, i18nTranslationMode, CachingFactory.this.involvedPluginsTracker, (List)CachingFactory.this.translationTransformsRef.get());
                }
            };
            this.cache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build((CacheLoader)cacheLoader);
        }

        @EventListener
        public void pluginModuleDisabled(PluginModuleDisabledEvent event) {
            if (this.involvedPluginsTracker.isPluginInvolved(event.getModule())) {
                this.clearCaches();
            }
        }

        @EventListener
        public void pluginModuleEnabled(PluginModuleEnabledEvent event) {
            if (this.involvedPluginsTracker.isPluginWithModuleDescriptor(event.getModule(), LanguageModuleDescriptor.class) || this.involvedPluginsTracker.isPluginWithResourceType(event.getModule(), I18N_RESOURCE_TYPE) || this.involvedPluginsTracker.isPluginWithModuleDescriptor(event.getModule(), TranslationTransformModuleDescriptor.class)) {
                this.clearCaches();
            }
        }

        @EventListener
        public void pluginRefreshed(PluginRefreshedEvent event) {
            if (this.involvedPluginsTracker.isPluginInvolved(event.getPlugin())) {
                this.clearCaches();
            }
        }

        private void clearCaches() {
            this.involvedPluginsTracker.clear();
            this.cache.invalidateAll();
            this.jiraLocaleUtils.resetInstalledLocales();
            this.translationTransformsRef.reset();
        }

        public I18nHelper getInstance(Locale locale) {
            if (DefaultResourceBundle.isDefaultResourceBundleStale(locale)) {
                this.clearCaches();
            }
            return (I18nHelper)this.cache.getUnchecked((Object)locale);
        }

        public I18nHelper getInstance(User user) {
            return this.getInstance(I18nBean.getLocaleFromUser(user));
        }

        public String getStateHashCode() {
            return Integer.toString(this.involvedPluginsTracker.hashCode(), 36);
        }

        public void start() {
            this.eventPublisher.register((Object)this);
            this.clearCaches();
            new GoogleCacheInstruments("i18n." + this.getClass().getSimpleName()).addCache(this.cache).install();
        }

        private PluginAccessor getPluginAccessor() {
            return ComponentAccessor.getPluginAccessor();
        }

        private List<TranslationTransform> loadTranslationTransforms() {
            PluginAccessor pluginAccessor = this.getPluginAccessor();
            ArrayList<TranslationTransform> translationTransforms = new ArrayList<TranslationTransform>();
            ArrayList descriptors = new ArrayList(pluginAccessor.getEnabledModuleDescriptorsByClass(TranslationTransformModuleDescriptor.class));
            Collections.sort(descriptors, ModuleDescriptorComparator.COMPARATOR);
            for (TranslationTransformModuleDescriptor descriptor : descriptors) {
                TranslationTransform translationTransform = (TranslationTransform)descriptor.getModule();
                this.involvedPluginsTracker.trackInvolvedPlugin((ModuleDescriptor)descriptor);
                translationTransforms.add(translationTransform);
            }
            return translationTransforms;
        }
    }

    public static class AccessorFactory
    implements I18nHelper.BeanFactory {
        private final I18nHelper.BeanFactory delegate;

        public AccessorFactory(CachingFactory delegate) {
            this.delegate = delegate;
        }

        public I18nHelper getInstance(Locale locale) {
            return this.delegate.getInstance(locale);
        }

        public I18nHelper getInstance(User user) {
            return this.delegate.getInstance(user);
        }
    }
}

