/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.config.ConfigurationException;
import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.config.bootstrap.DefaultAtlassianBootstrapManager;
import com.atlassian.config.db.DatabaseDetails;
import com.atlassian.config.db.DatabaseList;
import com.atlassian.core.util.PairType;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.database.DatabaseDriverRegisterer;
import com.atlassian.jira.config.database.InvalidDatabaseDriverException;
import com.atlassian.jira.config.database.JdbcDatasource;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.configurator.config.DatabaseType;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.setup.AbstractSetupAction;
import com.atlassian.jira.web.action.setup.IndexLanguageToLocaleMapper;
import com.atlassian.jira.web.util.HelpUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.util.TextUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.config.ConnectionPoolInfo;

public class SetupDatabase
extends AbstractSetupAction {
    private static final int DEFAULT_POOL_SIZE = 20;
    private boolean testingConnection;
    private final BuildUtilsInfo buildUtilsInfo;
    private final DatabaseConfigurationManager databaseConfigurationManager;
    private final ApplicationProperties applicationProperties;
    private final IndexLanguageToLocaleMapper languageToLocaleMapper;
    private final VelocityTemplatingEngine velocityEngine;
    private String language;
    private boolean changingLanguage;
    private String databaseOption = "INTERNAL";
    private String databaseType;
    private String schemaName;
    private static final Map<String, String> SCHEMA_NAMES = ImmutableMap.of((Object)"postgres72", (Object)"public", (Object)"mssql", (Object)"dbo");
    private String jdbcHostname;
    private String jdbcPort;
    private String jdbcDatabase;
    private String jdbcSid;
    private String jdbcUsername;
    private String jdbcPassword;
    private Integer poolSize = 20;
    private String dbErrorMessage;
    private DatabaseList databaseList = new DatabaseList();
    private boolean isTestConnectionSuccessful;
    private static final Map<String, DatabaseType> databaseTypeMap = MapBuilder.newBuilder().add((Object)DatabaseType.ORACLE.getTypeName(), (Object)DatabaseType.ORACLE).add((Object)DatabaseType.POSTGRES.getTypeName(), (Object)DatabaseType.POSTGRES).add((Object)DatabaseType.MY_SQL.getTypeName(), (Object)DatabaseType.MY_SQL).add((Object)DatabaseType.SQL_SERVER.getTypeName(), (Object)DatabaseType.SQL_SERVER).toMap();

    public SetupDatabase(FileFactory fileFactory, IndexLanguageToLocaleMapper languageToLocaleMapper, BuildUtilsInfo buildUtilsInfo, DatabaseConfigurationManager databaseConfigurationManager, ApplicationProperties applicationProperties, VelocityTemplatingEngine velocityEngine) {
        super(fileFactory);
        this.languageToLocaleMapper = languageToLocaleMapper;
        this.buildUtilsInfo = buildUtilsInfo;
        this.databaseConfigurationManager = databaseConfigurationManager;
        this.applicationProperties = applicationProperties;
        this.velocityEngine = velocityEngine;
    }

    public String doInput() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        return "input";
    }

    public String doDefault() {
        if (this.isDatabaseSetup()) {
            return this.forceRedirect("Setup!input.jspa?title=Your+Company+JIRA&mode=public");
        }
        return "input";
    }

    protected void doValidation() {
        if (this.setupAlready() || this.isChangingLanguage()) {
            return;
        }
        if (this.isExternalDatabase()) {
            if ("".equals(this.databaseType)) {
                this.addError("databaseType", this.getText("setupdb.error.selectDatabaseType"));
            }
            if (StringUtils.isEmpty((String)this.jdbcHostname)) {
                this.addError("jdbcHostname", this.getText("setupdb.error.requireJdbcHostname"));
            }
            if (StringUtils.isEmpty((String)this.jdbcPort)) {
                this.addError("jdbcPort", this.getText("setupdb.error.requireJdbcPort"));
            }
            if (this.isOracleDatabaseType()) {
                if (StringUtils.isEmpty((String)this.jdbcSid)) {
                    this.addError("jdbcSid", this.getText("setupdb.error.requireSID"));
                }
            } else if (StringUtils.isEmpty((String)this.jdbcDatabase)) {
                this.addError("jdbcDatabase", this.getText("setupdb.error.requireDatabase"));
            }
            if (StringUtils.isEmpty((String)this.jdbcUsername)) {
                this.addError("jdbcUsername", this.getText("setupdb.error.requireJdbcUsername"));
            }
        }
        this.testConnection();
        this.validateDatabaseIsEmpty();
        super.doValidation();
    }

    private boolean isOracleDatabaseType() {
        return "oracle10g".equals(this.databaseType);
    }

    private boolean isExternalDatabase() {
        return "EXTERNAL".equals(this.databaseOption);
    }

    private void testConnection() {
        if (!this.hasAnyErrors()) {
            block6: {
                try {
                    DatabaseConfig databaseConfiguration = this.createDatabaseConfiguration();
                    StartupCheck startupCheck = databaseConfiguration.testConnection((AtlassianBootstrapManager)new DefaultAtlassianBootstrapManager());
                    if (startupCheck != null) {
                        this.addErrorMessage(startupCheck.getFaultDescription());
                    }
                }
                catch (BootstrapException e) {
                    this.addErrorMessage(this.getText("setupdb.error.connectionFailed"));
                    Throwable cause = e.getCause();
                    this.addErrorMessage(cause.getLocalizedMessage());
                    if (cause.getCause() != null && !cause.getLocalizedMessage().equals(cause.getCause().getLocalizedMessage())) {
                        this.addErrorMessage(cause.getCause().getLocalizedMessage());
                    }
                }
                catch (InvalidDatabaseDriverException e) {
                    this.addErrorMessage(this.getText("setupdb.error.invalidDriver", e.driverClassName()));
                    if (!this.isNotShippedDriver(this.getDatabaseTypeEnum())) break block6;
                    this.dbErrorMessage = this.createNotPresentMessage(this.getDatabaseTypeEnum());
                }
            }
            this.isTestConnectionSuccessful = this.isTestingConnection() && !this.hasAnyErrors();
        }
    }

    private void validateDatabaseIsEmpty() {
        if (!this.hasAnyErrors()) {
            boolean isDatabaseEmpty;
            block4: {
                isDatabaseEmpty = false;
                DatabaseConfig databaseConfiguration = this.createDatabaseConfiguration();
                try {
                    isDatabaseEmpty = databaseConfiguration.isDatabaseEmpty(new DefaultAtlassianBootstrapManager());
                }
                catch (BootstrapException e) {
                    this.addErrorMessage(this.getText("setupdb.error.connectionFailed"));
                    Throwable cause = e.getCause();
                    this.addErrorMessage(cause.getLocalizedMessage());
                    if (cause.getCause() == null || cause.getLocalizedMessage().equals(cause.getCause().getLocalizedMessage())) break block4;
                    this.addErrorMessage(cause.getCause().getLocalizedMessage());
                }
            }
            if (!isDatabaseEmpty) {
                this.addErrorMessage(this.getText("setupdb.error.nonemptyDatabase"));
            }
            this.isTestConnectionSuccessful = this.isTestingConnection() && !this.hasAnyErrors();
        }
    }

    protected String doExecute() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        if (this.isDatabaseSetup()) {
            return this.forceRedirect("Setup!input.jspa?title=Your+Company+JIRA&mode=public");
        }
        if (this.isChangingLanguage()) {
            this.setLanguage();
            return "input";
        }
        if (this.isTestingConnection()) {
            return this.hasAnyErrors() ? "error" : "input";
        }
        DatabaseConfig databaseConfiguration = this.createDatabaseConfiguration();
        this.databaseConfigurationManager.setDatabaseConfiguration(databaseConfiguration);
        this.databaseConfigurationManager.activateDatabase();
        return this.forceRedirect("Setup!input.jspa?title=Your+Company+JIRA&mode=public");
    }

    private DatabaseConfig createDatabaseConfiguration() {
        if (this.isExternalDatabase()) {
            DatabaseDetails databaseDetails = this.getDatabaseDetails(this.databaseType);
            this.poolSize = databaseDetails.getPoolSize();
            String instanceName = this.isOracleDatabaseType() ? this.jdbcSid : this.jdbcDatabase;
            DatabaseType type = this.getDatabaseTypeEnum();
            ConnectionPoolInfo.Builder connectionPoolInfoBuilder = ConnectionPoolInfo.builder();
            connectionPoolInfoBuilder.setPoolMaxSize(this.poolSize).setPoolMaxWait(Long.valueOf(30000L)).setPoolMinSize(this.poolSize).setRemoveAbandoned(Boolean.valueOf(true)).setRemoveAbandonedTimeout(Integer.valueOf(300));
            if (type == DatabaseType.MY_SQL) {
                connectionPoolInfoBuilder.setValidationQuery("select 1");
                connectionPoolInfoBuilder.setValidationQueryTimeout(Integer.valueOf(3));
                connectionPoolInfoBuilder.setTestWhileIdle(Boolean.valueOf(true));
                connectionPoolInfoBuilder.setMinEvictableTimeMillis(Long.valueOf(60000L));
                connectionPoolInfoBuilder.setTimeBetweenEvictionRunsMillis(Long.valueOf(300000L));
            }
            if (type == DatabaseType.HSQL) {
                connectionPoolInfoBuilder.setMinEvictableTimeMillis(Long.valueOf(4000L));
                connectionPoolInfoBuilder.setTimeBetweenEvictionRunsMillis(Long.valueOf(5000L));
            }
            JdbcDatasource.Builder builder = JdbcDatasource.builder().setDatabaseType(type).setHostname(this.jdbcHostname).setPort(this.jdbcPort).setInstance(instanceName).setUsername(this.jdbcUsername).setPassword(this.jdbcPassword).setConnectionPoolInfo(connectionPoolInfoBuilder.build());
            JdbcDatasource datasource = builder.build();
            return new DatabaseConfig(this.databaseType, this.schemaName, datasource);
        }
        return this.databaseConfigurationManager.getInternalDatabaseConfiguration();
    }

    public boolean isDatabaseConnectionTestWorked() {
        return this.isTestConnectionSuccessful;
    }

    public boolean isDatabaseSetup() {
        return this.databaseConfigurationManager.isDatabaseSetup();
    }

    public Map<String, String> getInstalledLocales() {
        Set installedLocales = ((LocaleManager)ComponentAccessor.getComponentOfType(LocaleManager.class)).getInstalledLocales();
        LinkedHashMap<String, String> localeMap = new LinkedHashMap<String, String>();
        for (Locale installedLocale : installedLocales) {
            localeMap.put(installedLocale.toString(), installedLocale.getDisplayName(installedLocale));
        }
        return localeMap;
    }

    public List<PairType> getExternalDatabases() {
        PairType defaultSelect = new PairType((Serializable)((Object)""), (Serializable)((Object)this.getText("setupdb.database.selectType")));
        ArrayList<PairType> selectList = new ArrayList<PairType>();
        selectList.add(defaultSelect);
        selectList.addAll(this.databaseList.getDatabases());
        return selectList;
    }

    public List<DbMessage> getDatabaseMessages() {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Map.Entry<String, DatabaseType> databaseType : databaseTypeMap.entrySet()) {
            DatabaseDriverRegisterer registerer = DatabaseDriverRegisterer.forType(databaseType.getValue());
            if (this.isNotShippedDriver(databaseType.getValue()) && !registerer.isDriverRegistered()) {
                result.add((Object)new DbMessage(databaseType.getKey(), this.createNotPresentMessage(databaseType.getValue())));
                continue;
            }
            result.add((Object)new DbMessage(databaseType.getKey(), null));
        }
        return result.build();
    }

    public DatabaseDetails getDatabaseDetails(String database) {
        try {
            return DatabaseDetails.getDefaults((String)database);
        }
        catch (ConfigurationException e) {
            this.log.debug((Object)e);
            return null;
        }
    }

    public String getSchemaName(String database) {
        return SCHEMA_NAMES.get(database);
    }

    public String getDefaultServerLanguage() {
        String defaultLocale = this.applicationProperties.getDefaultLocale().toString();
        if (this.getInstalledLocales().keySet().contains(defaultLocale)) {
            return defaultLocale;
        }
        return "en_UK";
    }

    private boolean isNotShippedDriver(DatabaseType databaseType) {
        return databaseType == DatabaseType.MY_SQL;
    }

    private String createNotPresentMessage(DatabaseType dbType) {
        return this.getText("setupdb.database.drivernotpresent", dbType.getDisplayName(), this.getDocLink(dbType, this.getText("setupdb.database.drivernotpresent.linktext")));
    }

    private String getDocLink(DatabaseType type, String linkText) {
        HelpUtil.HelpPath helpPath = DatabaseDriverRegisterer.getDbConfigLink(type);
        return this.velocityEngine.render(TemplateSources.file((String)"/templates/jira/simplelink.vm")).applying((Map)ImmutableMap.of((Object)"targetUrl", (Object)helpPath.getUrl(), (Object)"title", (Object)helpPath.getTitle(), (Object)"alt", (Object)helpPath.getAlt(), (Object)"newWindow", (Object)true, (Object)"linkText", (Object)linkText)).asHtml();
    }

    private void setLanguage() {
        ApplicationProperties applicationProperties = this.getApplicationProperties();
        if (TextUtils.stringSet((String)this.getLanguage())) {
            applicationProperties.setString("jira.i18n.default.locale", this.getLanguage());
        }
        applicationProperties.setString("jira.i18n.language.index", this.languageToLocaleMapper.getLanguageForLocale(this.getLocale().toString()));
    }

    private DatabaseType getDatabaseTypeEnum() {
        DatabaseType type = databaseTypeMap.get(this.databaseType);
        if (type == null) {
            throw new IllegalStateException("Unknown database type '" + this.databaseType + "'");
        }
        return type;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public String getDatabaseOption() {
        return this.databaseOption;
    }

    public void setDatabaseOption(String databaseOption) {
        this.databaseOption = databaseOption;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public BuildUtilsInfo getBuildUtilsInfo() {
        return this.buildUtilsInfo;
    }

    public int modulo(int index, int modulus) {
        return index % modulus;
    }

    public boolean isTestingConnection() {
        return this.testingConnection;
    }

    public void setTestingConnection(boolean testingConnection) {
        this.testingConnection = testingConnection;
    }

    public String getJdbcHostname() {
        return this.jdbcHostname;
    }

    public void setJdbcHostname(String jdbcHostname) {
        this.jdbcHostname = jdbcHostname;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public String getJdbcPort() {
        return this.jdbcPort;
    }

    public void setJdbcPort(String jdbcPort) {
        this.jdbcPort = jdbcPort;
    }

    public String getJdbcDatabase() {
        return this.jdbcDatabase;
    }

    public void setJdbcDatabase(String jdbcDatabase) {
        this.jdbcDatabase = jdbcDatabase;
    }

    public String getJdbcSid() {
        return this.jdbcSid;
    }

    public void setJdbcSid(String jdbcSid) {
        this.jdbcSid = jdbcSid;
    }

    public String getJdbcUsername() {
        return this.jdbcUsername;
    }

    public void setJdbcUsername(String jdbcUsername) {
        this.jdbcUsername = jdbcUsername;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public boolean isChangingLanguage() {
        return this.changingLanguage;
    }

    public void setChangingLanguage(boolean changingLanguage) {
        this.changingLanguage = changingLanguage;
    }

    public boolean isHasDbErrorMessage() {
        return this.dbErrorMessage != null;
    }

    public String getDbErrorMessage() {
        return this.dbErrorMessage;
    }

    public static class DbMessage {
        private final String type;
        private final String message;

        public DbMessage(String type, String msg) {
            this.type = type;
            this.message = msg;
        }

        public String getType() {
            return this.type;
        }

        public boolean getHasMessage() {
            return this.message != null;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

