/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.enterprise;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutScheme;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@WebSudoRequired
public class ViewSchemes
extends JiraWebActionSupport {
    private String fieldLayoutSchemeName;
    private String fieldLayoutSchemeDescription;
    private final FieldLayoutManager fieldLayoutManager;
    private Map schemeProjectsMap;

    public ViewSchemes(FieldLayoutManager fieldLayoutManager) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.schemeProjectsMap = new HashMap();
    }

    public List<FieldLayoutScheme> getFieldLayoutScheme() {
        try {
            return this.getFieldLayoutManager().getFieldLayoutSchemes();
        }
        catch (DataAccessException e) {
            this.log.error((Object)e, (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.fieldlayout.could.not.retrieve"));
            return Collections.emptyList();
        }
    }

    public Collection getSchemeProjects(FieldLayoutScheme fieldLayoutScheme) {
        if (fieldLayoutScheme == null) {
            throw new IllegalArgumentException(this.getText("admin.errors.fieldlayout.fls.must.not.be.null"));
        }
        if (!this.schemeProjectsMap.containsKey(fieldLayoutScheme.getId())) {
            try {
                this.schemeProjectsMap.put(fieldLayoutScheme.getId(), this.getFieldLayoutManager().getProjects(fieldLayoutScheme));
            }
            catch (DataAccessException e) {
                this.log.error((Object)e, (Throwable)e);
                this.addErrorMessage(this.getText("admin.errors.fieldlayout.could.not.retrieve.projects", fieldLayoutScheme));
                return Collections.EMPTY_LIST;
            }
        }
        Collection projects = (Collection)this.schemeProjectsMap.get(fieldLayoutScheme.getId());
        Collections.sort((List)projects, OfBizComparators.NAME_COMPARATOR);
        return projects;
    }

    protected FieldLayoutManager getFieldLayoutManager() {
        return this.fieldLayoutManager;
    }

    public String getFieldLayoutSchemeName() {
        return this.fieldLayoutSchemeName;
    }

    public void setFieldLayoutSchemeName(String fieldLayoutSchemeName) {
        this.fieldLayoutSchemeName = fieldLayoutSchemeName;
    }

    public String getFieldLayoutSchemeDescription() {
        return this.fieldLayoutSchemeDescription;
    }

    public void setFieldLayoutSchemeDescription(String fieldLayoutSchemeDescription) {
        this.fieldLayoutSchemeDescription = fieldLayoutSchemeDescription;
    }
}

