/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.customfields;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.admin.RenderableProperty;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.context.manager.JiraContextTreeManager;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.CustomFieldDescription;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ObjectUtils;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.JiraWizardActionSupport;
import com.atlassian.jira.web.action.admin.customfields.CustomFieldContextConfigHelper;
import com.atlassian.jira.web.action.admin.customfields.CustomFieldContextManagementBean;
import com.atlassian.jira.web.action.admin.customfields.CustomFieldValidator;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@WebSudoRequired
public class CreateCustomField
extends JiraWizardActionSupport {
    public static final String FIELD_TYPE_PREFIX = "com.atlassian.jira.plugin.system.customfieldtypes:";
    private String fieldName;
    private String description;
    private String fieldType;
    private String searcher;
    private boolean global = true;
    private boolean basicMode = true;
    private Long[] projectCategories;
    private Long[] projects = new Long[0];
    private String[] issuetypes = new String[]{"-1"};
    private final ProjectManager projectManager;
    private final SubTaskManager subTaskManager;
    private final CustomFieldDescription customFieldDescription;
    private final CustomFieldManager customFieldManager;
    private final ConstantsManager constantsManager;
    private final CustomFieldValidator customFieldValidator;
    private final JiraContextTreeManager treeManager;
    private final ReindexMessageManager reindexMessageManager;
    private final CustomFieldContextConfigHelper customFieldContextConfigHelper;
    private final FeatureManager featureManager;
    private final ManagedConfigurationItemService managedConfigurationItemService;

    public CreateCustomField(JiraContextTreeManager treeManager, CustomFieldValidator customFieldValidator, ConstantsManager constantsManager, CustomFieldManager customFieldManager, ProjectManager projectManager, SubTaskManager subTaskManager, ReindexMessageManager reindexMessageManager, CustomFieldContextConfigHelper customFieldContextConfigHelper, CustomFieldDescription customFieldDescription, FeatureManager featureManager, ManagedConfigurationItemService managedConfigurationItemService) {
        this.treeManager = treeManager;
        this.customFieldValidator = customFieldValidator;
        this.constantsManager = constantsManager;
        this.customFieldManager = customFieldManager;
        this.projectManager = projectManager;
        this.subTaskManager = subTaskManager;
        this.customFieldDescription = customFieldDescription;
        this.managedConfigurationItemService = managedConfigurationItemService;
        this.reindexMessageManager = (ReindexMessageManager)Assertions.notNull((String)"reindexMessageManager", (Object)reindexMessageManager);
        this.customFieldContextConfigHelper = (CustomFieldContextConfigHelper)Assertions.notNull((String)"customFieldContextConfigHelper", (Object)customFieldContextConfigHelper);
        this.featureManager = featureManager;
    }

    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        String url = !this.isFinishClicked() && this.isNextClicked() ? this.doCustomFieldType() : (this.isFinishClicked() ? this.doAddDetails() : "input");
        if (!this.invalidInput()) {
            super.doExecute();
        }
        return url;
    }

    public String doCustomFieldType() throws Exception {
        this.addErrorCollection(this.customFieldValidator.validateType(this.getFieldType()));
        if (this.invalidInput()) {
            return "input";
        }
        return "details";
    }

    public String doAddDetails() throws Exception {
        this.addErrorCollection(this.customFieldValidator.validateType(this.getFieldType()));
        this.addErrorCollection(this.customFieldValidator.validateDetails(this.fieldName, this.fieldType, this.searcher));
        if (!(this.isGlobal() || this.projects != null && this.projects.length != 0)) {
            this.addError("projects", this.getText("admin.errors.must.select.project.for.non.global.contexts"));
        }
        if (this.invalidInput()) {
            return "details";
        }
        CustomFieldSearcher cfs = ObjectUtils.isValueSelected((Object)this.searcher) ? this.customFieldManager.getCustomFieldSearcher(this.searcher) : null;
        List contexts = CustomFieldUtils.buildJiraIssueContexts((boolean)this.isGlobal(), (Long[])this.getProjectCategories(), (Long[])this.getProjects(), (JiraContextTreeManager)this.treeManager);
        List returnIssueTypes = CustomFieldUtils.buildIssueTypes((ConstantsManager)this.constantsManager, (String[])this.getIssuetypes());
        CustomField customField = this.customFieldManager.createCustomField(this.fieldName, this.description, this.getCustomFieldType(), cfs, contexts, returnIssueTypes);
        if (this.customFieldContextConfigHelper.doesAddingContextToCustomFieldAffectIssues(this.getLoggedInUser(), customField, contexts, returnIssueTypes, true)) {
            this.reindexMessageManager.pushMessage(this.getLoggedInUser(), "admin.notifications.task.custom.fields");
        }
        return this.getRedirect("AssociateFieldToScreens!default.jspa?fieldId=" + customField.getId() + "&returnUrl=ViewCustomFields.jspa");
    }

    public Collection getFieldTypes() {
        List customFieldTypes = this.customFieldManager.getCustomFieldTypes();
        final User user = this.getLoggedInUser();
        return CollectionUtil.filter((Collection)customFieldTypes, (Predicate)new Predicate<CustomFieldType>(){

            public boolean evaluate(CustomFieldType input) {
                return !input.getDescriptor().isTypeManaged() || CreateCustomField.this.managedConfigurationItemService.doesUserHavePermission(user, input.getDescriptor().getManagedAccessLevel());
            }
        });
    }

    public List getSearchers() {
        return this.customFieldManager.getCustomFieldSearchers(this.customFieldManager.getCustomFieldType(this.getFieldType()));
    }

    public RenderableProperty getDescriptionProperty() {
        return this.customFieldDescription.createRenderablePropertyFor(null);
    }

    public CustomFieldType getCustomFieldType() {
        return this.customFieldManager.getCustomFieldType(this.getFieldType());
    }

    public Collection getAllProjects() throws Exception {
        return this.projectManager.getProjects();
    }

    public Collection getAllProjectCategories() throws Exception {
        return this.projectManager.getProjectCategories();
    }

    public Collection getAllIssueTypes() throws Exception {
        if (this.subTaskManager.isSubTasksEnabled()) {
            return this.constantsManager.getAllIssueTypeObjects();
        }
        return this.constantsManager.getRegularIssueTypeObjects();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public boolean isFieldTypeValid() {
        boolean valid = this.customFieldValidator.isValidType(this.getFieldType());
        return valid;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public String getSearcher() {
        List searchers;
        if (StringUtils.isEmpty((String)this.searcher) && StringUtils.isNotEmpty((String)this.fieldType) && (searchers = this.getSearchers()) != null && !searchers.isEmpty()) {
            this.searcher = ((CustomFieldSearcher)searchers.iterator().next()).getDescriptor().getCompleteKey();
        }
        return this.searcher;
    }

    public boolean isOnDemand() {
        return this.featureManager.isEnabled(CoreFeatures.ON_DEMAND);
    }

    public void setSearcher(String searcher) {
        this.searcher = searcher;
    }

    public Long[] getProjects() {
        return this.projects;
    }

    public void setProjects(Long[] projects) {
        this.projects = projects;
    }

    public String[] getIssuetypes() {
        return this.issuetypes;
    }

    public void setIssuetypes(String[] issuetypes) {
        this.issuetypes = issuetypes;
    }

    public Map getGlobalContextOption() {
        return CustomFieldContextManagementBean.getGlobalContextOption();
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public boolean isBasicMode() {
        return this.basicMode;
    }

    public void setBasicMode(boolean basicMode) {
        this.basicMode = basicMode;
    }

    public Long[] getProjectCategories() {
        return this.projectCategories;
    }

    public void setProjectCategories(Long[] projectCategories) {
        this.projectCategories = projectCategories;
    }

    @Override
    public int getTotalSteps() {
        return 2;
    }
}

