/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.profile;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.avatar.MD5Util;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.profile.AbstractUserProfileFragment;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.GroupPermissionChecker;
import com.atlassian.jira.util.VelocityParamFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.google.common.base.Preconditions;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class DetailsUserProfileFragment
extends AbstractUserProfileFragment {
    private final EmailFormatter emailFormatter;
    private final GroupPermissionChecker groupPermissionChecker;
    private final PermissionManager permissionManager;
    private final CrowdService crowdService;
    private final UserPropertyManager userPropertyManager;
    private final WebResourceManager webResourceManager;
    private final AvatarManager avatarManager;
    private final UserManager userManager;
    private final AvatarService avatarService;
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    public DetailsUserProfileFragment(JiraAuthenticationContext jiraAuthenticationContext, VelocityTemplatingEngine templatingEngine, VelocityParamFactory velocityParamFactory, EmailFormatter emailFormatter, GroupPermissionChecker groupPermissionChecker, PermissionManager permissionManager, CrowdService crowdService, UserPropertyManager userPropertyManager, WebResourceManager webResourceManager, AvatarManager avatarManager, UserManager userManager, VelocityRequestContextFactory velocityRequestContextFactory, AvatarService avatarService) {
        super(jiraAuthenticationContext, templatingEngine, velocityParamFactory);
        this.emailFormatter = emailFormatter;
        this.groupPermissionChecker = groupPermissionChecker;
        this.permissionManager = permissionManager;
        this.crowdService = crowdService;
        this.userPropertyManager = userPropertyManager;
        this.webResourceManager = webResourceManager;
        this.avatarManager = avatarManager;
        this.userManager = userManager;
        this.avatarService = avatarService;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    @Override
    protected Map<String, Object> createVelocityParams(User profileUser, User currentUser) {
        List<String> groups;
        this.webResourceManager.requireResource("jira.webresources:avatar-picker");
        Map<String, Object> params = super.createVelocityParams(profileUser, currentUser);
        params.put("context", new Context(profileUser, currentUser));
        boolean canEditAvatar = this.avatarService.canSetCustomUserAvatar(currentUser, profileUser.getName());
        boolean currentUserIsProfileUser = currentUser.equals(profileUser);
        params.put("user", profileUser);
        params.put("defaultAvatarId", this.avatarManager.getDefaultAvatarId(Avatar.Type.USER));
        PropertySet propertySet = this.userPropertyManager.getPropertySet(profileUser);
        if (propertySet.exists("user.avatar.id")) {
            params.put("avatarId", propertySet.getLong("user.avatar.id"));
        } else {
            params.put("avatarId", this.avatarManager.getDefaultAvatarId(Avatar.Type.USER));
        }
        boolean hasCustomUserAvatar = this.avatarService.hasCustomUserAvatar(currentUser, profileUser.getName());
        if (canEditAvatar && currentUserIsProfileUser && !hasCustomUserAvatar) {
            params.put("avatarSrc", String.format("%s/images/icons/ico_add_avatar.png", this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl()));
        } else {
            params.put("avatarSrc", this.avatarService.getAvatarURL(currentUser, profileUser.getName(), Avatar.Size.LARGE));
        }
        params.put("displayEdit", this.displayEdit(profileUser, currentUser));
        boolean isAdmin = this.isAdmin(currentUser);
        params.put("isAdmin", isAdmin);
        params.put("displayChangePassword", this.displayChangePassword(profileUser, currentUser));
        params.put("displayRememberMe", this.displayRememberMe(profileUser, currentUser));
        if (this.emailFormatter.emailVisible(currentUser)) {
            params.put("email", this.emailFormatter.formatEmailAsLink(profileUser.getEmailAddress(), currentUser));
        }
        if (!(groups = this.getGroups(profileUser, currentUser)).isEmpty()) {
            params.put("groups", groups);
        }
        params.put("userProperties", this.getUserProperties(profileUser, isAdmin));
        return params;
    }

    public String getBaseUrl() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
    }

    @Override
    public String getId() {
        return "details-profile-fragment";
    }

    private boolean displayEdit(User profileUser, User currentUser) {
        if (this.userManager.canUpdateUser(profileUser)) {
            return profileUser.equals(currentUser);
        }
        return false;
    }

    private boolean displayChangePassword(User profileUser, User currentUser) {
        if (this.userManager.canUpdateUserPassword(profileUser)) {
            return profileUser.equals(currentUser);
        }
        return false;
    }

    private Object displayRememberMe(User profileUser, User currentUser) {
        return profileUser.equals(currentUser);
    }

    private List<String> getGroups(User profileUser, User currentUser) {
        ArrayList<String> groups = new ArrayList<String>();
        for (String group : this.getGroupsForUser(profileUser.getName())) {
            if (!this.groupPermissionChecker.hasViewGroupPermission(group, currentUser)) continue;
            groups.add(group);
        }
        return groups;
    }

    private boolean isAdmin(User currentUser) {
        return this.permissionManager.hasPermission(0, currentUser);
    }

    private Map<String, String> getUserProperties(User profileUser, boolean isAdmin) {
        HashMap<String, String> userProperties = new HashMap<String, String>();
        if (profileUser != null && isAdmin) {
            PropertySet userPropertySet = this.userPropertyManager.getPropertySet(profileUser);
            for (String key : userPropertySet.getKeys(5)) {
                if (!key.startsWith("jira.meta.")) continue;
                userProperties.put(key.substring("jira.meta.".length()), userPropertySet.getString(key));
            }
        }
        return userProperties;
    }

    private Iterable<String> getGroupsForUser(String userName) {
        MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(userName).returningAtMost(-1);
        return this.crowdService.search((Query)membershipQuery);
    }

    public class Context {
        @Nonnull
        private final User profileUser;
        private final User currentUser;

        public Context(User profileUser, User currentUser) {
            this.profileUser = (User)Preconditions.checkNotNull((Object)profileUser);
            this.currentUser = currentUser;
        }

        public boolean isGravatarEnabled() {
            return DetailsUserProfileFragment.this.avatarService.isGravatarEnabled();
        }

        public boolean isUseSSL() {
            VelocityRequestContext requestContext = DetailsUserProfileFragment.this.velocityRequestContextFactory.getJiraVelocityRequestContext();
            return requestContext != null && requestContext.getCanonicalBaseUrl().startsWith("https://");
        }

        public boolean isCanEditAvatar() {
            return DetailsUserProfileFragment.this.avatarService.canSetCustomUserAvatar(this.currentUser, this.profileUser.getName());
        }

        public boolean isDisplayGravatarHelpText() {
            return this.isGravatarEnabled() && this.profileUser.equals(this.currentUser);
        }

        private String getUserEmail() {
            return this.profileUser.equals(this.currentUser) ? this.currentUser.getEmailAddress() : "";
        }

        public String getUserEmailHtml() {
            return TextUtils.htmlEncode((String)this.getUserEmail());
        }

        public String getUserEmailAsURL() {
            try {
                return URLEncoder.encode(this.getUserEmail(), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                return "";
            }
        }

        public String getUserEmailMD5() {
            return MD5Util.md5Hex(this.getUserEmail());
        }
    }
}

