/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.OfBizUserHistoryStore;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryStore;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.collect.LRUMap;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.Function;
import com.atlassian.util.concurrent.ManagedLock;
import com.atlassian.util.concurrent.ManagedLocks;
import com.atlassian.util.concurrent.Nullable;
import com.atlassian.util.concurrent.Supplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.log4j.Logger;

@EventComponent
public class CachingUserHistoryStore
implements UserHistoryStore {
    private static final int DEFAULT_MAX_THRESHOLD = 10;
    private static final int DEFAULT_MAX_ITEMS = 20;
    private static final Logger log = Logger.getLogger(CachingUserHistoryStore.class);
    private final Function<ApplicationUser, ManagedLock> lockManager = ManagedLocks.weakManagedLockFactory((Function)new Function<ApplicationUser, String>(){

        public String get(ApplicationUser input) {
            return input.getKey();
        }
    });
    private final OfBizUserHistoryStore delegatingStore;
    private final ApplicationProperties applicationProperties;
    private final Cache cache = new Cache();
    private final int maxThreshold;

    public CachingUserHistoryStore(@NotNull OfBizUserHistoryStore delegatingStore, @NotNull ApplicationProperties applicationProperties) {
        this(delegatingStore, applicationProperties, 10);
    }

    CachingUserHistoryStore(@NotNull OfBizUserHistoryStore delegatingStore, @NotNull ApplicationProperties applicationProperties, int maxThreshold) {
        this.delegatingStore = (OfBizUserHistoryStore)Assertions.notNull((String)"delegatingStore", (Object)delegatingStore);
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        this.maxThreshold = maxThreshold;
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.clear();
    }

    @Override
    public void addHistoryItem(final @NotNull ApplicationUser user, final @NotNull UserHistoryItem historyItem) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"historyItem", (Object)historyItem);
        ((ManagedLock)this.lockManager.get((Object)user)).withLock(new Runnable(){

            @Override
            public void run() {
                UserHistoryItem.Type type = historyItem.getType();
                List<UserHistoryItem> history = CachingUserHistoryStore.this.cache.get(new Key(user, type));
                int index = CachingUserHistoryStore.this.getIndexOfHistoryItem(history, historyItem);
                if (index == -1) {
                    history.add(0, historyItem);
                    CachingUserHistoryStore.this.delegatingStore.addHistoryItemNoChecks(user, historyItem);
                    int maxItems = CachingUserHistoryStore.getMaxItems(historyItem.getType(), CachingUserHistoryStore.this.applicationProperties);
                    if (history.size() > maxItems + CachingUserHistoryStore.this.maxThreshold) {
                        ArrayList<String> entitiesToDelete = new ArrayList<String>();
                        while (history.size() > maxItems) {
                            UserHistoryItem item = history.remove(maxItems);
                            entitiesToDelete.add(item.getEntityId());
                        }
                        CachingUserHistoryStore.this.delegatingStore.expireOldHistoryItems(user, type, entitiesToDelete);
                    }
                } else {
                    history.remove(index);
                    history.add(0, historyItem);
                    CachingUserHistoryStore.this.delegatingStore.updateHistoryItemNoChecks(user, historyItem);
                }
            }
        });
    }

    private int getIndexOfHistoryItem(@Nullable List<UserHistoryItem> history, @Nullable UserHistoryItem historyItem) {
        if (history != null) {
            for (int i = 0; i < history.size(); ++i) {
                UserHistoryItem currentHistoryItem = history.get(i);
                if (!currentHistoryItem.getEntityId().equals(historyItem.getEntityId()) || !currentHistoryItem.getType().equals((Object)historyItem.getType())) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    @NotNull
    public List<UserHistoryItem> getHistory(final @NotNull UserHistoryItem.Type type, final @NotNull ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"type", (Object)type);
        return (List)((ManagedLock)this.lockManager.get((Object)user)).withLock((Supplier)new Supplier<List<UserHistoryItem>>(){

            public List<UserHistoryItem> get() {
                return Collections.unmodifiableList(CachingUserHistoryStore.this.cache.get(new Key(user, type)));
            }
        });
    }

    @Override
    public Set<UserHistoryItem.Type> removeHistoryForUser(final @NotNull ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        return (Set)((ManagedLock)this.lockManager.get((Object)user)).withLock((Supplier)new Supplier<Set<UserHistoryItem.Type>>(){

            public Set<UserHistoryItem.Type> get() {
                Set<UserHistoryItem.Type> typesRemoved = CachingUserHistoryStore.this.delegatingStore.removeHistoryForUser(user);
                for (UserHistoryItem.Type type : typesRemoved) {
                    CachingUserHistoryStore.this.flushCache(type, user);
                }
                return Collections.unmodifiableSet(typesRemoved);
            }
        });
    }

    private void flushCache(UserHistoryItem.Type type, ApplicationUser user) {
        this.cache.remove(new Key(user, type));
    }

    public static int getMaxItems(UserHistoryItem.Type type, ApplicationProperties applicationProperties) {
        String maxItemsForTypeStr = applicationProperties.getDefaultBackedString("jira.max." + type.getName() + ".history.items");
        int maxItems = 20;
        try {
            if (StringUtils.isNotBlank((String)maxItemsForTypeStr)) {
                return Integer.parseInt(maxItemsForTypeStr);
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Incorrect format of property 'jira.max." + type.getName() + ".history.items'.  Should be a number."));
        }
        String maxItemsStr = applicationProperties.getDefaultBackedString("jira.max.history.items");
        try {
            if (StringUtils.isNotBlank((String)maxItemsStr)) {
                return Integer.parseInt(maxItemsStr);
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)"Incorrect format of property 'jira.max.history.items'.  Should be a number.");
        }
        return 20;
    }

    private static final class Key {
        private final ApplicationUser user;
        private final UserHistoryItem.Type type;

        public Key(ApplicationUser user, UserHistoryItem.Type type) {
            Assertions.notNull((String)"user", (Object)user);
            Assertions.notNull((String)"type", (Object)type);
            this.user = user;
            this.type = type;
        }

        public String getUserKey() {
            return this.user.getKey();
        }

        public UserHistoryItem.Type getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            Key key = (Key)o;
            if (!this.type.equals((Object)key.type)) {
                return false;
            }
            return this.getUserKey().equals(key.getUserKey());
        }

        public int hashCode() {
            int result = this.getUserKey().hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
        }
    }

    private final class Cache
    implements Function<Key, List<UserHistoryItem>> {
        private final Map<Key, List<UserHistoryItem>> map = LRUMap.synchronizedLRUMap((int)2000);

        private Cache() {
        }

        public List<UserHistoryItem> get(Key key) {
            if (!this.map.containsKey(key)) {
                List<UserHistoryItem> history = CachingUserHistoryStore.this.delegatingStore.getHistory(key.type, key.user);
                if (history == null) {
                    history = new CopyOnWriteArrayList<UserHistoryItem>();
                }
                this.map.put(key, history);
            }
            return this.map.get(key);
        }

        public void remove(Key key) {
            this.map.remove(key);
        }

        public void clear() {
            this.map.clear();
        }
    }
}

