/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class UpgradeTask_Build317
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build317.class);
    private static final String DEFAULT_ATTACHMENT_SIZE = "10485760";
    private static final String DEFAULT_WEBWORK_PROPERTIES = "webwork.properties";

    public UpgradeTask_Build317() {
        super(false);
    }

    @Override
    public String getBuildNumber() {
        return "317";
    }

    @Override
    public String getShortDescription() {
        return "Set application property 'webwork.multipart.maxSize' to default value if not set or invalid value";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Properties properties = this.getWebworkProperties();
        if (properties == null) {
            this.setAttachmentSizeToDefaultValue();
            return;
        }
        String attachmentSize = properties.getProperty("webwork.multipart.maxSize");
        if (!TextUtils.stringSet((String)attachmentSize)) {
            log.warn((Object)("'webwork.multipart.maxSize' property value is not set. Using default value: '" + this.getDefaultValue() + "'"));
            this.setAttachmentSizeToDefaultValue();
        } else {
            try {
                int size = Integer.parseInt(attachmentSize);
                if (size < 0) {
                    log.warn((Object)("'webwork.multipart.maxSize' property value '" + attachmentSize + "' is not a positive number. Using default value: '" + this.getDefaultValue() + "'"));
                    this.setAttachmentSizeToDefaultValue();
                } else {
                    this.setAttachmentSizeToValue(attachmentSize);
                }
            }
            catch (NumberFormatException e) {
                log.warn((Object)("'webwork.multipart.maxSize' property value '" + attachmentSize + "' is not a valid number. Using default value: '" + this.getDefaultValue() + "'"));
                this.setAttachmentSizeToDefaultValue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getWebworkProperties() {
        Properties properties = new Properties();
        InputStream in = null;
        try {
            in = ClassLoaderUtils.getResourceAsStream((String)DEFAULT_WEBWORK_PROPERTIES, this.getClass());
            properties.load(in);
        }
        catch (Exception e) {
            log.error((Object)("Could not load webwork properties from 'webwork.properties'.  Using default value for 'webwork.multipart.maxSize' as '" + this.getDefaultValue() + "'"), (Throwable)e);
            Properties properties2 = null;
            return properties2;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Could not close 'webwork.properties' inputStream", (Throwable)e);
            }
        }
        return properties;
    }

    private void setAttachmentSizeToDefaultValue() {
        this.setAttachmentSizeToValue(this.getDefaultValue());
    }

    private void setAttachmentSizeToValue(String value) {
        this.getApplicationProperties().setString("webwork.multipart.maxSize", value);
    }

    private String getDefaultValue() {
        return DEFAULT_ATTACHMENT_SIZE;
    }
}

