/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.studio.startup;

import com.atlassian.jira.studio.startup.Locator;
import com.atlassian.jira.studio.startup.StudioStartupHooks;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

class ServiceLocator
implements Locator {
    private static final Logger log = Logger.getLogger(ServiceLocator.class);

    ServiceLocator() {
    }

    @Override
    public StudioStartupHooks locate(@Nonnull ClassLoader loader) {
        try {
            ServiceLoader<StudioStartupHooks> locator = ServiceLoader.load(StudioStartupHooks.class, loader);
            Iterator<StudioStartupHooks> iter = locator.iterator();
            if (iter.hasNext()) {
                StudioStartupHooks factory = iter.next();
                if (iter.hasNext()) {
                    log.warn((Object)("Found more than one StudioStartupHooks. Using '" + factory.getClass().getName() + "'."));
                }
                return factory;
            }
        }
        catch (ServiceConfigurationError e) {
            log.warn((Object)"Error occured while looking for a StudioStartupHooks.", (Throwable)e);
        }
        return null;
    }
}

