/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.setting;

import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;

public class GzipCompression {
    private final ApplicationProperties applicationProperties;
    private final FeatureManager featureManager;

    public GzipCompression(ApplicationProperties applicationProperties, FeatureManager featureManager) {
        this.applicationProperties = applicationProperties;
        this.featureManager = featureManager;
    }

    public boolean isEnabled() {
        return !this.featureManager.isEnabled(CoreFeatures.ON_DEMAND) && this.applicationProperties.getOption("jira.option.web.usegzip");
    }

    public boolean isSettableBy() {
        return !this.featureManager.isEnabled(CoreFeatures.ON_DEMAND);
    }

    public void set(boolean useGzipCompression) {
        if (this.isSettableBy()) {
            this.applicationProperties.setOption("jira.option.web.usegzip", useGzipCompression);
        }
    }
}

