/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.type.SimpleIssueFieldSecurityType;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;

public class CurrentAssignee
extends SimpleIssueFieldSecurityType {
    public static final String DESC = "assignee";
    private JiraAuthenticationContext authenticationContext;

    public CurrentAssignee(JiraAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    @Override
    public String getDisplayName() {
        return this.authenticationContext.getI18nHelper().getText("admin.permission.types.current.assignee");
    }

    @Override
    public String getType() {
        return DESC;
    }

    @Override
    public void doValidation(String key, Map parameters, JiraServiceContext jiraServiceContext) {
    }

    @Override
    protected String getFieldName(String parameter) {
        return "issue_assignee";
    }

    @Override
    protected boolean hasProjectPermission(User user, boolean issueCreation, GenericValue project) {
        return !issueCreation;
    }

    @Override
    protected boolean hasProjectPermission(User user, boolean issueCreation, Project project) {
        return !issueCreation;
    }

    @Override
    protected String getField() {
        return DESC;
    }

    @Override
    protected String getFieldValue(Issue issue) {
        return issue.getAssigneeId();
    }

    @Override
    public Set<User> getUsers(PermissionContext ctx, String ignored) {
        HashSet<User> result = new HashSet<User>(1);
        if (ctx.getIssue() != null && ctx.getIssue().getAssignee() != null) {
            result.add(ctx.getIssue().getAssignee());
        }
        return result;
    }
}

