/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.groups;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.jira.security.groups.GroupManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class DefaultGroupManager
implements GroupManager {
    private final CrowdService crowdService;

    public DefaultGroupManager(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public Collection<Group> getAllGroups() {
        NullRestriction restriction = NullRestrictionImpl.INSTANCE;
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)restriction, 0, -1);
        return this.convertIterableToCollection(this.crowdService.search((Query)query));
    }

    public boolean groupExists(String groupName) {
        return this.getGroup(groupName) != null;
    }

    public Group createGroup(String groupName) throws OperationNotPermittedException, InvalidGroupException {
        return this.crowdService.addGroup((Group)new ImmutableGroup(groupName));
    }

    public Group getGroup(String groupName) {
        return this.crowdService.getGroup(groupName);
    }

    public Group getGroupObject(String groupName) {
        return this.getGroup(groupName);
    }

    public boolean isUserInGroup(String username, String groupname) {
        if (username == null || groupname == null) {
            return false;
        }
        return this.crowdService.isUserMemberOfGroup(username, groupname);
    }

    public boolean isUserInGroup(User user, Group group) {
        if (user == null || group == null) {
            return false;
        }
        return this.crowdService.isUserMemberOfGroup(user, group);
    }

    public Collection<User> getUsersInGroup(String groupName) {
        Iterable usersIterable = this.crowdService.search((Query)QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1));
        return this.convertIterableToCollection(usersIterable);
    }

    public Collection<User> getUsersInGroup(Group group) {
        return this.getUsersInGroup(group.getName());
    }

    public Collection<String> getUserNamesInGroup(Group group) {
        return this.getUserNamesInGroup(group.getName());
    }

    public Collection<String> getUserNamesInGroup(String groupName) {
        Iterable usersIterable = this.crowdService.search((Query)QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1));
        return this.convertIterableToCollection(usersIterable);
    }

    public Collection<User> getDirectUsersInGroup(Group group) {
        Collection<User> usersInGroup = this.getUsersInGroup(group.getName());
        Iterator<User> iter = usersInGroup.iterator();
        while (iter.hasNext()) {
            if (this.crowdService.isUserDirectGroupMember(iter.next(), group)) continue;
            iter.remove();
        }
        return usersInGroup;
    }

    public Collection<Group> getGroupsForUser(String userName) {
        Iterable searchResults = this.crowdService.search((Query)QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(userName).returningAtMost(-1));
        return this.convertIterableToCollection(searchResults);
    }

    public Collection<Group> getGroupsForUser(User user) {
        return this.getGroupsForUser(user.getName());
    }

    public Collection<String> getGroupNamesForUser(String userName) {
        Iterable usersIterable = this.crowdService.search((Query)QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(userName).returningAtMost(-1));
        return this.convertIterableToCollection(usersIterable);
    }

    public Collection<String> getGroupNamesForUser(User user) {
        return this.getGroupNamesForUser(user.getName());
    }

    private <T> Collection<T> convertIterableToCollection(Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return (Collection)iterable;
        }
        ArrayList<T> collection = new ArrayList<T>();
        for (T member : iterable) {
            collection.add(member);
        }
        return collection;
    }

    public void addUserToGroup(User user, Group group) throws GroupNotFoundException, UserNotFoundException, OperationNotPermittedException, OperationFailedException {
        this.crowdService.addUserToGroup(user, group);
    }
}

