/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.trustedapps;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.security.auth.trustedapps.SimpleTrustedApplication;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationUtil;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.security.auth.trustedapps.IPAddressFormatException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;

public class TrustedApplicationSyntacticValidator
implements TrustedApplicationValidator {
    public boolean validate(JiraServiceContext context, I18nHelper helper, String urlString) {
        Assertions.notNull((String)"context", (Object)context);
        Assertions.notNull((String)"i18nHelper", (Object)helper);
        if (StringUtils.isBlank((String)urlString)) {
            context.getErrorCollection().addError("trustedAppBaseUrl", helper.getText("URL must not be empty."));
        } else {
            try {
                new URL(urlString);
                new URI(urlString);
            }
            catch (MalformedURLException e) {
                context.getErrorCollection().addError("trustedAppBaseUrl", e.toString());
            }
            catch (URISyntaxException e) {
                context.getErrorCollection().addError("trustedAppBaseUrl", e.toString());
            }
        }
        return !context.getErrorCollection().hasAnyErrors();
    }

    @Override
    public boolean validate(JiraServiceContext context, I18nHelper helper, SimpleTrustedApplication application) {
        Assertions.notNull((String)"context", (Object)context);
        Assertions.notNull((String)"application", (Object)application);
        Assertions.notNull((String)"helper", (Object)helper);
        if (StringUtils.isBlank((String)application.getApplicationId())) {
            context.getErrorCollection().addError("applicationId", helper.getText("admin.trustedapps.edit.application.id.blank"));
        }
        if (StringUtils.isBlank((String)application.getName())) {
            context.getErrorCollection().addError("name", helper.getText("admin.trustedapps.edit.name.blank"));
        }
        if (application.getTimeout() <= 0L) {
            context.getErrorCollection().addError("timeout", helper.getText("admin.trustedapps.edit.timeout.too.small"));
        }
        if (StringUtils.isBlank((String)application.getPublicKey())) {
            context.getErrorCollection().addErrorMessage(helper.getText("admin.trustedapps.edit.public.key.blank"));
        }
        if (StringUtils.isBlank((String)application.getIpMatch())) {
            context.getErrorCollection().addError("ipMatch", helper.getText("admin.trustedapps.edit.ipmatch.empty"));
        } else {
            try {
                TrustedApplicationUtil.getIPMatcher(application.getIpMatch());
            }
            catch (IPAddressFormatException ex) {
                context.getErrorCollection().addError("ipMatch", helper.getText("admin.trustedapps.edit.ipmatch.invalid", ex.getBadIPAddress()));
            }
        }
        if (StringUtils.isBlank((String)application.getUrlMatch())) {
            context.getErrorCollection().addError("urlMatch", helper.getText("admin.trustedapps.edit.urlmatch.empty"));
        }
        return !context.getErrorCollection().hasAnyErrors();
    }

    static final class Fields {
        static final String NAME = "name";
        static final String TIMEOUT = "timeout";
        static final String APPLICATION_ID = "applicationId";
        static final String IP_MATCH = "ipMatch";
        static final String URL_MATCH = "urlMatch";
        static final String BASE_URL = "trustedAppBaseUrl";

        Fields() {
        }
    }
}

