/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.WorkflowPermissionFactory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.security.PermissionsCache;
import com.atlassian.jira.security.WorkflowBasedPermissionManager;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Collection;
import org.apache.log4j.Logger;

public class ThreadLocalCachingPermissionManager
extends WorkflowBasedPermissionManager {
    private static final Logger log = Logger.getLogger(ThreadLocalCachingPermissionManager.class);
    private final ProjectFactory projectFactory;

    public ThreadLocalCachingPermissionManager(WorkflowPermissionFactory workflowPermissionFactory, PermissionContextFactory permissionContextFactory, ProjectFactory projectFactory) {
        super(workflowPermissionFactory, permissionContextFactory);
        this.projectFactory = projectFactory;
    }

    @Override
    @SuppressWarnings(value={"NM_WRONG_PACKAGE"}, justification="OSUser is deprecated and dying anyway. Plus the method in question is final so we can't override it.")
    public Collection<Project> getProjectObjects(int permissionId, User user) {
        if (10 == permissionId) {
            PermissionsCache cache = this.getCache();
            Collection<Project> cachedProjects = cache.getProjectObjectsWithBrowsePermission(user);
            if (cachedProjects != null) {
                return cachedProjects;
            }
            cache.setProjectObjectsWithBrowsePermission(user, super.getProjectObjects(permissionId, user));
            return cache.getProjectObjectsWithBrowsePermission(user);
        }
        return super.getProjectObjects(permissionId, user);
    }

    private PermissionsCache getCache() {
        PermissionsCache cache = (PermissionsCache)JiraAuthenticationContextImpl.getRequestCache().get("jira.permissions.cache");
        if (cache == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating new PermissionsCache");
            }
            cache = new PermissionsCache(this.projectFactory);
            JiraAuthenticationContextImpl.getRequestCache().put("jira.permissions.cache", cache);
        }
        return cache;
    }
}

