/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.studio;

import com.atlassian.jira.plugin.studio.RemoteProjectsBuilder;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class RemoteProjects {
    public static final RemoteProjects NO_REMOTE_PROJECTS = new RemoteProjectsBuilder().createRemoteProjects();
    private static final String CONFLUENCE_JSON_KEY = "confluence";
    private static final String FISHEYE_JSON_KEY = "fisheye";
    private static final String CRUCIBLE_JSON_KEY = "crucible";
    private static final String BAMBOO_JSON_KEY = "bamboo";
    private final String bambooLink;
    private final String confluenceLink;
    private final String fishEyeLink;
    private final String crucibleLink;

    public RemoteProjects(@Nullable String bambooLink, @Nullable String confluenceLink, @Nullable String fishEyeLink, @Nullable String crucibleLink) {
        this.bambooLink = bambooLink;
        this.confluenceLink = confluenceLink;
        this.fishEyeLink = fishEyeLink;
        this.crucibleLink = crucibleLink;
    }

    @Nonnull
    public static RemoteProjects deserialize(@Nonnull String content) throws JSONException {
        JSONObject jsonObject = new JSONObject(content);
        return new RemoteProjectsBuilder().setConfluenceLink(jsonObject.optString(CONFLUENCE_JSON_KEY)).setFishEyeLink(jsonObject.optString(FISHEYE_JSON_KEY)).setCrucibleLink(jsonObject.optString(CRUCIBLE_JSON_KEY)).setBambooLink(jsonObject.optString(BAMBOO_JSON_KEY)).createRemoteProjects();
    }

    @Nonnull
    public String serialize() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(CONFLUENCE_JSON_KEY, (Object)this.getConfluenceLink());
        jsonObject.put(FISHEYE_JSON_KEY, (Object)this.getFishEyeLink());
        jsonObject.put(CRUCIBLE_JSON_KEY, (Object)this.getCrucibleLink());
        jsonObject.put(BAMBOO_JSON_KEY, (Object)this.getBambooLink());
        return jsonObject.toString();
    }

    public boolean hasBamboo() {
        return !Strings.isNullOrEmpty((String)this.bambooLink);
    }

    public String getBambooLink() {
        return this.bambooLink;
    }

    public boolean hasConfluence() {
        return !Strings.isNullOrEmpty((String)this.confluenceLink);
    }

    public String getConfluenceLink() {
        return this.confluenceLink;
    }

    public boolean hasFishEye() {
        return !Strings.isNullOrEmpty((String)this.fishEyeLink);
    }

    public String getFishEyeLink() {
        return this.fishEyeLink;
    }

    public boolean hasCrucible() {
        return !Strings.isNullOrEmpty((String)this.crucibleLink);
    }

    public String getCrucibleLink() {
        return this.crucibleLink;
    }

    public String toString() {
        return "RemoteProjects{bambooLink='" + this.bambooLink + '\'' + ", confluenceLink='" + this.confluenceLink + '\'' + ", fishEyeLink='" + this.fishEyeLink + '\'' + ", crucibleLink='" + this.crucibleLink + '\'' + '}';
    }
}

