/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.ActualValueEqualityQueryFactory;
import com.atlassian.jira.jql.query.ActualValueRelationalQueryFactory;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.GenericClauseQueryFactory;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.util.IndexValueConverter;
import com.atlassian.jira.jql.util.WatchesIndexValueConverter;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.query.clause.TerminalClause;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

@InjectableComponent
public class WatchesClauseQueryFactory
implements ClauseQueryFactory {
    private static final Logger log = Logger.getLogger(WatchesClauseQueryFactory.class);
    private final ClauseQueryFactory delegateClauseQueryFactory;
    private final WatcherManager watcherManager;

    public WatchesClauseQueryFactory(JqlOperandResolver operandResolver, WatchesIndexValueConverter watchesIndexValueConverter, WatcherManager watcherManager) {
        this.watcherManager = watcherManager;
        ArrayList<OperatorSpecificQueryFactory> operatorFactories = new ArrayList<OperatorSpecificQueryFactory>();
        operatorFactories.add((OperatorSpecificQueryFactory)new ActualValueEqualityQueryFactory((IndexValueConverter)watchesIndexValueConverter));
        operatorFactories.add((OperatorSpecificQueryFactory)new ActualValueRelationalQueryFactory((IndexValueConverter)watchesIndexValueConverter));
        this.delegateClauseQueryFactory = this.createGenericClauseFactory(operandResolver, operatorFactories);
    }

    public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        if (this.watcherManager.isWatchingEnabled()) {
            return this.delegateClauseQueryFactory.getQuery(queryCreationContext, terminalClause);
        }
        log.debug((Object)"Attempt to search watches field when voting is disabled.");
        return QueryFactoryResult.createFalseResult();
    }

    GenericClauseQueryFactory createGenericClauseFactory(JqlOperandResolver operandResolver, List<OperatorSpecificQueryFactory> operatorFactories) {
        return new GenericClauseQueryFactory(SystemSearchConstants.forWatches().getIndexField(), operatorFactories, operandResolver);
    }
}

