/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.project;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.jelly.ProjectContextAccessor;
import com.atlassian.jira.jelly.ProjectContextAccessorImpl;
import com.atlassian.jira.jelly.tag.ProjectAwareActionTagSupport;
import com.atlassian.jira.project.version.VersionManager;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class AddVersion
extends ProjectAwareActionTagSupport
implements ProjectContextAccessor {
    private static final transient Logger log = Logger.getLogger(AddVersion.class);
    private static final String KEY_PROJECT_ID = "pid";
    private static final String KEY_VERSION_ID_VAR = "versionIdVar";
    private final ProjectContextAccessor projectContextAccessor = new ProjectContextAccessorImpl((Tag)this);
    private String versionIdVar;

    public AddVersion() {
        this.setActionName("AddVersion");
    }

    @Override
    protected void preContextValidation() {
        String PROJECT_KEY = "project-key";
        if (this.getProperties().containsKey("project-key")) {
            this.setProject(this.getProperty("project-key"));
        }
    }

    @Override
    protected void prePropertyValidation(XMLOutput output) throws JellyTagException {
        if (this.hasProject()) {
            this.setProperty(KEY_PROJECT_ID, this.getProjectId().toString());
        }
    }

    @Override
    protected void postTagExecution(XMLOutput output) throws JellyTagException {
        if (StringUtils.isNotEmpty((String)this.getProperty(KEY_VERSION_ID_VAR))) {
            VersionManager vm = ComponentAccessor.getVersionManager();
            Long createdVersionId = vm.getVersion(this.getProjectId(), this.getProperty("name")).getId();
            this.getContext().setVariable(this.getProperty(KEY_VERSION_ID_VAR), (Object)createdVersionId);
        }
    }

    @Override
    protected void endTagExecution(XMLOutput output) {
        this.loadPreviousProject();
    }

    @Override
    public String[] getRequiredProperties() {
        return new String[]{KEY_PROJECT_ID};
    }

    @Override
    public String[] getRequiredContextVariablesAfter() {
        return new String[0];
    }

    @Override
    public void setProject(Long projectId) {
        this.projectContextAccessor.setProject(projectId);
    }

    @Override
    public void setProject(String projectKey) {
        this.projectContextAccessor.setProject(projectKey);
    }

    @Override
    public void setProject(GenericValue projectKey) {
        this.projectContextAccessor.setProject(projectKey);
    }

    @Override
    public void loadPreviousProject() {
        this.projectContextAccessor.loadPreviousProject();
    }

    public String getVersionIdVar() {
        return this.versionIdVar;
    }

    public void setVersionIdVar(String versionIdVar) {
        this.versionIdVar = versionIdVar;
    }
}

