/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.views;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.util.AggregateTimeTrackingBean;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculatorFactory;
import com.atlassian.jira.issue.views.util.IssueViewUtil;
import com.atlassian.jira.issue.views.util.RssViewUtils;
import com.atlassian.jira.plugin.customfield.CustomFieldTypeModuleDescriptor;
import com.atlassian.jira.plugin.issueview.AbstractIssueView;
import com.atlassian.jira.plugin.issueview.IssueViewFieldParams;
import com.atlassian.jira.plugin.issueview.IssueViewRequestParams;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.RequestContextParameterHolder;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.web.bean.CustomIssueXMLViewFieldsBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class IssueXMLView
extends AbstractIssueView {
    private static final Logger log = Logger.getLogger(IssueXMLView.class);
    private static final String RSS_MODE_RENDERED = "rendered";
    private static final String RSS_MODE_RAW = "raw";
    private final JiraAuthenticationContext authenticationContext;
    private final ApplicationProperties applicationProperties;
    private final FieldLayoutManager fieldLayoutManager;
    private final CommentManager commentManager;
    private final IssueViewUtil issueViewUtil;
    private final AggregateTimeTrackingCalculatorFactory aggregateTimeTrackingCalculatorFactory;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final BuildUtilsInfo buildUtilsInfo;

    public IssueXMLView(JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, FieldLayoutManager fieldLayoutManager, CommentManager commentManager, IssueViewUtil issueViewUtil, AggregateTimeTrackingCalculatorFactory aggregateTimeTrackingCalculatorFactory, BuildUtilsInfo buildUtilsInfo, DateTimeFormatterFactory dateTimeFormatterFactory) {
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
        this.fieldLayoutManager = fieldLayoutManager;
        this.commentManager = commentManager;
        this.issueViewUtil = issueViewUtil;
        this.aggregateTimeTrackingCalculatorFactory = aggregateTimeTrackingCalculatorFactory;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
    }

    @Override
    public String getContent(Issue issue, IssueViewRequestParams issueViewRequestParams) {
        String header = this.getHeader(issueViewRequestParams);
        String body = this.getBody(issue, issueViewRequestParams);
        String footer = this.getFooter();
        return header + body + footer;
    }

    private String getFooter() {
        return this.descriptor.getHtml("footer", Collections.emptyMap());
    }

    private String getHeader(IssueViewRequestParams issueViewRequestParams) {
        String requestURL;
        Map<String, Object> headerParams = JiraVelocityUtils.getDefaultVelocityParams(this.authenticationContext);
        headerParams.put("title", this.applicationProperties.getString("jira.title"));
        headerParams.put("buildInfo", this.buildUtilsInfo.getBuildInformation());
        headerParams.put("currentDate", new Date());
        headerParams.put("rssLocale", RssViewUtils.getRssLocale(this.authenticationContext.getLocale()));
        headerParams.put("version", this.buildUtilsInfo.getVersion());
        headerParams.put("buildNumber", this.buildUtilsInfo.getCurrentBuildNumber());
        headerParams.put("buildDate", new SimpleDateFormat("dd-MM-yyyy").format(this.buildUtilsInfo.getCurrentBuildDate()));
        headerParams.put("customViewRequested", issueViewRequestParams.getIssueViewFieldParams().isCustomViewRequested());
        VelocityRequestContext velocityRequestContext = new DefaultVelocityRequestContextFactory(this.applicationProperties).getJiraVelocityRequestContext();
        RequestContextParameterHolder requestParameters = velocityRequestContext.getRequestParameters();
        if (requestParameters != null && (requestURL = requestParameters.getRequestURL()) != null) {
            String queryString = requestParameters.getQueryString();
            if (queryString != null) {
                headerParams.put("exampleURLPrefix", requestURL + "?" + queryString + "&");
            } else {
                headerParams.put("exampleURLPrefix", requestURL + "?");
            }
        }
        return this.descriptor.getHtml("header", headerParams);
    }

    @Override
    public String getBody(Issue issue, IssueViewRequestParams issueViewRequestParams) {
        AggregateTimeTrackingBean bean;
        Map<String, Object> bodyParams = JiraVelocityUtils.getDefaultVelocityParams(this.authenticationContext);
        bodyParams.put("issue", issue);
        bodyParams.put("i18n", this.authenticationContext.getI18nHelper());
        bodyParams.put("dateTimeFormatter", this.dateTimeFormatterFactory.formatter().forLoggedInUser().withStyle(DateTimeStyle.RSS_RFC822_DATE_TIME));
        bodyParams.put("dateFormatter", this.dateTimeFormatterFactory.formatter().withSystemZone().withStyle(DateTimeStyle.RSS_RFC822_DATE_TIME));
        CustomIssueXMLViewFieldsBean customIssueXmlViewFieldsBean = new CustomIssueXMLViewFieldsBean(issueViewRequestParams.getIssueViewFieldParams(), issue.getProjectObject().getId(), issue.getIssueTypeObject().getId());
        bodyParams.put("issueXmlViewFields", customIssueXmlViewFieldsBean);
        DefaultVelocityRequestContextFactory velocityRequestContextFactory = new DefaultVelocityRequestContextFactory(this.applicationProperties);
        VelocityRequestContext velocityRequestContext = velocityRequestContextFactory.getJiraVelocityRequestContext();
        String rssMode = velocityRequestContext.getRequestParameter("rssMode");
        if (StringUtils.isNotEmpty((String)rssMode) && RSS_MODE_RAW.equals(rssMode)) {
            bodyParams.put("rssMode", RSS_MODE_RAW);
        } else {
            if (StringUtils.isNotEmpty((String)rssMode)) {
                log.warn((Object)("Invalid rssMode parameter specified '" + rssMode + "'.  Currently only supports '" + RSS_MODE_RAW + "'"));
            }
            bodyParams.put("rssMode", RSS_MODE_RENDERED);
        }
        bodyParams.put("votingEnabled", this.applicationProperties.getOption("jira.option.voting"));
        bodyParams.put("watchingEnabled", this.applicationProperties.getOption("jira.option.watching"));
        bodyParams.put("xmlView", this);
        User user = this.authenticationContext.getLoggedInUser();
        bodyParams.put("remoteUser", user);
        bodyParams.put("linkingEnabled", this.applicationProperties.getOption("jira.option.issuelinking"));
        if (customIssueXmlViewFieldsBean.isFieldRequestedAndVisible("issuelinks")) {
            bodyParams.put("linkCollection", this.issueViewUtil.getLinkCollection(issue, user));
        }
        if (customIssueXmlViewFieldsBean.isFieldRequestedAndVisible("comment")) {
            List comments = this.commentManager.getCommentsForUser(issue, user);
            if (this.applicationProperties.getDefaultBackedString("jira.issue.actions.order").equals("desc")) {
                Collections.reverse(comments);
            }
            bodyParams.put("comments", comments);
        }
        boolean timeTrackingEnabled = this.applicationProperties.getOption("jira.option.timetracking");
        boolean subTasksEnabled = this.applicationProperties.getOption("jira.option.allowsubtasks");
        bodyParams.put("timeTrackingEnabled", timeTrackingEnabled);
        if (timeTrackingEnabled && subTasksEnabled && !issue.isSubTask() && (bean = this.aggregateTimeTrackingCalculatorFactory.getCalculator(issue).getAggregates(issue)).getSubTaskCount() > 0) {
            bodyParams.put("aggregateTimeTrackingBean", bean);
        }
        List<FieldLayoutItem> customFields = this.getVisibleCustomFields(issue, user, issueViewRequestParams.getIssueViewFieldParams());
        bodyParams.put("visibleCustomFields", customFields);
        return this.descriptor.getHtml("view", bodyParams);
    }

    public String getRenderedContent(String fieldName, String value, Issue issue) {
        return this.issueViewUtil.getRenderedContent(fieldName, value, issue);
    }

    public String getPrettyDuration(Long v) {
        return this.issueViewUtil.getPrettyDuration(v);
    }

    public List<FieldLayoutItem> getVisibleCustomFields(Issue issue, User user, IssueViewFieldParams issueViewFieldParams) {
        ArrayList<FieldLayoutItem> customFields;
        String issueTypeId = issue.getIssueTypeObject().getId();
        FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(issue);
        ArrayList<FieldLayoutItem> result = customFields = fieldLayout.getVisibleCustomFieldLayoutItems(issue.getProjectObject(), EasyList.build((Object)issueTypeId));
        if (issueViewFieldParams != null && !issueViewFieldParams.isAllCustomFields() && issueViewFieldParams.isCustomViewRequested()) {
            ArrayList<FieldLayoutItem> requestedCustomFields = new ArrayList<FieldLayoutItem>();
            for (FieldLayoutItem customField : customFields) {
                if (!issueViewFieldParams.getCustomFieldIds().contains(customField.getOrderableField().getId())) continue;
                requestedCustomFields.add(customField);
            }
            result = requestedCustomFields;
        }
        result = new ArrayList<FieldLayoutItem>(result);
        Collections.sort(result);
        return result;
    }

    public String getCustomFieldXML(CustomField field, Issue issue) {
        FieldLayoutItem fieldLayoutItem = this.fieldLayoutManager.getFieldLayout(issue).getFieldLayoutItem((OrderableField)field);
        CustomFieldTypeModuleDescriptor moduleDescriptor = field.getCustomFieldType().getDescriptor();
        if (moduleDescriptor.isXMLTemplateExists()) {
            String xmlValue = moduleDescriptor.getViewXML(field, issue, fieldLayoutItem, false);
            if (xmlValue != null) {
                return xmlValue;
            }
            log.info((Object)("No XML data has been defined for the customfield [" + field.getId() + "]"));
        }
        return "";
    }
}

