/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.transitions;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.webfragment.SimpleLinkFactory;
import com.atlassian.jira.plugin.webfragment.descriptors.SimpleLinkFactoryModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkImpl;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import webwork.action.ActionContext;

public class TransitionLinkFactory
implements SimpleLinkFactory {
    private static final Logger log = Logger.getLogger(TransitionLinkFactory.class);
    private final VelocityRequestContextFactory requestContextFactory;
    private final IssueWorkflowManager issueWorkflowManager;

    public TransitionLinkFactory(VelocityRequestContextFactory requestContextFactory, IssueWorkflowManager issueWorkflowManager) {
        this.requestContextFactory = requestContextFactory;
        this.issueWorkflowManager = issueWorkflowManager;
    }

    public void init(SimpleLinkFactoryModuleDescriptor descriptor) {
    }

    public List<SimpleLink> getLinks(User user, Map<String, Object> params) {
        Issue issue = (Issue)params.get("issue");
        return this.getAvailableActions(user, issue);
    }

    private List<SimpleLink> getAvailableActions(User user, Issue issue) {
        VelocityRequestContext requestContext = this.requestContextFactory.getJiraVelocityRequestContext();
        List actions = this.issueWorkflowManager.getSortedAvailableActions(issue);
        ArrayList<SimpleLink> returnList = new ArrayList<SimpleLink>(actions.size());
        for (ActionDescriptor action : actions) {
            String url = requestContext.getBaseUrl() + "/secure/WorkflowUIDispatcher.jspa?" + "id=" + issue.getId() + "" + "&action=" + action.getId() + "&atl_token=" + this.getXsrfToken();
            String transitionDisplayName = this.getWorkflowTransitionDisplayName(action);
            String description = this.getWorkflowTransitionDescription(action);
            returnList.add((SimpleLink)new SimpleLinkImpl("action_id_" + action.getId(), transitionDisplayName, StringUtils.isBlank((String)description) ? null : transitionDisplayName + " - " + description, null, "issueaction-workflow-transition", null, url, null));
        }
        return returnList;
    }

    String getWorkflowTransitionDisplayName(ActionDescriptor descriptor) {
        return WorkflowUtil.getWorkflowTransitionDisplayName((ActionDescriptor)descriptor);
    }

    String getWorkflowTransitionDescription(ActionDescriptor descriptor) {
        return StringUtils.trimToNull((String)WorkflowUtil.getWorkflowTransitionDescription((ActionDescriptor)descriptor));
    }

    String getXsrfToken() {
        HttpServletRequest request = ActionContext.getRequest();
        if (request != null) {
            return this.getXsrfTokenGenerator().generateToken(request);
        }
        return "";
    }

    XsrfTokenGenerator getXsrfTokenGenerator() {
        return ComponentManager.getComponentInstanceOfType(XsrfTokenGenerator.class);
    }
}

