/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.index.DefaultIndexManager;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.validator.FreeTextFieldValidator;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;

public abstract class AbstractSearchInputTransformer
implements SearchInputTransformer {
    protected JqlOperandResolver operandResolver;
    protected final String fieldsKey;
    protected final String urlParam;

    public AbstractSearchInputTransformer(JqlOperandResolver operandResolver, String urlParam, String fieldsKey) {
        this.operandResolver = (JqlOperandResolver)Assertions.notNull((String)"operandResolver", (Object)operandResolver);
        this.urlParam = urlParam;
        this.fieldsKey = fieldsKey;
    }

    protected boolean hasDuplicates(List<TerminalClause> foundChildren) {
        HashSet<String> containsSet = new HashSet<String>();
        for (TerminalClause foundChild : foundChildren) {
            if (containsSet.add(foundChild.getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean hasEmpties(List<TerminalClause> foundChildren) {
        for (TerminalClause foundChild : foundChildren) {
            Operand operand = foundChild.getOperand();
            if (!this.operandResolver.isEmptyOperand(operand)) continue;
            return true;
        }
        return false;
    }

    protected String getValueForField(List<TerminalClause> terminalClauses, User user, String ... jqlClauseNames) {
        return this.getValueForField(terminalClauses, user, Arrays.asList(jqlClauseNames));
    }

    protected String getValueForField(List<TerminalClause> terminalClauses, User user, Collection<String> jqlClauseNames) {
        Operand operand;
        QueryLiteral rawValue;
        TerminalClause theClause = null;
        for (TerminalClause terminalClause : terminalClauses) {
            if (!jqlClauseNames.contains(terminalClause.getName())) continue;
            if (theClause != null) {
                return null;
            }
            theClause = terminalClause;
        }
        if (theClause != null && (rawValue = this.operandResolver.getSingleValue(user, operand = theClause.getOperand(), theClause)) != null && !rawValue.isEmpty()) {
            return rawValue.asString();
        }
        return null;
    }

    public void validateParams(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
        String query = (String)fieldValuesHolder.get((Object)this.urlParam);
        if (StringUtils.isNotBlank((String)query)) {
            String firstLetter = String.valueOf(query.charAt(0));
            if (FreeTextFieldValidator.INVALID_FIRST_CHAR_LIST.contains(firstLetter)) {
                errors.addError(this.urlParam, i18nHelper.getText("navigator.error.query.invalid.start", firstLetter));
            } else if (!this.isQueryValid(query)) {
                errors.addError(this.urlParam, i18nHelper.getText("navigator.error.parse"));
            }
        }
    }

    private boolean isQueryValid(String query) {
        QueryParser qp = this.createQueryParser();
        try {
            qp.parse(query);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    QueryParser createQueryParser() {
        return new QueryParser(DefaultIndexManager.LUCENE_VERSION, SystemSearchConstants.forSummary().getIndexField(), DefaultIndexManager.ANALYZER_FOR_SEARCHING);
    }
}

