/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.AbstractOption;
import com.atlassian.jira.issue.fields.option.IssueConstantOption;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.fields.option.OptionSet;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.util.SearchContextRenderHelper;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.query.Query;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.map.ListOrderedMap;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;

public class IssueTypeSearchRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    private final ConstantsManager constantsManager;
    private final PermissionManager permissionManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final OptionSetManager optionSetManager;
    private final SubTaskManager subTaskManager;

    public IssueTypeSearchRenderer(String searcherNameKey, ConstantsManager constantsManager, PermissionManager permissionManager, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, IssueTypeSchemeManager issueTypeSchemeManager, OptionSetManager optionSetManager, SubTaskManager subTaskManager) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, SystemSearchConstants.forIssueType(), searcherNameKey);
        this.constantsManager = constantsManager;
        this.permissionManager = permissionManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.optionSetManager = optionSetManager;
        this.subTaskManager = subTaskManager;
    }

    public String getEditHtml(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Collection<Option> visibleIssueTypes;
        Map velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        List issueTypes = (List)fieldValuesHolder.get((Object)"type");
        velocityParams.put("selectedIssueTypes", issueTypes != null ? issueTypes : Collections.EMPTY_LIST);
        if (this.isKickass()) {
            visibleIssueTypes = this.getVisibleIssueTypes(user, searchContext);
            SortedSet<Option> invalidIssueTypes = this.getInvalidSelections(issueTypes, visibleIssueTypes, this.getAllOptions());
            if (!invalidIssueTypes.isEmpty()) {
                SearchContextRenderHelper.addSearchContextParams(searchContext, velocityParams);
            }
            velocityParams.put("invalidIssueTypes", invalidIssueTypes);
        } else {
            HashSet<FieldConfig> releventConfigs = new HashSet<FieldConfig>();
            ListOrderedMap projectToConfig = new ListOrderedMap();
            for (GenericValue project : this.getVisibleProjects(user)) {
                FieldConfigScheme configScheme = this.issueTypeSchemeManager.getConfigScheme(project);
                FieldConfig relevantConfig = configScheme.getOneAndOnlyConfig();
                releventConfigs.add(relevantConfig);
                projectToConfig.put(project.getLong("id"), relevantConfig.getId());
            }
            visibleIssueTypes = this.getVisibleIssueTypes(user, releventConfigs);
            velocityParams.put("projectToConfig", projectToConfig);
        }
        HashMap<Option, String> optionsToCss = new HashMap<Option, String>();
        for (Option visibleIssueType : visibleIssueTypes) {
            if (visibleIssueType.getImagePath() == null) continue;
            optionsToCss.put(visibleIssueType, this.getCssClassForOption(visibleIssueType));
        }
        velocityParams.put("visibleIssueTypeStyles", optionsToCss);
        velocityParams.put("visibleIssueTypes", visibleIssueTypes);
        return this.renderEditTemplate("issuetype-searcher-edit.vm", velocityParams);
    }

    private Collection<Option> getVisibleIssueTypes(User searcher, SearchContext searchContext) {
        HashSet<FieldConfig> releventConfigs = new HashSet<FieldConfig>();
        Collection<GenericValue> allProjects = this.getVisibleProjectsForContext(searcher, searchContext);
        for (GenericValue project : allProjects) {
            FieldConfigScheme configScheme = this.issueTypeSchemeManager.getConfigScheme(project);
            FieldConfig relevantConfig = configScheme.getOneAndOnlyConfig();
            releventConfigs.add(relevantConfig);
        }
        return this.getVisibleIssueTypes(searcher, releventConfigs);
    }

    private SortedSet<Option> getInvalidSelections(Collection<String> selectedKeys, Collection<Option> validOptions, Collection<AbstractOption> allOptions) {
        TreeSet<Option> invalidOptions = new TreeSet<Option>();
        if (selectedKeys != null) {
            for (AbstractOption selectListOption : allOptions) {
                if (validOptions.contains(selectListOption) || !selectedKeys.contains(selectListOption.getId())) continue;
                invalidOptions.add((Option)selectListOption);
            }
        }
        return invalidOptions;
    }

    public boolean isShown(User user, SearchContext searchContext) {
        return true;
    }

    public String getViewHtml(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        ArrayList unconvertedIssueTypeIds = new ArrayList((Collection)fieldValuesHolder.get((Object)"type"));
        ArrayList<String> types = new ArrayList<String>();
        if (unconvertedIssueTypeIds != null) {
            if (unconvertedIssueTypeIds.contains("-2")) {
                types.add(this.getI18n(user).getText("common.filters.standardissuetypes"));
                unconvertedIssueTypeIds.remove("-2");
            }
            if (unconvertedIssueTypeIds.contains("-3")) {
                types.add(this.getI18n(user).getText("common.filters.subtaskissuetypes"));
                unconvertedIssueTypeIds.remove("-3");
            }
            if (!unconvertedIssueTypeIds.isEmpty()) {
                Collection visibleIssueTypeIds = Collections2.transform(this.getVisibleIssueTypes(user, searchContext), (Function)new Function<Option, String>(){

                    public String apply(Option option) {
                        return option.getId();
                    }
                });
                HashSet<String> invalidIssueTypes = new HashSet<String>();
                List issueTypes = this.constantsManager.convertToConstantObjects("IssueType", unconvertedIssueTypeIds);
                for (IssueConstant issueType : issueTypes) {
                    String typeName = issueType.getNameTranslation();
                    types.add(typeName);
                    if (visibleIssueTypeIds.contains(issueType.getId())) continue;
                    invalidIssueTypes.add(typeName);
                }
                if (!invalidIssueTypes.isEmpty()) {
                    SearchContextRenderHelper.addSearchContextParams(searchContext, velocityParams);
                }
                velocityParams.put("invalidIssueTypes", invalidIssueTypes);
            }
            velocityParams.put("selectedIssueTypes", types);
        }
        return this.renderViewTemplate("issuetype-searcher-view.vm", velocityParams);
    }

    public boolean isRelevantForQuery(User user, Query query) {
        return this.isRelevantForQuery(SystemSearchConstants.forIssueType().getJqlClauseNames(), query);
    }

    private Collection<GenericValue> getVisibleProjects(User searcher) {
        return this.permissionManager.getProjects(10, searcher);
    }

    private Collection<GenericValue> getVisibleProjectsForContext(User searcher, final SearchContext searchContext) {
        Collection<GenericValue> allProjects = this.getVisibleProjects(searcher);
        if (searchContext.isForAnyProjects()) {
            return allProjects;
        }
        return Collections2.filter(allProjects, (com.google.common.base.Predicate)new com.google.common.base.Predicate<GenericValue>(){

            public boolean apply(@Nullable GenericValue projectGV) {
                Long pid = projectGV.getLong("id");
                return searchContext.getProjectIds().contains(pid);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCssClassForOption(Option option) {
        UtilTimerStack.push((String)"IssueTypeSearchRenderer.getCssClassForOption");
        try {
            Collection allRelatedSchemes = this.issueTypeSchemeManager.getAllRelatedSchemes(option.getId());
            StringBuilder cssClass = new StringBuilder();
            for (FieldConfigScheme configScheme : allRelatedSchemes) {
                FieldConfig config = configScheme.getOneAndOnlyConfig();
                cssClass.append(config.getId()).append(" ");
            }
            String string = cssClass.toString();
            return string;
        }
        finally {
            UtilTimerStack.pop((String)"IssueTypeSearchRenderer.getCssClassForOption");
        }
    }

    private Collection<Option> getVisibleIssueTypes(User searcher, Set<FieldConfig> releventConfigs) {
        List<AbstractOption> optionsList = this.getIssueTypesForConfigs(releventConfigs);
        if (this.subTaskManager.isSubTasksEnabled()) {
            LinkedList<Option> issueTypes = new LinkedList<Option>();
            I18nHelper i18nHelper = this.getI18n(searcher);
            issueTypes.add((Option)new TextOption("-2", i18nHelper.getText("common.filters.standardissuetypes"), "sectionHeaderOption"));
            issueTypes.addAll(CollectionUtils.select(optionsList, (Predicate)IssueConstantOption.STANDARD_OPTIONS_PREDICATE));
            Collection subTaskOptions = CollectionUtils.select(optionsList, (Predicate)IssueConstantOption.SUB_TASK_OPTIONS_PREDICATE);
            if (subTaskOptions != null && !subTaskOptions.isEmpty()) {
                issueTypes.add((Option)new TextOption("-3", i18nHelper.getText("common.filters.subtaskissuetypes"), "sectionHeaderOption"));
                issueTypes.addAll(subTaskOptions);
            }
            return issueTypes;
        }
        return CollectionUtils.select(optionsList, (Predicate)IssueConstantOption.STANDARD_OPTIONS_PREDICATE);
    }

    private List<AbstractOption> getIssueTypesForConfigs(Set<FieldConfig> releventConfigs) {
        HashSet allOptions = new HashSet();
        for (FieldConfig config : releventConfigs) {
            OptionSet optionsForConfig = this.optionSetManager.getOptionsForConfig(config);
            allOptions.addAll(optionsForConfig.getOptions());
        }
        ArrayList<AbstractOption> optionsList = new ArrayList<AbstractOption>(allOptions);
        Collections.sort(optionsList);
        return optionsList;
    }

    private Collection<AbstractOption> getAllOptions() {
        return Collections2.transform((Collection)this.constantsManager.getAllIssueTypeObjects(), (Function)new Function<IssueType, AbstractOption>(){

            public AbstractOption apply(IssueType issueType) {
                return new IssueConstantOption((IssueConstant)issueType);
            }
        });
    }
}

