/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.history;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.history.DateTimeFieldChangeLogHelper;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DateTimeFieldChangeLogHelperImpl
implements DateTimeFieldChangeLogHelper {
    private static final Logger log = Logger.getLogger(DateTimeFieldChangeLogHelperImpl.class);
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    public DateTimeFieldChangeLogHelperImpl(DateTimeFormatterFactory dateTimeFormatterFactory) {
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
    }

    public String createChangelogValueForDateTimeField(Date date) {
        return this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.ISO_8601_DATE_TIME).format(date);
    }

    public String createChangelogValueForDateField(Date date) {
        return this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.ISO_8601_DATE).withSystemZone().format(date);
    }

    public String renderChangeHistoryValueDate(String dateValue, String dateStr) {
        try {
            if (StringUtils.isNotEmpty((String)dateValue)) {
                Date date = this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.ISO_8601_DATE).withSystemZone().parse(dateValue);
                return this.dateTimeFormatterFactory.formatter().forLoggedInUser().withSystemZone().withStyle(DateTimeStyle.DATE).format(date);
            }
            return dateStr;
        }
        catch (IllegalArgumentException ex) {
            log.debug((Object)("Failed to parse change history date string '" + dateStr + "'. Returning unformatted string."));
            return dateStr;
        }
    }

    public String renderChangeHistoryValueDateTime(String dateTimeValue, String dateTimeString) {
        try {
            if (StringUtils.isNotEmpty((String)dateTimeValue)) {
                Date date = this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.ISO_8601_DATE_TIME).parse(dateTimeValue);
                return this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.DATE_TIME_PICKER).forLoggedInUser().format(date);
            }
            return dateTimeString;
        }
        catch (IllegalArgumentException ex) {
            log.debug((Object)("Failed to parse change history date time string '" + dateTimeString + "'. Returning unformatted string."));
            return dateTimeString;
        }
    }
}

