/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.jira.issue.fields.screen.AbstractGVBean;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.operation.IssueOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class FieldScreenSchemeImpl
extends AbstractGVBean
implements FieldScreenScheme {
    private final FieldScreenSchemeManager fieldScreenSchemeManager;
    private Long id;
    private String name;
    private String description;
    private SchemeItems schemeItems = new SchemeItems();

    public FieldScreenSchemeImpl(FieldScreenSchemeManager fieldScreenSchemeManager) {
        this(fieldScreenSchemeManager, null);
    }

    public FieldScreenSchemeImpl(FieldScreenSchemeManager fieldScreenSchemeManager, GenericValue genericValue) {
        this.fieldScreenSchemeManager = fieldScreenSchemeManager;
        this.setGenericValue(genericValue);
    }

    @Override
    protected void init() {
        if (this.getGenericValue() != null) {
            this.id = this.getGenericValue().getLong("id");
            this.name = this.getGenericValue().getString("name");
            this.description = this.getGenericValue().getString("description");
        }
        this.setModified(false);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        if (this.getGenericValue() != null) {
            throw new IllegalStateException("Cannot set id of an exsiting entity.");
        }
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.updateGV("name", name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.updateGV("description", description);
    }

    public Collection<FieldScreenSchemeItem> getFieldScreenSchemeItems() {
        ArrayList<FieldScreenSchemeItem> entities = new ArrayList<FieldScreenSchemeItem>(this.getInternalSchemeItems().values());
        Collections.sort(entities);
        return Collections.unmodifiableCollection(entities);
    }

    protected Map<IssueOperation, FieldScreenSchemeItem> getInternalSchemeItems() {
        if (!this.schemeItems.isInitialized()) {
            this.schemeItems.initialize();
        }
        return this.schemeItems.getSchemeItemsMap();
    }

    public FieldScreenSchemeItem getFieldScreenSchemeItem(IssueOperation issueOperation) {
        return this.getInternalSchemeItems().get(issueOperation);
    }

    public void addFieldScreenSchemeItem(FieldScreenSchemeItem fieldScreenSchemeItem) {
        fieldScreenSchemeItem.setFieldScreenScheme((FieldScreenScheme)this);
        this.getInternalSchemeItems().put((IssueOperation)fieldScreenSchemeItem.getIssueOperation(), fieldScreenSchemeItem);
        this.store();
    }

    public FieldScreenSchemeItem removeFieldScreenSchemeItem(IssueOperation issueOperation) {
        FieldScreenSchemeItem fieldScreenSchemeItem = this.getInternalSchemeItems().remove(issueOperation);
        if (fieldScreenSchemeItem != null) {
            fieldScreenSchemeItem.remove();
        }
        return fieldScreenSchemeItem;
    }

    public FieldScreen getFieldScreen(IssueOperation issueOperation) {
        FieldScreenSchemeItem fieldScreenSchemeItem = this.getFieldScreenSchemeItem(issueOperation);
        if (fieldScreenSchemeItem == null) {
            fieldScreenSchemeItem = this.getFieldScreenSchemeItem(null);
            if (fieldScreenSchemeItem != null) {
                return fieldScreenSchemeItem.getFieldScreen();
            }
            throw new IllegalArgumentException("Cannot determine field screen for operation '" + (issueOperation == null ? "Default Operation" : issueOperation.getNameKey()) + "'.");
        }
        return fieldScreenSchemeItem.getFieldScreen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        if (this.isModified()) {
            if (this.getGenericValue() == null) {
                this.fieldScreenSchemeManager.createFieldScreenScheme((FieldScreenScheme)this);
            } else {
                this.fieldScreenSchemeManager.updateFieldScreenScheme((FieldScreenScheme)this);
            }
        }
        if (this.schemeItems.isInitialized()) {
            Map<IssueOperation, FieldScreenSchemeItem> internalSchemeItems;
            Map<IssueOperation, FieldScreenSchemeItem> map = internalSchemeItems = this.getInternalSchemeItems();
            synchronized (map) {
                for (FieldScreenSchemeItem fieldScreenSchemeItem : internalSchemeItems.values()) {
                    fieldScreenSchemeItem.store();
                }
            }
        }
    }

    public void remove() {
        if (this.id != null) {
            this.fieldScreenSchemeManager.removeFieldSchemeItems((FieldScreenScheme)this);
            this.fieldScreenSchemeManager.removeFieldScreenScheme((FieldScreenScheme)this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldScreenScheme)) {
            return false;
        }
        FieldScreenScheme fieldScreenScheme = (FieldScreenScheme)o;
        return this.safeEquals(this.description, fieldScreenScheme.getDescription()) && this.safeEquals(this.id, fieldScreenScheme.getId()) && this.safeEquals(this.name, fieldScreenScheme.getName());
    }

    private boolean safeEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 29 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    private class SchemeItems {
        protected boolean initialized = false;
        protected Map<IssueOperation, FieldScreenSchemeItem> schemeItems;

        private SchemeItems() {
        }

        public synchronized boolean isInitialized() {
            return this.initialized;
        }

        public synchronized void initialize() {
            this.schemeItems = Collections.synchronizedMap(new HashMap());
            Collection fieldScreenSchemeItems = FieldScreenSchemeImpl.this.fieldScreenSchemeManager.getFieldScreenSchemeItems((FieldScreenScheme)FieldScreenSchemeImpl.this);
            for (FieldScreenSchemeItem fieldScreenSchemeItem : fieldScreenSchemeItems) {
                this.schemeItems.put((IssueOperation)fieldScreenSchemeItem.getIssueOperation(), fieldScreenSchemeItem);
            }
            this.initialized = true;
        }

        public Map<IssueOperation, FieldScreenSchemeItem> getSchemeItemsMap() {
            return this.schemeItems;
        }
    }
}

